/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jomc.mojo.AbstractSourcesManageMojo;
import org.jomc.mojo.Messages;

@Mojo(name="manage-test-sources", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class TestSourcesManageMojo
extends AbstractSourcesManageMojo {
    @Parameter(name="manageTestSourcesExecutionStrategy", property="jomc.manageTestSourcesExecutionStrategy", defaultValue="once-per-session")
    private String manageTestSourcesExecutionStrategy;

    protected String getSourcesModuleName() throws MojoExecutionException {
        return this.getTestModuleName();
    }

    protected ClassLoader getSourcesClassLoader() throws MojoExecutionException {
        return this.getTestClassLoader();
    }

    protected File getSourcesDirectory() throws MojoExecutionException {
        File sourcesDirectory = this.getTestSourceDirectory();
        boolean testCompileSourceRoot = false;
        int l0 = this.getMavenProject().getTestCompileSourceRoots().size();
        for (int i = 0; i < l0; ++i) {
            String element = (String)this.getMavenProject().getTestCompileSourceRoots().get(i);
            if (!sourcesDirectory.equals(this.getAbsoluteFile(element))) continue;
            testCompileSourceRoot = true;
            break;
        }
        if (!testCompileSourceRoot) {
            if (!sourcesDirectory.exists() && !sourcesDirectory.mkdirs()) {
                throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", sourcesDirectory.getAbsolutePath()));
            }
            this.getMavenProject().addTestCompileSourceRoot(sourcesDirectory.getAbsolutePath());
            this.log(Level.INFO, Messages.getMessage("addedTestCompileSourceRoot", sourcesDirectory.getAbsolutePath()), null);
        }
        return sourcesDirectory;
    }

    protected String getGoal() throws MojoExecutionException {
        return "manage-test-sources";
    }

    protected String getExecutionStrategy() throws MojoExecutionException {
        return this.manageTestSourcesExecutionStrategy;
    }
}

