/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.mojo.AbstractJomcMojo;
import org.jomc.mojo.Messages;

@Mojo(name="validate-test-model", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class TestModelValidateMojo
extends AbstractJomcMojo {
    private static final String TOOLNAME = "ModelValidator";
    @Parameter(name="validateTestModelExecutionStrategy", property="jomc.validateTestModelExecutionStrategy", defaultValue="once-per-session")
    private String validateTestModelExecutionStrategy;

    protected void executeTool() throws Exception {
        this.logSeparator();
        this.logProcessingModel(TOOLNAME, this.getModel());
        ModelContext context = this.createModelContext(this.getTestClassLoader());
        ModelValidationReport validationReport = context.validateModel(this.getModel(context));
        this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
        if (!validationReport.isModelValid()) {
            throw new MojoExecutionException(Messages.getMessage("failedValidatingTestModel", new Object[0]));
        }
        this.logToolSuccess(TOOLNAME);
    }

    protected String getGoal() throws MojoExecutionException {
        return "validate-test-model";
    }

    protected String getExecutionStrategy() throws MojoExecutionException {
        return this.validateTestModelExecutionStrategy;
    }
}

