/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jomc.mojo.AbstractSourcesManageMojo;
import org.jomc.mojo.Messages;

@Mojo(name="manage-main-sources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class MainSourcesManageMojo
extends AbstractSourcesManageMojo {
    @Parameter(name="manageMainSourcesExecutionStrategy", property="jomc.manageMainSourcesExecutionStrategy", defaultValue="once-per-session")
    private String manageMainSourcesExecutionStrategy;

    protected String getSourcesModuleName() throws MojoExecutionException {
        return this.getModuleName();
    }

    protected ClassLoader getSourcesClassLoader() throws MojoExecutionException {
        return this.getMainClassLoader();
    }

    protected File getSourcesDirectory() throws MojoExecutionException {
        File sourcesDirectory = this.getSourceDirectory();
        boolean compileSourceRoot = false;
        int l0 = this.getMavenProject().getCompileSourceRoots().size();
        for (int i = 0; i < l0; ++i) {
            String element = (String)this.getMavenProject().getCompileSourceRoots().get(i);
            if (!sourcesDirectory.equals(this.getAbsoluteFile(element))) continue;
            compileSourceRoot = true;
            break;
        }
        if (!compileSourceRoot) {
            if (!sourcesDirectory.exists() && !sourcesDirectory.mkdirs()) {
                throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", sourcesDirectory.getAbsolutePath()));
            }
            this.getMavenProject().addCompileSourceRoot(sourcesDirectory.getAbsolutePath());
            this.log(Level.INFO, Messages.getMessage("addedCompileSourceRoot", sourcesDirectory.getAbsolutePath()), null);
        }
        return sourcesDirectory;
    }

    protected String getGoal() throws MojoExecutionException {
        return "manage-main-sources";
    }

    protected String getExecutionStrategy() throws MojoExecutionException {
        return this.manageMainSourcesExecutionStrategy;
    }
}

