/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.mojo.AbstractJomcMojo;
import org.jomc.mojo.Messages;

@Mojo(name="validate-main-model", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class MainModelValidateMojo
extends AbstractJomcMojo {
    private static final String TOOLNAME = "ModelValidator";
    @Parameter(name="validateMainModelExecutionStrategy", property="jomc.validateMainModelExecutionStrategy", defaultValue="once-per-session")
    private String validateMainModelExecutionStrategy;

    protected void executeTool() throws Exception {
        this.logSeparator();
        this.logProcessingModel(TOOLNAME, this.getModel());
        ModelContext context = this.createModelContext(this.getMainClassLoader());
        ModelValidationReport validationReport = context.validateModel(this.getModel(context));
        this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
        if (!validationReport.isModelValid()) {
            throw new MojoExecutionException(Messages.getMessage("failedValidatingMainModel", new Object[0]));
        }
        this.logToolSuccess(TOOLNAME);
    }

    protected String getGoal() throws MojoExecutionException {
        return "validate-main-model";
    }

    protected String getExecutionStrategy() throws MojoExecutionException {
        return this.validateMainModelExecutionStrategy;
    }
}

