/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.jomc.model.ModelObject;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.ObjectFactory;
import org.jomc.model.modlet.DefaultModelProvider;
import org.jomc.modlet.DefaultModletProvider;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.Modlet;
import org.jomc.modlet.ModletObject;
import org.jomc.modlet.Modlets;
import org.jomc.mojo.Messages;
import org.jomc.mojo.ModelContextAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JomcResourceTransformer
extends AbstractLogEnabled
implements ResourceTransformer {
    private static final String LOG_PREFIX = "[JOMC] ";
    private String model = "http://jomc.org/model";
    private String moduleEncoding;
    private String moduleName;
    private String moduleVersion;
    private String moduleVendor;
    private String moduleResource = DefaultModelProvider.getDefaultModuleLocation();
    private String[] moduleResources = new String[]{DefaultModelProvider.getDefaultModuleLocation()};
    private List<String> moduleIncludes;
    private List<String> moduleExcludes;
    private String modletEncoding;
    private String modletName;
    private String modletVersion;
    private String modletVendor;
    private String modletResource = DefaultModletProvider.getDefaultModletLocation();
    private String[] modletResources = new String[]{DefaultModletProvider.getDefaultModletLocation()};
    private List<String> modletIncludes;
    private List<String> modletExcludes;
    private String modelObjectStylesheet;
    private String modletObjectStylesheet;
    private String providerLocation;
    private String platformProviderLocation;
    private String modletSchemaSystemId;
    private String modletLocation;
    private String modelContextFactoryClassName;
    private List<ModelContextAttribute> modelContextAttributes;
    private Modlets modlets = new Modlets();
    private Modules modules = new Modules();
    private ResourceType currentResourceType;
    private Marshaller jomcMarshaller;
    private Unmarshaller jomcUnmarshaller;
    private Marshaller modletMarshaller;
    private Unmarshaller modletUnmarshaller;

    public boolean canTransformResource(String arg) {
        boolean transformable = false;
        this.currentResourceType = null;
        String name = JomcResourceTransformer.normalizeResourceName(arg);
        if (name != null) {
            if (this.moduleResources != null) {
                for (String r : this.moduleResources) {
                    if (!name.equals(JomcResourceTransformer.normalizeResourceName(r))) continue;
                    this.currentResourceType = ResourceType.MODEL_OBJECT_RESOURCE;
                    if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(LOG_PREFIX + Messages.getMessage("processingModuleResource", arg));
                    }
                    transformable = true;
                    break;
                }
            }
            if (!transformable && this.modletResources != null) {
                for (String r : this.modletResources) {
                    if (!name.equals(JomcResourceTransformer.normalizeResourceName(r))) continue;
                    this.currentResourceType = ResourceType.MODLET_OBJECT_RESOURCE;
                    if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(LOG_PREFIX + Messages.getMessage("processingModletResource", arg));
                    }
                    transformable = true;
                    break;
                }
            }
            if (!transformable && (name.equals(JomcResourceTransformer.normalizeResourceName(this.modletResource)) || name.equals(JomcResourceTransformer.normalizeResourceName(this.moduleResource)))) {
                if (this.getLogger() != null && this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(LOG_PREFIX + Messages.getMessage("overridingResource", arg));
                }
                transformable = true;
                this.currentResourceType = null;
            }
        }
        return transformable;
    }

    public void processResource(InputStream in) throws IOException {
        block15: {
            try {
                if (in == null || this.currentResourceType == null) break block15;
                switch (this.currentResourceType) {
                    case MODEL_OBJECT_RESOURCE: {
                        Object modelObject = this.unmarshalModelObject(in);
                        if (modelObject instanceof JAXBElement) {
                            modelObject = ((JAXBElement)modelObject).getValue();
                        }
                        if (modelObject instanceof Modules) {
                            this.modules.getModule().addAll(((Modules)modelObject).getModule());
                        }
                        if (modelObject instanceof Module) {
                            this.modules.getModule().add((Module)modelObject);
                        }
                        break;
                    }
                    case MODLET_OBJECT_RESOURCE: {
                        Object modletObject = this.unmarshalModletObject(in);
                        if (modletObject instanceof JAXBElement) {
                            modletObject = ((JAXBElement)modletObject).getValue();
                        }
                        if (modletObject instanceof Modlets) {
                            this.modlets.getModlet().addAll(((Modlets)modletObject).getModlet());
                        }
                        if (modletObject instanceof Modlet) {
                            this.modlets.getModlet().add((Modlet)modletObject);
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)this.currentResourceType);
                    }
                }
            }
            catch (InstantiationException e) {
                throw (IOException)new IOException(Messages.getMessage(e)).initCause(e);
            }
            catch (JAXBException e) {
                String message = Messages.getMessage(e);
                if (message == null && e.getLinkedException() != null) {
                    message = Messages.getMessage(e.getLinkedException());
                }
                throw (IOException)new IOException(message).initCause(e);
            }
            catch (ModelException e) {
                throw (IOException)new IOException(Messages.getMessage(e)).initCause(e);
            }
        }
    }

    public void processResource(String name, InputStream in, List<Relocator> relocators) throws IOException {
        this.processResource(in);
    }

    public boolean hasTransformedResource() {
        return !this.modules.getModule().isEmpty() || !this.modlets.getModlet().isEmpty();
    }

    public void modifyOutputStream(JarOutputStream out) throws IOException {
        if (StringUtils.isEmpty((String)this.model)) {
            throw new IOException(Messages.getMessage("mandatoryParameter", "model"));
        }
        if (StringUtils.isEmpty((String)this.modletName)) {
            throw new IOException(Messages.getMessage("mandatoryParameter", "modletName"));
        }
        if (StringUtils.isEmpty((String)this.modletResource)) {
            throw new IOException(Messages.getMessage("mandatoryParameter", "modletResource"));
        }
        if (StringUtils.isEmpty((String)this.moduleName)) {
            throw new IOException(Messages.getMessage("mandatoryParameter", "moduleName"));
        }
        if (StringUtils.isEmpty((String)this.moduleResource)) {
            throw new IOException(Messages.getMessage("mandatoryParameter", "moduleResource"));
        }
        try {
            Module excluded;
            Module m2;
            Iterator it;
            if (!this.modules.getModule().isEmpty()) {
                if (this.moduleIncludes != null) {
                    it = this.modules.getModule().iterator();
                    while (it.hasNext()) {
                        m2 = (Module)it.next();
                        if (this.moduleIncludes.contains(m2.getName())) continue;
                        it.remove();
                        if (this.getLogger() == null || !this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("excludingModule", m2.getName()));
                    }
                }
                if (this.moduleExcludes != null) {
                    for (String exclude : this.moduleExcludes) {
                        excluded = this.modules.getModule(exclude);
                        if (excluded == null) continue;
                        this.modules.getModule().remove(excluded);
                        if (this.getLogger() == null || !this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("excludingModule", excluded.getName()));
                    }
                }
                if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
                    for (Module m2 : this.modules.getModule()) {
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("includingModule", m2.getName()));
                    }
                }
                Module mergedModule = this.modules.getMergedModule(this.moduleName);
                mergedModule.setVersion(this.moduleVersion);
                mergedModule.setVendor(this.moduleVendor);
                JAXBElement<Module> transformedModule = this.transformModelObject((JAXBElement<? extends ModelObject>)new ObjectFactory().createModule(mergedModule), Module.class);
                out.putNextEntry(new JarEntry(JomcResourceTransformer.normalizeResourceName(this.moduleResource)));
                this.marshalModelObject(transformedModule, out);
            }
            if (!this.modlets.getModlet().isEmpty()) {
                if (this.modletIncludes != null) {
                    it = this.modlets.getModlet().iterator();
                    while (it.hasNext()) {
                        m2 = (Modlet)it.next();
                        if (this.modletIncludes.contains(m2.getName())) continue;
                        it.remove();
                        if (this.getLogger() == null || !this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("excludingModlet", m2.getName()));
                    }
                }
                if (this.modletExcludes != null) {
                    for (String exclude : this.modletExcludes) {
                        excluded = this.modlets.getModlet(exclude);
                        if (excluded == null) continue;
                        this.modlets.getModlet().remove(excluded);
                        if (this.getLogger() == null || !this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("excludingModlet", excluded.getName()));
                    }
                }
                if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
                    for (Module m2 : this.modlets.getModlet()) {
                        this.getLogger().info(LOG_PREFIX + Messages.getMessage("includingModlet", m2.getName()));
                    }
                }
                Modlet mergedModlet = this.modlets.getMergedModlet(this.modletName, this.model);
                mergedModlet.setVendor(this.modletVendor);
                mergedModlet.setVersion(this.modletVersion);
                JAXBElement<Modlet> transformedModlet = this.transformModletObject((JAXBElement<? extends ModletObject>)new org.jomc.modlet.ObjectFactory().createModlet(mergedModlet), Modlet.class);
                out.putNextEntry(new JarEntry(JomcResourceTransformer.normalizeResourceName(this.modletResource)));
                this.marshalModletObject(transformedModlet, out);
            }
        }
        catch (InstantiationException e) {
            throw (IOException)new IOException(Messages.getMessage(e)).initCause(e);
        }
        catch (TransformerConfigurationException e) {
            String message = Messages.getMessage(e);
            if (message == null && e.getException() != null) {
                message = Messages.getMessage(e.getException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (TransformerException e) {
            String message = Messages.getMessage(e);
            if (message == null && e.getException() != null) {
                message = Messages.getMessage(e.getException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (JAXBException e) {
            String message = Messages.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = Messages.getMessage(e.getLinkedException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(Messages.getMessage(e)).initCause(e);
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException(Messages.getMessage(e)).initCause(e);
        }
        finally {
            this.modlets = new Modlets();
            this.modules = new Modules();
            this.jomcMarshaller = null;
            this.jomcUnmarshaller = null;
            this.modletMarshaller = null;
            this.modletUnmarshaller = null;
        }
    }

    protected URL getResource(String location) throws IOException {
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            File f;
            URL resource;
            String absolute = location;
            if (!absolute.startsWith("/")) {
                absolute = "/" + location;
            }
            if ((resource = ((Object)((Object)this)).getClass().getResource(absolute)) == null) {
                try {
                    resource = new URL(location);
                }
                catch (MalformedURLException e) {
                    if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(Messages.getMessage(e), (Throwable)e);
                    }
                    resource = null;
                }
            }
            if (resource == null && (f = new File(location)).isFile()) {
                resource = f.toURI().toURL();
            }
            if (resource == null) {
                throw new IOException(Messages.getMessage("resourceNotFound", location));
            }
            return resource;
        }
        catch (MalformedURLException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw (IOException)new IOException(Messages.getMessage("malformedLocation", location, m)).initCause(e);
        }
    }

    private Object unmarshalModelObject(InputStream in) throws ModelException, JAXBException, InstantiationException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (this.jomcUnmarshaller == null) {
            this.jomcUnmarshaller = this.createModelContext().createUnmarshaller(this.model);
        }
        return this.jomcUnmarshaller.unmarshal(in);
    }

    private void marshalModelObject(JAXBElement<? extends ModelObject> element, OutputStream out) throws ModelException, JAXBException, InstantiationException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (this.jomcMarshaller == null) {
            ModelContext modelContext = this.createModelContext();
            this.jomcMarshaller = modelContext.createMarshaller(this.model);
            this.jomcMarshaller.setSchema(modelContext.createSchema(this.model));
            this.jomcMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (this.moduleEncoding != null) {
                this.jomcMarshaller.setProperty("jaxb.encoding", (Object)this.moduleEncoding);
            }
        }
        this.jomcMarshaller.marshal(element, out);
    }

    private <T> JAXBElement<T> transformModelObject(JAXBElement<? extends ModelObject> element, Class<T> boundType) throws ModelException, TransformerException, JAXBException, IOException, URISyntaxException, InstantiationException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (!boundType.isInstance(element.getValue())) {
            throw new IllegalArgumentException(element.toString());
        }
        JAXBElement transformed = element;
        if (this.modelObjectStylesheet != null) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(this.getResource(this.modelObjectStylesheet).toURI().toASCIIString()));
            ModelContext modelContext = this.createModelContext();
            Marshaller marshaller = modelContext.createMarshaller(this.model);
            Unmarshaller unmarshaller = modelContext.createUnmarshaller(this.model);
            JAXBSource source = new JAXBSource(marshaller, element);
            JAXBResult result = new JAXBResult(unmarshaller);
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                transformer.setParameter(e.getKey().toString(), e.getValue());
            }
            transformer.transform((Source)source, (Result)result);
            if (result.getResult() instanceof JAXBElement && boundType.isInstance(((JAXBElement)result.getResult()).getValue())) {
                JAXBElement e;
                transformed = e = (JAXBElement)result.getResult();
            } else {
                throw new ModelException(Messages.getMessage("illegalModuleTransformationResult", this.modelObjectStylesheet));
            }
        }
        return transformed;
    }

    private Object unmarshalModletObject(InputStream in) throws ModelException, JAXBException, InstantiationException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (this.modletUnmarshaller == null) {
            this.modletUnmarshaller = this.createModelContext().createUnmarshaller("http://jomc.org/modlet");
        }
        return this.modletUnmarshaller.unmarshal(in);
    }

    private void marshalModletObject(JAXBElement<? extends ModletObject> element, OutputStream out) throws ModelException, JAXBException, InstantiationException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (this.modletMarshaller == null) {
            ModelContext modletContext = this.createModelContext();
            this.modletMarshaller = modletContext.createMarshaller("http://jomc.org/modlet");
            this.modletMarshaller.setSchema(modletContext.createSchema("http://jomc.org/modlet"));
            this.modletMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (this.modletEncoding != null) {
                this.modletMarshaller.setProperty("jaxb.encoding", (Object)this.modletEncoding);
            }
        }
        this.modletMarshaller.marshal(element, out);
    }

    private <T> JAXBElement<T> transformModletObject(JAXBElement<? extends ModletObject> element, Class<T> boundType) throws ModelException, TransformerException, JAXBException, IOException, URISyntaxException, InstantiationException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (!boundType.isInstance(element.getValue())) {
            throw new IllegalArgumentException(element.toString());
        }
        JAXBElement transformed = element;
        if (this.modletObjectStylesheet != null) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(this.getResource(this.modletObjectStylesheet).toURI().toASCIIString()));
            ModelContext modletContext = this.createModelContext();
            Marshaller marshaller = modletContext.createMarshaller("http://jomc.org/modlet");
            Unmarshaller unmarshaller = modletContext.createUnmarshaller("http://jomc.org/modlet");
            JAXBSource source = new JAXBSource(marshaller, element);
            JAXBResult result = new JAXBResult(unmarshaller);
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                transformer.setParameter(e.getKey().toString(), e.getValue());
            }
            transformer.transform((Source)source, (Result)result);
            if (result.getResult() instanceof JAXBElement && boundType.isInstance(((JAXBElement)result.getResult()).getValue())) {
                JAXBElement e;
                transformed = e = (JAXBElement)result.getResult();
            } else {
                throw new ModelException(Messages.getMessage("illegalModletTransformationResult", this.modletObjectStylesheet));
            }
        }
        return transformed;
    }

    private static String normalizeResourceName(String name) {
        String normalized = name;
        if (normalized != null) {
            if ((normalized = normalized.replace('\\', '/')).startsWith("/")) {
                normalized = normalized.substring(1);
            }
            if (normalized.endsWith("/")) {
                normalized = normalized.substring(0, normalized.length());
            }
        }
        return normalized;
    }

    private ModelContext createModelContext() throws ModelException, InstantiationException {
        ModelContextFactory modelContextFactory = this.modelContextFactoryClassName != null ? ModelContextFactory.newInstance((String)this.modelContextFactoryClassName) : ModelContextFactory.newInstance();
        ModelContext modelContext = modelContextFactory.newModelContext();
        modelContext.setModletSchemaSystemId(this.modletSchemaSystemId);
        if (this.providerLocation != null) {
            modelContext.setAttribute("org.jomc.modlet.DefaultModelContext.providerLocationAttribute", (Object)this.providerLocation);
        }
        if (this.platformProviderLocation != null) {
            modelContext.setAttribute("org.jomc.modlet.DefaultModelContext.platformProviderLocationAttribute", (Object)this.platformProviderLocation);
        }
        if (this.modletLocation != null) {
            modelContext.setAttribute("org.jomc.modlet.DefaultModletProvider.modletLocationAttribute", (Object)this.modletLocation);
        }
        if (this.modelContextAttributes != null) {
            for (ModelContextAttribute e : this.modelContextAttributes) {
                Object object = e.getObject(modelContext);
                if (object != null) {
                    modelContext.setAttribute(e.getKey(), object);
                    continue;
                }
                modelContext.clearAttribute(e.getKey());
            }
        }
        return modelContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResourceType {
        MODEL_OBJECT_RESOURCE,
        MODLET_OBJECT_RESOURCE;

    }
}

