/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.maven.plugin.MojoExecutionException;
import org.jomc.model.Module;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.ObjectFactory;
import org.jomc.mojo.AbstractJomcMojo;
import org.jomc.mojo.Messages;
import org.jomc.tools.SourceFileProcessor;

public abstract class AbstractSourcesManageMojo
extends AbstractJomcMojo {
    private static final String TOOLNAME = "SourceFileProcessor";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void executeTool() throws Exception {
        this.logSeparator();
        if (this.isSourceProcessingEnabled()) {
            Module module;
            this.logProcessingModule(TOOLNAME, this.getSourcesModuleName());
            ModelContext context = this.createModelContext(this.getSourcesClassLoader());
            SourceFileProcessor tool = this.createSourceFileProcessor(context);
            JAXBContext jaxbContext = context.createContext(this.getModel());
            JAXBSource source = new JAXBSource(jaxbContext, (Object)new ObjectFactory().createModel(tool.getModel()));
            ModelValidationReport validationReport = context.validateModel(this.getModel(), (Source)source);
            this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
            if (!validationReport.isModelValid()) throw new MojoExecutionException(Messages.getMessage("sourceProcessingFailure", new Object[0]));
            Module module2 = module = tool.getModules() != null ? tool.getModules().getModule(this.getSourcesModuleName()) : null;
            if (module != null) {
                tool.manageSourceFiles(module, this.getSourcesDirectory());
                this.logToolSuccess(TOOLNAME);
                return;
            } else {
                this.logMissingModule(this.getSourcesModuleName());
            }
            return;
        } else {
            if (!this.isLoggable(Level.INFO)) return;
            this.log(Level.INFO, Messages.getMessage("sourceProcessingDisabled", new Object[0]), null);
        }
    }

    protected abstract String getSourcesModuleName() throws MojoExecutionException;

    protected abstract ClassLoader getSourcesClassLoader() throws MojoExecutionException;

    protected abstract File getSourcesDirectory() throws MojoExecutionException;
}

