/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jomc.model.Module;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.ObjectFactory;
import org.jomc.mojo.AbstractJomcMojo;
import org.jomc.mojo.Messages;
import org.jomc.tools.ResourceFileProcessor;

public abstract class AbstractResourcesWriteMojo
extends AbstractJomcMojo {
    private static final String TOOLNAME = "ResourceFileProcessor";
    @Parameter(name="resourceBundleDefaultLanguage", property="jomc.resourceBundleDefaultLanguage")
    private String resourceBundleDefaultLanguage;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void executeTool() throws Exception {
        this.logSeparator();
        if (this.isResourceProcessingEnabled()) {
            Module module;
            this.logProcessingModule(TOOLNAME, this.getResourcesModuleName());
            ModelContext context = this.createModelContext(this.getResourcesClassLoader());
            ResourceFileProcessor tool = this.createResourceFileProcessor(context);
            JAXBContext jaxbContext = context.createContext(this.getModel());
            JAXBSource source = new JAXBSource(jaxbContext, (Object)new ObjectFactory().createModel(tool.getModel()));
            ModelValidationReport validationReport = context.validateModel(this.getModel(), (Source)source);
            if (this.resourceBundleDefaultLanguage != null) {
                tool.setResourceBundleDefaultLocale(new Locale(this.resourceBundleDefaultLanguage.toLowerCase(Locale.ENGLISH)));
            }
            this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
            if (!validationReport.isModelValid()) throw new MojoExecutionException(Messages.getMessage("resourceProcessingFailure", new Object[0]));
            Module module2 = module = tool.getModules() != null ? tool.getModules().getModule(this.getResourcesModuleName()) : null;
            if (module != null) {
                if (!this.getResourcesDirectory().exists() && !this.getResourcesDirectory().mkdirs()) {
                    throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", this.getResourcesDirectory().getAbsolutePath()));
                }
                tool.writeResourceBundleResourceFiles(module, this.getResourcesDirectory());
                if (!this.getResourcesDirectory().equals(this.getResourcesOutputDirectory())) {
                    this.copyDirectory(this.getResourcesDirectory(), this.getResourcesOutputDirectory());
                }
                Resource resource = new Resource();
                resource.setDirectory(this.getResourcesDirectory().getAbsolutePath());
                resource.setFiltering(false);
                this.addMavenResource(this.getMavenProject(), resource);
                this.logToolSuccess(TOOLNAME);
                return;
            } else {
                this.logMissingModule(this.getResourcesModuleName());
            }
            return;
        } else {
            if (!this.isLoggable(Level.INFO)) return;
            this.log(Level.INFO, Messages.getMessage("resourceProcessingDisabled", new Object[0]), null);
        }
    }

    protected abstract String getResourcesModuleName() throws MojoExecutionException;

    protected abstract ClassLoader getResourcesClassLoader() throws MojoExecutionException;

    protected abstract File getResourcesDirectory() throws MojoExecutionException;

    protected abstract File getResourcesOutputDirectory() throws MojoExecutionException;

    protected abstract void addMavenResource(MavenProject var1, Resource var2) throws MojoExecutionException;
}

