/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.Modlet;
import org.jomc.modlet.Modlets;
import org.jomc.mojo.KeyValueType;
import org.jomc.mojo.LocaleType;
import org.jomc.mojo.Messages;
import org.jomc.mojo.ModelContextAttribute;
import org.jomc.mojo.PropertiesResourceType;
import org.jomc.mojo.ResourceType;
import org.jomc.mojo.TemplateParameter;
import org.jomc.mojo.TemplateParameterResource;
import org.jomc.mojo.TransformationOutputProperty;
import org.jomc.mojo.TransformationParameter;
import org.jomc.mojo.TransformationParameterResource;
import org.jomc.mojo.TransformerResourceType;
import org.jomc.mojo.VelocityProperty;
import org.jomc.mojo.VelocityPropertyResource;
import org.jomc.tools.ClassFileProcessor;
import org.jomc.tools.JomcTool;
import org.jomc.tools.ResourceFileProcessor;
import org.jomc.tools.SourceFileProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJomcMojo
extends AbstractMojo {
    @Parameter(name="sourceEncoding", property="jomc.sourceEncoding", defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Deprecated
    @Parameter(name="templateEncoding", property="jomc.templateEncoding")
    private String templateEncoding;
    @Parameter(name="defaultTemplateEncoding", property="jomc.defaultTemplateEncoding")
    private String defaultTemplateEncoding;
    @Parameter(name="templateLocation", property="jomc.templateLocation")
    private String templateLocation;
    @Parameter(name="templateProfile", property="jomc.templateProfile")
    private String templateProfile;
    @Parameter(name="defaultTemplateProfile", property="jomc.defaultTemplateProfile")
    private String defaultTemplateProfile;
    @Parameter(name="providerLocation", property="jomc.providerLocation")
    private String providerLocation;
    @Parameter(name="platformProviderLocation", property="jomc.platformProviderLocation")
    private String platformProviderLocation;
    @Parameter(name="model", property="jomc.model", defaultValue="http://jomc.org/model")
    private String model;
    @Parameter(name="modelContextFactoryClassName", property="jomc.modelContextFactoryClassName")
    private String modelContextFactoryClassName;
    @Parameter(name="modletLocation", property="jomc.modletLocation")
    private String modletLocation;
    @Parameter(name="modletSchemaSystemId", property="jomc.modletSchemaSystemId")
    private String modletSchemaSystemId;
    @Parameter(name="moduleLocation", property="jomc.moduleLocation")
    private String moduleLocation;
    @Parameter(name="transformerLocation", property="jomc.transformerLocation")
    private String transformerLocation;
    @Parameter(name="indentation", property="jomc.indentation")
    private String indentation;
    @Parameter(name="lineSeparator", property="jomc.lineSeparator")
    private String lineSeparator;
    @Parameter(name="locale")
    private LocaleType locale;
    @Parameter(name="verbose", property="jomc.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(name="sourceProcessingEnabled", property="jomc.sourceProcessing", defaultValue="true")
    private boolean sourceProcessingEnabled;
    @Parameter(name="resourceProcessingEnabled", property="jomc.resourceProcessing", defaultValue="true")
    private boolean resourceProcessingEnabled;
    @Parameter(name="classProcessingEnabled", property="jomc.classProcessing", defaultValue="true")
    private boolean classProcessingEnabled;
    @Parameter(name="modelProcessingEnabled", property="jomc.modelProcessing", defaultValue="true")
    private boolean modelProcessingEnabled;
    @Parameter(name="modelObjectClasspathResolutionEnabled", property="jomc.modelObjectClasspathResolution", defaultValue="true")
    private boolean modelObjectClasspathResolutionEnabled;
    @Parameter(name="moduleName", property="jomc.moduleName", defaultValue="${project.name}")
    private String moduleName;
    @Parameter(name="testModuleName", property="jomc.testModuleName", defaultValue="${project.name} Tests")
    private String testModuleName;
    @Deprecated
    @Parameter(name="classesDirectory")
    private String classesDirectory;
    @Deprecated
    @Parameter(name="testClassesDirectory")
    private String testClassesDirectory;
    @Parameter(name="outputDirectory", property="jomc.outputDirectory", defaultValue="${project.build.outputDirectory}")
    private String outputDirectory;
    @Parameter(name="testOutputDirectory", property="jomc.testOutputDirectory", defaultValue="${project.build.testOutputDirectory}")
    private String testOutputDirectory;
    @Parameter(name="sourceDirectory", property="jomc.sourceDirectory", defaultValue="${project.build.sourceDirectory}")
    private String sourceDirectory;
    @Parameter(name="testSourceDirectory", property="jomc.testSourceDirectory", defaultValue="${project.build.testSourceDirectory}")
    private String testSourceDirectory;
    @Parameter(name="sessionDirectory", property="jomc.sessionDirectory", defaultValue="${project.build.directory}/jomc-sessions")
    private String sessionDirectory;
    @Parameter(name="reportOutputDirectory", property="jomc.reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}")
    private String reportOutputDirectory;
    @Parameter(name="velocityProperties")
    private List<VelocityProperty> velocityProperties;
    @Parameter(name="velocityPropertyResources")
    private List<VelocityPropertyResource> velocityPropertyResources;
    @Parameter(name="templateParameters")
    private List<TemplateParameter> templateParameters;
    @Parameter(name="templateParameterResources")
    private List<TemplateParameterResource> templateParameterResources;
    @Parameter(name="transformationParameters")
    private List<TransformationParameter> transformationParameters;
    @Parameter(name="transformationOutputProperties")
    private List<TransformationOutputProperty> transformationOutputProperties;
    @Parameter(name="transformationParameterResources")
    private List<TransformationParameterResource> transformationParameterResources;
    @Parameter(name="classFileProcessorClassName", property="jomc.classFileProcessorClassName", defaultValue="org.jomc.tools.ClassFileProcessor")
    private String classFileProcessorClassName;
    @Parameter(name="resourceFileProcessorClassName", property="jomc.resourceFileProcessorClassName", defaultValue="org.jomc.tools.ResourceFileProcessor")
    private String resourceFileProcessorClassName;
    @Parameter(name="sourceFileProcessorClassName", property="jomc.sourceFileProcessorClassName", defaultValue="org.jomc.tools.SourceFileProcessor")
    private String sourceFileProcessorClassName;
    @Parameter(name="modelContextAttributes")
    private List<ModelContextAttribute> modelContextAttributes;
    @Parameter(name="modelResourceValidationEnabled", property="jomc.modelResourceValidationEnabled", defaultValue="true")
    private boolean modelResourceValidationEnabled;
    @Parameter(name="modletResourceValidationEnabled", property="jomc.modletResourceValidationEnabled", defaultValue="true")
    private boolean modletResourceValidationEnabled;
    @Parameter(name="javaValidationEnabled", property="jomc.javaValidationEnabled", defaultValue="true")
    private boolean javaValidationEnabled;
    @Parameter(name="modletExcludes", property="jomc.modletExcludes")
    private List<String> modletExcludes;
    @Parameter(name="modletIncludes", property="jomc.modletIncludes")
    private List<String> modletIncludes;
    @Parameter(name="threads", property="jomc.threads", defaultValue="1.0C")
    private String threads;
    @Parameter(name="mavenProject", defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(name="pluginArtifacts", defaultValue="${plugin.artifacts}", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(name="mavenSession", defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    private ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.assertValidParameters();
        try {
            this.logSeparator();
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, Messages.getMessage("title", new Object[0]), null);
            }
            if (this.isExecutionPermitted()) {
                this.executeTool();
            } else if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, Messages.getMessage("executionSuppressed", this.getExecutionStrategy()), null);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(Messages.getMessage(e), e);
        }
        finally {
            try {
                JomcTool.setDefaultTemplateProfile(null);
                this.logSeparator();
            }
            finally {
                if (this.executorService != null) {
                    this.executorService.shutdown();
                    this.executorService = null;
                }
            }
        }
    }

    protected void assertValidParameters() throws MojoFailureException {
        this.assertValidResources(this.templateParameterResources);
        this.assertValidResources(this.transformationParameterResources);
        this.assertValidResources(this.velocityPropertyResources);
    }

    protected final void assertValidResources(Collection<? extends ResourceType> resources) throws MojoFailureException {
        if (resources != null) {
            for (ResourceType resourceType : resources) {
                PropertiesResourceType p;
                if (resourceType.getLocation() == null) {
                    throw new MojoFailureException(Messages.getMessage("mandatoryParameter", "location"));
                }
                if (!(resourceType instanceof PropertiesResourceType) || PropertiesResourceType.isFormatSupported((p = (PropertiesResourceType)resourceType).getFormat())) continue;
                throw new MojoFailureException(Messages.getMessage("illegalPropertiesFormat", p.getFormat(), StringUtils.join(PropertiesResourceType.getSupportedFormats(), (char)',')));
            }
        }
    }

    protected abstract void executeTool() throws Exception;

    protected abstract String getGoal() throws MojoExecutionException;

    protected abstract String getExecutionStrategy() throws MojoExecutionException;

    protected boolean isExecutionPermitted() throws MojoExecutionException {
        try {
            boolean permitted = true;
            if ("once-per-session".equals(this.getExecutionStrategy())) {
                File flagFile = new File(this.getSessionDirectory(), ArtifactUtils.versionlessKey((Artifact)this.getMavenProject().getArtifact()).hashCode() + "-" + this.getGoal() + "-" + this.getMavenSession().getStartTime().getTime() + ".flg");
                if (!this.getSessionDirectory().exists() && !this.getSessionDirectory().mkdirs()) {
                    throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", this.getSessionDirectory().getAbsolutePath()));
                }
                permitted = flagFile.createNewFile();
            }
            return permitted;
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
        }
    }

    protected final ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Double parallelism = this.threads != null ? (this.threads.toLowerCase(new Locale("")).contains("c") ? Double.valueOf(this.threads.toLowerCase(new Locale("")).replace("c", "")) * (double)Runtime.getRuntime().availableProcessors() : Double.valueOf(this.threads)) : 0.0;
            if (parallelism.intValue() > 1) {
                this.executorService = Executors.newFixedThreadPool(parallelism.intValue(), new ThreadFactory(){
                    private final ThreadGroup group;
                    private final AtomicInteger threadNumber = new AtomicInteger(1);
                    {
                        SecurityManager s = System.getSecurityManager();
                        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                    }

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(this.group, r, "maven-jomc-plugin-" + this.threadNumber.getAndIncrement(), 0L);
                        if (t.isDaemon()) {
                            t.setDaemon(false);
                        }
                        if (t.getPriority() != 5) {
                            t.setPriority(5);
                        }
                        return t;
                    }
                });
            }
        }
        return this.executorService;
    }

    protected MavenProject getMavenProject() throws MojoExecutionException {
        return this.mavenProject;
    }

    protected MavenSession getMavenSession() throws MojoExecutionException {
        return this.mavenSession;
    }

    protected File getAbsoluteFile(String name) throws MojoExecutionException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.getMavenProject().getBasedir(), name);
        }
        return file;
    }

    protected File getOutputDirectory() throws MojoExecutionException {
        File dir;
        if (this.classesDirectory != null) {
            if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, Messages.getMessage("deprecationWarning", "classesDirectory", "outputDirectory"), null);
            }
            if (!this.classesDirectory.equals(this.outputDirectory)) {
                if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, Messages.getMessage("ignoringParameter", "outputDirectory"), null);
                }
                this.outputDirectory = this.classesDirectory;
            }
            this.classesDirectory = null;
        }
        if (!(dir = this.getAbsoluteFile(this.outputDirectory)).exists() && !dir.mkdirs()) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", dir.getAbsolutePath()));
        }
        return dir;
    }

    protected File getTestOutputDirectory() throws MojoExecutionException {
        File dir;
        if (this.testClassesDirectory != null) {
            if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, Messages.getMessage("deprecationWarning", "testClassesDirectory", "testOutputDirectory"), null);
            }
            if (!this.testClassesDirectory.equals(this.testOutputDirectory)) {
                if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, Messages.getMessage("ignoringParameter", "testOutputDirectory"), null);
                }
                this.testOutputDirectory = this.testClassesDirectory;
            }
            this.testClassesDirectory = null;
        }
        if (!(dir = this.getAbsoluteFile(this.testOutputDirectory)).exists() && !dir.mkdirs()) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", dir.getAbsolutePath()));
        }
        return dir;
    }

    protected File getSourceDirectory() throws MojoExecutionException {
        return this.getAbsoluteFile(this.sourceDirectory);
    }

    protected File getTestSourceDirectory() throws MojoExecutionException {
        return this.getAbsoluteFile(this.testSourceDirectory);
    }

    protected File getSessionDirectory() throws MojoExecutionException {
        return this.getAbsoluteFile(this.sessionDirectory);
    }

    protected File getReportOutputDirectory() throws MojoExecutionException {
        return this.getAbsoluteFile(this.reportOutputDirectory);
    }

    protected ClassLoader getMainClassLoader() throws MojoExecutionException {
        try {
            Set<String> mainClasspathElements = this.getMainClasspathElements();
            HashSet<URI> uris = new HashSet<URI>(mainClasspathElements.size());
            for (String element : mainClasspathElements) {
                URI uri = new File(element).toURI();
                if (uris.contains(uri)) continue;
                uris.add(uri);
            }
            if (this.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, Messages.getMessage("mainClasspathInfo", new Object[0]), null);
            }
            int i = 0;
            URL[] urls = new URL[uris.size()];
            for (URI uri : uris) {
                urls[i++] = uri.toURL();
                if (!this.isLoggable(Level.FINEST)) continue;
                this.log(Level.FINEST, "\t" + urls[i - 1].toExternalForm(), null);
            }
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
        }
    }

    protected ClassLoader getTestClassLoader() throws MojoExecutionException {
        try {
            Set<String> testClasspathElements = this.getTestClasspathElements();
            HashSet<URI> uris = new HashSet<URI>(testClasspathElements.size());
            for (String element : testClasspathElements) {
                URI uri = new File(element).toURI();
                if (uris.contains(uri)) continue;
                uris.add(uri);
            }
            if (this.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, Messages.getMessage("testClasspathInfo", new Object[0]), null);
            }
            int i = 0;
            URL[] urls = new URL[uris.size()];
            for (URI uri : uris) {
                urls[i++] = uri.toURL();
                if (!this.isLoggable(Level.FINEST)) continue;
                this.log(Level.FINEST, "\t" + urls[i - 1].toExternalForm(), null);
            }
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
        }
    }

    protected Set<String> getMainClasspathElements() throws MojoExecutionException {
        String element;
        Artifact pluginArtifact;
        List runtimeArtifacts = this.getMavenProject().getRuntimeArtifacts();
        List compileArtifacts = this.getMavenProject().getCompileArtifacts();
        HashSet<String> elements = new HashSet<String>(runtimeArtifacts.size() + compileArtifacts.size() + 1);
        elements.add(this.getOutputDirectory().getAbsolutePath());
        for (Artifact a : runtimeArtifacts) {
            pluginArtifact = this.getPluginArtifact(a);
            if (a.getFile() == null) {
                if (!this.isLoggable(Level.WARNING)) continue;
                this.log(Level.WARNING, Messages.getMessage("ignoringArtifact", a.toString()), null);
                continue;
            }
            if (pluginArtifact != null) {
                if (!this.isLoggable(Level.FINER)) continue;
                this.log(Level.FINER, Messages.getMessage("ignoringPluginArtifact", a.toString(), pluginArtifact.toString()), null);
                continue;
            }
            element = a.getFile().getAbsolutePath();
            elements.add(element);
        }
        for (Artifact a : compileArtifacts) {
            pluginArtifact = this.getPluginArtifact(a);
            if (a.getFile() == null) {
                if (!this.isLoggable(Level.WARNING)) continue;
                this.log(Level.WARNING, Messages.getMessage("ignoringArtifact", a.toString()), null);
                continue;
            }
            if (pluginArtifact != null) {
                if (!this.isLoggable(Level.FINER)) continue;
                this.log(Level.FINER, Messages.getMessage("ignoringPluginArtifact", a.toString(), pluginArtifact.toString()), null);
                continue;
            }
            element = a.getFile().getAbsolutePath();
            elements.add(element);
        }
        return elements;
    }

    protected Set<String> getTestClasspathElements() throws MojoExecutionException {
        List testArtifacts = this.getMavenProject().getTestArtifacts();
        HashSet<String> elements = new HashSet<String>(testArtifacts.size() + 2);
        elements.add(this.getOutputDirectory().getAbsolutePath());
        elements.add(this.getTestOutputDirectory().getAbsolutePath());
        for (Artifact a : testArtifacts) {
            Artifact pluginArtifact = this.getPluginArtifact(a);
            if (a.getFile() == null) {
                if (!this.isLoggable(Level.WARNING)) continue;
                this.log(Level.WARNING, Messages.getMessage("ignoringArtifact", a.toString()), null);
                continue;
            }
            if (pluginArtifact != null) {
                if (!this.isLoggable(Level.FINER)) continue;
                this.log(Level.FINER, Messages.getMessage("ignoringPluginArtifact", a.toString(), pluginArtifact.toString()), null);
                continue;
            }
            String element = a.getFile().getAbsolutePath();
            elements.add(element);
        }
        return elements;
    }

    protected final boolean isVerbose() throws MojoExecutionException {
        return this.verbose;
    }

    protected final void setVerbose(boolean value) throws MojoExecutionException {
        this.verbose = value;
    }

    protected final boolean isSourceProcessingEnabled() throws MojoExecutionException {
        return this.sourceProcessingEnabled;
    }

    protected final void setSourceProcessingEnabled(boolean value) throws MojoExecutionException {
        this.sourceProcessingEnabled = value;
    }

    protected final boolean isResourceProcessingEnabled() throws MojoExecutionException {
        return this.resourceProcessingEnabled;
    }

    protected final void setResourceProcessingEnabled(boolean value) throws MojoExecutionException {
        this.resourceProcessingEnabled = value;
    }

    protected final boolean isClassProcessingEnabled() throws MojoExecutionException {
        return this.classProcessingEnabled;
    }

    protected final void setClassProcessingEnabled(boolean value) throws MojoExecutionException {
        this.classProcessingEnabled = value;
    }

    protected final boolean isModelProcessingEnabled() throws MojoExecutionException {
        return this.modelProcessingEnabled;
    }

    protected final void setModelProcessingEnabled(boolean value) throws MojoExecutionException {
        this.modelProcessingEnabled = value;
    }

    protected final boolean isModelObjectClasspathResolutionEnabled() throws MojoExecutionException {
        return this.modelObjectClasspathResolutionEnabled;
    }

    protected final void setModelObjectClasspathResolutionEnabled(boolean value) throws MojoExecutionException {
        this.modelObjectClasspathResolutionEnabled = value;
    }

    protected String getModel() throws MojoExecutionException {
        return this.model;
    }

    protected String getModuleName() throws MojoExecutionException {
        return this.moduleName;
    }

    protected String getTestModuleName() throws MojoExecutionException {
        return this.testModuleName;
    }

    protected Model getModel(ModelContext context) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            Module classpathModule;
            Model m = context.findModel(this.getModel());
            Modules modules = ModelHelper.getModules((Model)m);
            if (modules != null && this.isModelObjectClasspathResolutionEnabled() && (classpathModule = modules.getClasspathModule(Modules.getDefaultClasspathModuleName(), context.getClassLoader())) != null) {
                modules.getModule().add(classpathModule);
            }
            if (this.isModelProcessingEnabled()) {
                m = context.processModel(m);
            }
            return m;
        }
        catch (ModelException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)((Object)e));
        }
    }

    protected ModelContext createModelContext(ClassLoader classLoader) throws MojoExecutionException {
        ModelContextFactory modelContextFactory = this.modelContextFactoryClassName != null ? ModelContextFactory.newInstance((String)this.modelContextFactoryClassName) : ModelContextFactory.newInstance();
        ModelContext context = modelContextFactory.newModelContext(classLoader);
        this.setupModelContext(context);
        return context;
    }

    protected SourceFileProcessor createSourceFileProcessor(ModelContext context) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.createJomcTool(context, this.sourceFileProcessorClassName, SourceFileProcessor.class);
    }

    protected ResourceFileProcessor createResourceFileProcessor(ModelContext context) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.createJomcTool(context, this.resourceFileProcessorClassName, ResourceFileProcessor.class);
    }

    protected ClassFileProcessor createClassFileProcessor(ModelContext context) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.createJomcTool(context, this.classFileProcessorClassName, ClassFileProcessor.class);
    }

    protected <T extends JomcTool> T createJomcTool(ModelContext context, String className, Class<T> type) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        JomcTool tool = (JomcTool)this.createObject(context, className, type);
        this.setupJomcTool(context, tool);
        return (T)tool;
    }

    @Deprecated
    protected <T> T createObject(String className, Class<T> type) throws MojoExecutionException {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(className).asSubclass(type).newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
    }

    protected <T> T createObject(ModelContext modelContext, String className, Class<T> type) throws MojoExecutionException {
        if (modelContext == null) {
            throw new NullPointerException("modelContext");
        }
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            Class javaClass = modelContext.findClass(className);
            if (javaClass == null) {
                throw new MojoExecutionException(Messages.getMessage("classNotFound", className));
            }
            return javaClass.asSubclass(type).newInstance();
        }
        catch (ModelException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw new MojoExecutionException(Messages.getMessage("failedSearchingClass", className, m), (Exception)((Object)e));
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException(Messages.getMessage("failedCreatingObject", className), (Exception)e);
        }
    }

    @Deprecated
    protected URL getResource(String location) throws MojoExecutionException {
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            File f;
            URL resource;
            String absolute = location;
            if (!absolute.startsWith("/")) {
                absolute = "/" + location;
            }
            if ((resource = ((Object)((Object)this)).getClass().getResource(absolute)) == null) {
                try {
                    resource = new URL(location);
                }
                catch (MalformedURLException e) {
                    if (this.isLoggable(Level.FINEST)) {
                        this.log(Level.FINEST, Messages.getMessage(e), e);
                    }
                    resource = null;
                }
            }
            if (resource == null && (f = this.getAbsoluteFile(location)).isFile()) {
                resource = f.toURI().toURL();
            }
            return resource;
        }
        catch (MalformedURLException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw new MojoExecutionException(Messages.getMessage("malformedLocation", location, m), (Exception)e);
        }
    }

    protected URL getResource(ModelContext modelContext, String location) throws MojoExecutionException {
        if (modelContext == null) {
            throw new NullPointerException("modelContext");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            File f;
            URL resource;
            String absolute = location;
            if (!absolute.startsWith("/")) {
                absolute = "/" + location;
            }
            if ((resource = modelContext.findResource(absolute)) == null) {
                try {
                    resource = new URL(location);
                }
                catch (MalformedURLException e) {
                    if (this.isLoggable(Level.FINEST)) {
                        this.log(Level.FINEST, Messages.getMessage(e), e);
                    }
                    resource = null;
                }
            }
            if (resource == null && (f = this.getAbsoluteFile(location)).isFile()) {
                resource = f.toURI().toURL();
            }
            return resource;
        }
        catch (ModelException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw new MojoExecutionException(Messages.getMessage("failedSearchingResource", location, m), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw new MojoExecutionException(Messages.getMessage("malformedLocation", location, m), (Exception)e);
        }
    }

    protected URL getDirectory(String location) throws MojoExecutionException {
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            File f;
            URL resource;
            try {
                resource = new URL(location);
            }
            catch (MalformedURLException e) {
                if (this.isLoggable(Level.FINEST)) {
                    this.log(Level.FINEST, Messages.getMessage(e), e);
                }
                resource = null;
            }
            if (resource == null && (f = this.getAbsoluteFile(location)).isDirectory()) {
                resource = f.toURI().toURL();
            }
            return resource;
        }
        catch (MalformedURLException e) {
            String m = Messages.getMessage(e);
            m = m == null ? "" : " " + m;
            throw new MojoExecutionException(Messages.getMessage("malformedLocation", location, m), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected Transformer getTransformer(TransformerResourceType resource) throws MojoExecutionException {
        Transformer transformer;
        InputStream in;
        block55: {
            int s0;
            block56: {
                if (resource == null) {
                    throw new NullPointerException("resource");
                }
                URLConnection con = null;
                in = null;
                URL url = this.getResource(resource.getLocation());
                ErrorListener errorListener = new ErrorListener(){

                    public void warning(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.WARNING, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().warn((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                    }

                    public void error(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.SEVERE, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().error((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                        throw exception;
                    }

                    public void fatalError(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.SEVERE, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().error((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                        throw exception;
                    }
                };
                try {
                    if (url != null) {
                        if (this.isLoggable(Level.FINER)) {
                            this.log(Level.FINER, Messages.getMessage("loadingTransformer", url.toExternalForm()), null);
                        }
                        con = url.openConnection();
                        con.setConnectTimeout(resource.getConnectTimeout());
                        con.setReadTimeout(resource.getReadTimeout());
                        con.connect();
                        in = con.getInputStream();
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformerFactory.setErrorListener(errorListener);
                        transformer = transformerFactory.newTransformer(new StreamSource(in, url.toURI().toASCIIString()));
                        transformer.setErrorListener(errorListener);
                        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                            transformer.setParameter(e.getKey().toString(), e.getValue());
                        }
                        if (this.getMavenProject().getProperties() != null) {
                            for (Map.Entry<Object, Object> e : this.getMavenProject().getProperties().entrySet()) {
                                transformer.setParameter(e.getKey().toString(), e.getValue());
                            }
                        }
                        if (this.transformationParameterResources == null) break block55;
                        s0 = this.transformationParameterResources.size();
                        break block56;
                    }
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("transformerNotFound", resource.getLocation()), null);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("transformerNotFound", resource.getLocation()));
                }
                catch (InstantiationException e) {
                    throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
                }
                catch (URISyntaxException e) {
                    throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
                }
                catch (TransformerConfigurationException e) {
                    String m = Messages.getMessage(e);
                    if (m == null) {
                        m = Messages.getMessage(e.getException());
                    }
                    m = m == null ? "" : " " + m;
                    throw new MojoExecutionException(Messages.getMessage("failedCreatingTransformer", resource.getLocation(), m), (Exception)e);
                }
                catch (SocketTimeoutException e) {
                    String m = Messages.getMessage(e);
                    String string = m = m == null ? "" : " " + m;
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), e);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), (Exception)e);
                }
                catch (IOException e) {
                    String m = Messages.getMessage(e);
                    String string = m = m == null ? "" : " " + m;
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), e);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), (Exception)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        this.getLog().error((Throwable)e);
                    }
                    finally {
                        if (con instanceof HttpURLConnection) {
                            ((HttpURLConnection)con).disconnect();
                        }
                    }
                }
            }
            for (int i = 0; i < s0; ++i) {
                for (Map.Entry<Object, Object> e : this.getProperties(this.transformationParameterResources.get(i)).entrySet()) {
                    transformer.setParameter(e.getKey().toString(), e.getValue());
                }
            }
        }
        if (this.transformationParameters != null) {
            for (TransformationParameter e : this.transformationParameters) {
                transformer.setParameter(e.getKey(), e.getObject());
            }
        }
        if (this.transformationOutputProperties != null) {
            for (TransformationOutputProperty e : this.transformationOutputProperties) {
                transformer.setOutputProperty(e.getKey(), e.getValue());
            }
        }
        int s0 = resource.getTransformationParameterResources().size();
        for (int i = 0; i < s0; ++i) {
            for (Map.Entry<Object, Object> e : this.getProperties(resource.getTransformationParameterResources().get(i)).entrySet()) {
                transformer.setParameter(e.getKey().toString(), e.getValue());
            }
        }
        for (TransformationParameter e : resource.getTransformationParameters()) {
            transformer.setParameter(e.getKey(), e.getObject());
        }
        Iterator<KeyValueType> i$ = resource.getTransformationOutputProperties().iterator();
        while (true) {
            if (!i$.hasNext()) {
                in.close();
                in = null;
                return transformer;
            }
            TransformationOutputProperty e = (TransformationOutputProperty)i$.next();
            transformer.setOutputProperty(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Transformer getTransformer(ModelContext modelContext, TransformerResourceType resource) throws MojoExecutionException {
        Transformer transformer;
        InputStream in;
        block56: {
            int s0;
            block57: {
                if (modelContext == null) {
                    throw new NullPointerException("modelContext");
                }
                if (resource == null) {
                    throw new NullPointerException("resource");
                }
                URLConnection con = null;
                in = null;
                URL url = this.getResource(modelContext, resource.getLocation());
                ErrorListener errorListener = new ErrorListener(){

                    public void warning(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.WARNING, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().warn((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                    }

                    public void error(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.SEVERE, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().error((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                        throw exception;
                    }

                    public void fatalError(TransformerException exception) throws TransformerException {
                        try {
                            AbstractJomcMojo.this.log(Level.SEVERE, Messages.getMessage(exception), exception);
                        }
                        catch (MojoExecutionException e) {
                            AbstractJomcMojo.this.getLog().error((Throwable)exception);
                            AbstractJomcMojo.this.getLog().error((Throwable)e);
                        }
                        throw exception;
                    }
                };
                try {
                    if (url != null) {
                        if (this.isLoggable(Level.FINER)) {
                            this.log(Level.FINER, Messages.getMessage("loadingTransformer", url.toExternalForm()), null);
                        }
                        con = url.openConnection();
                        con.setConnectTimeout(resource.getConnectTimeout());
                        con.setReadTimeout(resource.getReadTimeout());
                        con.connect();
                        in = con.getInputStream();
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformerFactory.setErrorListener(errorListener);
                        transformer = transformerFactory.newTransformer(new StreamSource(in, url.toURI().toASCIIString()));
                        transformer.setErrorListener(errorListener);
                        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                            transformer.setParameter(e.getKey().toString(), e.getValue());
                        }
                        if (this.getMavenProject().getProperties() != null) {
                            for (Map.Entry<Object, Object> e : this.getMavenProject().getProperties().entrySet()) {
                                transformer.setParameter(e.getKey().toString(), e.getValue());
                            }
                        }
                        if (this.transformationParameterResources == null) break block56;
                        s0 = this.transformationParameterResources.size();
                        break block57;
                    }
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("transformerNotFound", resource.getLocation()), null);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("transformerNotFound", resource.getLocation()));
                }
                catch (InstantiationException e) {
                    throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
                }
                catch (URISyntaxException e) {
                    throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
                }
                catch (TransformerConfigurationException e) {
                    String m = Messages.getMessage(e);
                    if (m == null) {
                        m = Messages.getMessage(e.getException());
                    }
                    m = m == null ? "" : " " + m;
                    throw new MojoExecutionException(Messages.getMessage("failedCreatingTransformer", resource.getLocation(), m), (Exception)e);
                }
                catch (SocketTimeoutException e) {
                    String m = Messages.getMessage(e);
                    String string = m = m == null ? "" : " " + m;
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), e);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), (Exception)e);
                }
                catch (IOException e) {
                    String m = Messages.getMessage(e);
                    String string = m = m == null ? "" : " " + m;
                    if (resource.isOptional()) {
                        if (!this.isLoggable(Level.WARNING)) return null;
                        this.log(Level.WARNING, Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), e);
                        return null;
                    }
                    throw new MojoExecutionException(Messages.getMessage("failedLoadingTransformer", url.toExternalForm(), m), (Exception)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        this.getLog().error((Throwable)e);
                    }
                    finally {
                        if (con instanceof HttpURLConnection) {
                            ((HttpURLConnection)con).disconnect();
                        }
                    }
                }
            }
            for (int i = 0; i < s0; ++i) {
                for (Map.Entry<Object, Object> e : this.getProperties(modelContext, this.transformationParameterResources.get(i)).entrySet()) {
                    transformer.setParameter(e.getKey().toString(), e.getValue());
                }
            }
        }
        if (this.transformationParameters != null) {
            for (TransformationParameter e : this.transformationParameters) {
                transformer.setParameter(e.getKey(), e.getObject(modelContext));
            }
        }
        if (this.transformationOutputProperties != null) {
            for (TransformationOutputProperty e : this.transformationOutputProperties) {
                transformer.setOutputProperty(e.getKey(), e.getValue());
            }
        }
        int s0 = resource.getTransformationParameterResources().size();
        for (int i = 0; i < s0; ++i) {
            for (Map.Entry<Object, Object> e : this.getProperties(modelContext, resource.getTransformationParameterResources().get(i)).entrySet()) {
                transformer.setParameter(e.getKey().toString(), e.getValue());
            }
        }
        for (TransformationParameter e : resource.getTransformationParameters()) {
            transformer.setParameter(e.getKey(), e.getObject(modelContext));
        }
        Iterator<KeyValueType> i$ = resource.getTransformationOutputProperties().iterator();
        while (true) {
            if (!i$.hasNext()) {
                in.close();
                in = null;
                return transformer;
            }
            TransformationOutputProperty e = (TransformationOutputProperty)i$.next();
            transformer.setOutputProperty(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected Properties getProperties(PropertiesResourceType propertiesResourceType) throws MojoExecutionException {
        if (propertiesResourceType == null) {
            throw new NullPointerException("propertiesResourceType");
        }
        URLConnection con = null;
        InputStream in = null;
        URL url = this.getResource(propertiesResourceType.getLocation());
        Properties properties = new Properties();
        try {
            if (url != null) {
                if (this.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, Messages.getMessage("loadingProperties", url.toExternalForm()), null);
                }
                con = url.openConnection();
                con.setConnectTimeout(propertiesResourceType.getConnectTimeout());
                con.setReadTimeout(propertiesResourceType.getReadTimeout());
                con.connect();
                in = con.getInputStream();
                if ("plain".equalsIgnoreCase(propertiesResourceType.getFormat())) {
                    properties.load(in);
                } else if ("xml".equalsIgnoreCase(propertiesResourceType.getFormat())) {
                    properties.loadFromXML(in);
                }
                in.close();
                in = null;
                return properties;
            }
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("propertiesNotFound", propertiesResourceType.getLocation()), null);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("propertiesNotFound", propertiesResourceType.getLocation()));
        }
        catch (SocketTimeoutException e) {
            String m = Messages.getMessage(e);
            String string = m = m == null ? "" : " " + m;
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), e);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), (Exception)e);
        }
        catch (IOException e) {
            String m = Messages.getMessage(e);
            String string = m = m == null ? "" : " " + m;
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), e);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), (Exception)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
            finally {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties getProperties(ModelContext modelContext, PropertiesResourceType propertiesResourceType) throws MojoExecutionException {
        if (modelContext == null) {
            throw new NullPointerException("modelContext");
        }
        if (propertiesResourceType == null) {
            throw new NullPointerException("propertiesResourceType");
        }
        URLConnection con = null;
        InputStream in = null;
        URL url = this.getResource(modelContext, propertiesResourceType.getLocation());
        Properties properties = new Properties();
        try {
            if (url != null) {
                if (this.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, Messages.getMessage("loadingProperties", url.toExternalForm()), null);
                }
                con = url.openConnection();
                con.setConnectTimeout(propertiesResourceType.getConnectTimeout());
                con.setReadTimeout(propertiesResourceType.getReadTimeout());
                con.connect();
                in = con.getInputStream();
                if ("plain".equalsIgnoreCase(propertiesResourceType.getFormat())) {
                    properties.load(in);
                } else if ("xml".equalsIgnoreCase(propertiesResourceType.getFormat())) {
                    properties.loadFromXML(in);
                }
                in.close();
                in = null;
                return properties;
            }
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("propertiesNotFound", propertiesResourceType.getLocation()), null);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("propertiesNotFound", propertiesResourceType.getLocation()));
        }
        catch (SocketTimeoutException e) {
            String m = Messages.getMessage(e);
            String string = m = m == null ? "" : " " + m;
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), e);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), (Exception)e);
        }
        catch (IOException e) {
            String m = Messages.getMessage(e);
            String string = m = m == null ? "" : " " + m;
            if (propertiesResourceType.isOptional()) {
                if (!this.isLoggable(Level.WARNING)) return properties;
                this.log(Level.WARNING, Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), e);
                return properties;
            }
            throw new MojoExecutionException(Messages.getMessage("failedLoadingProperties", url.toExternalForm(), m), (Exception)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
            finally {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
            }
        }
    }

    protected boolean isLoggable(Level level) throws MojoExecutionException {
        if (level == null) {
            throw new NullPointerException("level");
        }
        boolean loggable = false;
        if (level.intValue() <= Level.CONFIG.intValue()) {
            loggable = this.getLog().isDebugEnabled();
        } else if (level.intValue() <= Level.INFO.intValue()) {
            loggable = this.getLog().isInfoEnabled() && this.isVerbose();
        } else if (level.intValue() <= Level.WARNING.intValue()) {
            loggable = this.getLog().isWarnEnabled();
        } else if (level.intValue() <= Level.SEVERE.intValue()) {
            loggable = this.getLog().isErrorEnabled();
        }
        return loggable;
    }

    @Deprecated
    protected void logSeparator(Level level) throws MojoExecutionException {
        this.logSeparator();
    }

    protected void logSeparator() throws MojoExecutionException {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, Messages.getMessage("separator", new Object[0]), null);
        }
    }

    protected void logProcessingModule(String toolName, String module) throws MojoExecutionException {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, Messages.getMessage("processingModule", toolName, module), null);
        }
    }

    protected void logProcessingModel(String toolName, String model) throws MojoExecutionException {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, Messages.getMessage("processingModel", toolName, model), null);
        }
    }

    protected void logMissingModule(String module) throws MojoExecutionException {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, Messages.getMessage("missingModule", module), null);
        }
    }

    protected void logToolSuccess(String toolName) throws MojoExecutionException {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, Messages.getMessage("toolSuccess", toolName), null);
        }
    }

    protected void log(ModelContext context, Level level, ModelValidationReport report) throws MojoExecutionException {
        try {
            if (!report.getDetails().isEmpty()) {
                this.logSeparator();
                Marshaller marshaller = null;
                for (ModelValidationReport.Detail detail : report.getDetails()) {
                    this.log(detail.getLevel(), "o " + detail.getMessage(), null);
                    if (detail.getElement() == null || !this.isLoggable(Level.FINEST)) continue;
                    if (marshaller == null) {
                        marshaller = context.createMarshaller(this.getModel());
                        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    }
                    StringWriter stringWriter = new StringWriter();
                    marshaller.marshal((Object)detail.getElement(), (Writer)stringWriter);
                    this.log(Level.FINEST, stringWriter.toString(), null);
                }
            }
        }
        catch (ModelException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)((Object)e));
        }
        catch (JAXBException e) {
            String message = Messages.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = Messages.getMessage(e.getLinkedException());
            }
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
    }

    protected void log(Level level, String message, Throwable throwable) throws MojoExecutionException {
        BufferedReader reader = null;
        try {
            if (this.isLoggable(level)) {
                reader = new BufferedReader(new StringReader(message == null ? "" : message));
                boolean throwableLogged = false;
                String line = reader.readLine();
                while (line != null) {
                    String mojoMessage = Messages.getMessage(this.getLog().isDebugEnabled() ? "debugMessage" : "logMessage", line, Thread.currentThread().getName(), new Date(System.currentTimeMillis()));
                    if (level.intValue() <= Level.CONFIG.intValue()) {
                        this.getLog().debug((CharSequence)mojoMessage, throwableLogged ? null : throwable);
                    } else if (level.intValue() <= Level.INFO.intValue()) {
                        this.getLog().info((CharSequence)mojoMessage, throwableLogged ? null : throwable);
                    } else if (level.intValue() <= Level.WARNING.intValue()) {
                        this.getLog().warn((CharSequence)mojoMessage, throwableLogged ? null : throwable);
                    } else if (level.intValue() <= Level.SEVERE.intValue()) {
                        this.getLog().error((CharSequence)mojoMessage, throwableLogged ? null : throwable);
                    }
                    throwableLogged = true;
                    line = reader.readLine();
                }
                reader.close();
                reader = null;
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    protected void setupModelContext(ModelContext context) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.isVerbose() || this.getLog().isDebugEnabled()) {
            context.setLogLevel(this.getLog().isDebugEnabled() ? Level.ALL : Level.INFO);
        }
        try {
            context.setExecutorService(this.getExecutorService());
            context.setModletSchemaSystemId(this.modletSchemaSystemId);
            context.getListeners().add(new ModelContext.Listener(){

                public void onLog(Level level, String message, Throwable t) {
                    super.onLog(level, message, t);
                    try {
                        AbstractJomcMojo.this.log(level, message, t);
                    }
                    catch (MojoExecutionException e) {
                        AbstractJomcMojo.this.getLog().error((Throwable)e);
                    }
                }
            });
            if (this.providerLocation != null) {
                context.setAttribute("org.jomc.modlet.DefaultModelContext.providerLocationAttribute", (Object)this.providerLocation);
            }
            if (this.platformProviderLocation != null) {
                context.setAttribute("org.jomc.modlet.DefaultModelContext.platformProviderLocationAttribute", (Object)this.platformProviderLocation);
            }
            if (this.modletLocation != null) {
                context.setAttribute("org.jomc.modlet.DefaultModletProvider.modletLocationAttribute", (Object)this.modletLocation);
            }
            if (this.transformerLocation != null) {
                context.setAttribute("org.jomc.model.modlet.DefaultModelProcessor.transformerLocationAttribute", (Object)this.transformerLocation);
            }
            if (this.moduleLocation != null) {
                context.setAttribute("org.jomc.model.modlet.DefaultModelProvider.moduleLocationAttribute", (Object)this.moduleLocation);
            }
            context.setAttribute("org.jomc.tools.modlet.ToolsModelProvider.modelObjectClasspathResolutionEnabledAttribute", (Object)this.modelObjectClasspathResolutionEnabled);
            context.setAttribute("org.jomc.tools.modlet.ToolsModelProcessor.modelObjectClasspathResolutionEnabledAttribute", (Object)this.modelObjectClasspathResolutionEnabled);
            context.setAttribute("org.jomc.modlet.DefaultModletProvider.validatingAttribute", (Object)this.modletResourceValidationEnabled);
            context.setAttribute("org.jomc.model.modlet.DefaultModelProvider.validatingAttribute", (Object)this.modelResourceValidationEnabled);
            context.setAttribute("org.jomc.model.modlet.DefaultModelValidator.validateJavaAttribute", (Object)this.javaValidationEnabled);
            if (this.modelContextAttributes != null) {
                for (ModelContextAttribute e : this.modelContextAttributes) {
                    Object object = e.getObject(context);
                    if (object != null) {
                        context.setAttribute(e.getKey(), object);
                        continue;
                    }
                    context.clearAttribute(e.getKey());
                }
            }
            if (this.modletIncludes != null && !this.modletIncludes.isEmpty() || this.modletExcludes != null && !this.modletExcludes.isEmpty()) {
                Modlets modlets = context.getModlets().clone();
                Iterator it = modlets.getModlet().iterator();
                while (it.hasNext()) {
                    Modlet modlet = (Modlet)it.next();
                    if (this.modletIncludes != null && !this.modletIncludes.isEmpty() && !this.modletIncludes.contains(modlet.getName())) {
                        it.remove();
                        this.log(Level.INFO, Messages.getMessage("excludingModlet", modlet.getName()), null);
                        continue;
                    }
                    if (this.modletExcludes != null && !this.modletExcludes.isEmpty() && this.modletExcludes.contains(modlet.getName())) {
                        it.remove();
                        this.log(Level.INFO, Messages.getMessage("excludingModlet", modlet.getName()), null);
                        continue;
                    }
                    this.log(Level.INFO, Messages.getMessage("includingModlet", modlet.getName()), null);
                }
                context.setModlets(modlets);
            }
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
        }
        catch (ModelException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)((Object)e));
        }
    }

    protected void setupJomcTool(ModelContext context, JomcTool tool) throws MojoExecutionException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (tool == null) {
            throw new NullPointerException("tool");
        }
        try {
            Object object;
            int s0;
            if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                tool.setLogLevel(this.getLog().isDebugEnabled() ? Level.ALL : Level.INFO);
            }
            tool.setExecutorService(this.getExecutorService());
            tool.getListeners().add(new JomcTool.Listener(){

                public void onLog(Level level, String message, Throwable t) {
                    super.onLog(level, message, t);
                    try {
                        AbstractJomcMojo.this.log(level, message, t);
                    }
                    catch (MojoExecutionException e) {
                        AbstractJomcMojo.this.getLog().error((Throwable)e);
                    }
                }
            });
            if (this.templateEncoding != null) {
                if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, Messages.getMessage("deprecationWarning", "templateEncoding", "defaultTemplateEncoding"), null);
                }
                tool.setDefaultTemplateEncoding(this.templateEncoding);
            } else {
                tool.setDefaultTemplateEncoding(this.defaultTemplateEncoding);
            }
            tool.setInputEncoding(this.sourceEncoding);
            tool.setOutputEncoding(this.sourceEncoding);
            JomcTool.setDefaultTemplateProfile((String)this.defaultTemplateProfile);
            tool.setTemplateProfile(this.templateProfile);
            tool.setModel(this.getModel(context));
            if (this.indentation != null) {
                tool.setIndentation(StringEscapeUtils.unescapeJava((String)this.indentation));
            }
            if (this.lineSeparator != null) {
                tool.setLineSeparator(StringEscapeUtils.unescapeJava((String)this.lineSeparator));
            }
            if (this.locale != null) {
                tool.setLocale(new Locale(StringUtils.defaultString((String)this.locale.getLanguage()), StringUtils.defaultString((String)this.locale.getCountry()), StringUtils.defaultString((String)this.locale.getVariant())));
            }
            if (this.velocityPropertyResources != null) {
                s0 = this.velocityPropertyResources.size();
                for (int i = 0; i < s0; ++i) {
                    for (Map.Entry<Object, Object> e : this.getProperties(context, this.velocityPropertyResources.get(i)).entrySet()) {
                        if (e.getValue() != null) {
                            tool.getVelocityEngine().setProperty(e.getKey().toString(), e);
                            continue;
                        }
                        tool.getVelocityEngine().clearProperty(e.getKey().toString());
                    }
                }
            }
            if (this.velocityProperties != null) {
                for (VelocityProperty e : this.velocityProperties) {
                    object = e.getObject(context);
                    if (object != null) {
                        tool.getVelocityEngine().setProperty(e.getKey(), object);
                        continue;
                    }
                    tool.getVelocityEngine().clearProperty(e.getKey());
                }
            }
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                tool.getTemplateParameters().put(e.getKey().toString(), e.getValue());
            }
            if (this.getMavenProject().getProperties() != null) {
                for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                    tool.getTemplateParameters().put(e.getKey().toString(), e.getValue());
                }
            }
            if (this.templateParameterResources != null) {
                s0 = this.templateParameterResources.size();
                for (int i = 0; i < s0; ++i) {
                    for (Map.Entry<Object, Object> e : this.getProperties(context, this.templateParameterResources.get(i)).entrySet()) {
                        if (e.getValue() != null) {
                            tool.getTemplateParameters().put(e.getKey().toString(), e.getValue());
                            continue;
                        }
                        tool.getTemplateParameters().remove(e.getKey().toString());
                    }
                }
            }
            if (this.templateParameters != null) {
                for (TemplateParameter e : this.templateParameters) {
                    object = e.getObject(context);
                    if (object != null) {
                        tool.getTemplateParameters().put(e.getKey(), object);
                        continue;
                    }
                    tool.getTemplateParameters().remove(e.getKey());
                }
            }
            if (this.templateLocation != null) {
                URL url = this.getDirectory(this.templateLocation);
                tool.setTemplateLocation(url);
                if (url == null && this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, Messages.getMessage("locationNotFound", this.templateLocation), null);
                }
            }
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException(Messages.getMessage(e), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected final void copyFile(File source, File target) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            if (source.equals(target)) return;
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            byte[] buffer = new byte[65536];
            int read = ((InputStream)in).read(buffer);
            while (read >= 0) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
            out.close();
            out = null;
            ((InputStream)in).close();
            in = null;
            return;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                this.getLog().warn((Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
    }

    protected final void copyDirectory(File source, File target) throws IOException {
        if (!target.isDirectory() && !target.mkdirs()) {
            throw new IOException(Messages.getMessage("failedCreatingDirectory", target.getAbsolutePath()));
        }
        for (File file : source.listFiles()) {
            File targetFile = new File(target, file.getName());
            if (file.isFile()) {
                this.copyFile(file, targetFile);
                continue;
            }
            if (file.isDirectory()) {
                this.copyDirectory(file, targetFile);
                continue;
            }
            throw new IOException(Messages.getMessage("failedCopying", file.getAbsolutePath(), targetFile.getAbsolutePath()));
        }
    }

    private Artifact getPluginArtifact(Artifact a) {
        int s0 = this.pluginArtifacts.size();
        for (int i = 0; i < s0; ++i) {
            Artifact pluginArtifact = this.pluginArtifacts.get(i);
            if (!pluginArtifact.getGroupId().equals(a.getGroupId()) || !pluginArtifact.getArtifactId().equals(a.getArtifactId()) || !(pluginArtifact.hasClassifier() ? pluginArtifact.getClassifier().equals(a.getClassifier()) : !a.hasClassifier())) continue;
            return pluginArtifact;
        }
        return null;
    }
}

