/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.apache.maven.plugin.MojoExecutionException;
import org.jomc.model.Module;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.ObjectFactory;
import org.jomc.mojo.AbstractJomcMojo;
import org.jomc.mojo.Messages;
import org.jomc.tools.ClassFileProcessor;

public abstract class AbstractClassesValidateMojo
extends AbstractJomcMojo {
    private static final String TOOLNAME = "ClassFileProcessor";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void executeTool() throws Exception {
        this.logSeparator();
        if (this.isClassProcessingEnabled()) {
            Module module;
            this.logProcessingModule(TOOLNAME, this.getClassesModuleName());
            ModelContext context = this.createModelContext(this.getClassesClassLoader());
            ClassFileProcessor tool = this.createClassFileProcessor(context);
            JAXBContext jaxbContext = context.createContext(this.getModel());
            JAXBSource source = new JAXBSource(jaxbContext, (Object)new ObjectFactory().createModel(tool.getModel()));
            ModelValidationReport validationReport = context.validateModel(this.getModel(), (Source)source);
            this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
            if (!validationReport.isModelValid()) throw new MojoExecutionException(Messages.getMessage("classFileValidationFailure", new Object[0]));
            Module module2 = module = tool.getModules() != null ? tool.getModules().getModule(this.getClassesModuleName()) : null;
            if (module != null) {
                validationReport = tool.validateModelObjects(module, context, this.getClassesDirectory());
                if (validationReport != null) {
                    this.log(context, validationReport.isModelValid() ? Level.INFO : Level.SEVERE, validationReport);
                    if (!validationReport.isModelValid()) {
                        throw new MojoExecutionException(Messages.getMessage("classFileValidationFailure", new Object[0]));
                    }
                }
                this.logToolSuccess(TOOLNAME);
                return;
            } else {
                this.logMissingModule(this.getClassesModuleName());
            }
            return;
        } else {
            if (!this.isLoggable(Level.INFO)) return;
            this.log(Level.INFO, Messages.getMessage("classFileValidationDisabled", new Object[0]), null);
        }
    }

    protected abstract String getClassesModuleName() throws MojoExecutionException;

    protected abstract ClassLoader getClassesClassLoader() throws MojoExecutionException;

    protected abstract File getClassesDirectory() throws MojoExecutionException;
}

