/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jomc.mojo.Messages;

public abstract class AbstractAttachMojo
extends AbstractMojo {
    private static final String TOOLNAME = "MavenProjectHelper";
    private static final String LOG_PREFIX = "[JOMC] ";
    @Parameter(name="mavenProject", defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper mavenProjectHelper;
    @Parameter(name="mavenSession", defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(name="sessionDirectory", property="jomc.sessionDirectory", defaultValue="${project.build.directory}/jomc-sessions")
    private String sessionDirectory;
    @Parameter(name="verbose", property="jomc.verbose", defaultValue="false")
    private boolean verbose;

    protected MavenProject getMavenProject() throws MojoExecutionException {
        return this.mavenProject;
    }

    protected MavenSession getMavenSession() throws MojoExecutionException {
        return this.mavenSession;
    }

    protected MavenProjectHelper getMavenProjectHelper() throws MojoExecutionException {
        return this.mavenProjectHelper;
    }

    protected File getSessionDirectory() throws MojoExecutionException {
        File directory = new File(this.sessionDirectory);
        if (!directory.isAbsolute()) {
            directory = new File(this.getMavenProject().getBasedir(), this.sessionDirectory);
        }
        return directory;
    }

    protected final boolean isVerbose() throws MojoExecutionException {
        return this.verbose;
    }

    protected final void setVerbose(boolean value) throws MojoExecutionException {
        this.verbose = value;
    }

    protected abstract File getArtifactFile();

    protected abstract String getArtifactClassifier();

    protected abstract String getArtifactType();

    protected abstract String getExecutionStrategy();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        File attachment = new File(this.getSessionDirectory(), ArtifactUtils.versionlessKey((Artifact)this.getMavenProject().getArtifact()).hashCode() + "-" + this.getArtifactClassifier() + "-" + this.getMavenSession().getStartTime().getTime() + "." + this.getArtifactType());
        try {
            if (this.isVerbose() && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("separator", new Object[0])));
                this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("title", new Object[0])));
            }
            if ("always".equals(this.getExecutionStrategy()) || !attachment.exists()) {
                if (this.isVerbose() && this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("separator", new Object[0])));
                    this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("processingProject", TOOLNAME, this.getMavenProject().getName() == null ? this.getMavenProject().getArtifactId() : this.getMavenProject().getName())));
                }
                if (this.getArtifactFile().isFile()) {
                    if (attachment.exists() && !attachment.delete()) {
                        this.getLog().warn((CharSequence)(LOG_PREFIX + Messages.getMessage("failedDeletingFile", attachment.getAbsolutePath())));
                    }
                    if (!attachment.getParentFile().exists() && !attachment.getParentFile().mkdirs()) {
                        throw new MojoExecutionException(Messages.getMessage("failedCreatingDirectory", attachment.getParentFile().getAbsolutePath()));
                    }
                    this.copyFile(this.getArtifactFile(), attachment);
                    this.getMavenProjectHelper().attachArtifact(this.getMavenProject(), this.getArtifactType(), this.getArtifactClassifier(), attachment);
                    if (this.isVerbose() && this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("creatingAttachment", this.getArtifactFile().getAbsolutePath(), this.getArtifactClassifier(), this.getArtifactType())));
                        this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("toolSuccess", TOOLNAME)));
                    }
                } else if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn((CharSequence)(LOG_PREFIX + Messages.getMessage("artifactFileNotFound", this.getArtifactFile().getAbsolutePath())));
                }
            } else if (this.isVerbose() && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("executionSuppressed", this.getExecutionStrategy())));
            }
        }
        catch (IOException e) {
            String message = Messages.getMessage(e);
            throw new MojoExecutionException(Messages.getMessage("failedCopying", this.getArtifactFile().getAbsolutePath(), attachment.getAbsolutePath(), message != null ? message : ""), (Exception)e);
        }
        finally {
            if (this.isVerbose() && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(LOG_PREFIX + Messages.getMessage("separator", new Object[0])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void copyFile(File source, File target) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            if (source.equals(target)) return;
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            byte[] buffer = new byte[65536];
            int read = ((InputStream)in).read(buffer);
            while (read >= 0) {
                out.write(buffer, 0, read);
                read = ((InputStream)in).read(buffer);
            }
            out.close();
            out = null;
            ((InputStream)in).close();
            in = null;
            return;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                this.getLog().warn((Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            }
        }
    }
}

