/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.pull;

import java.util.Map;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.notification.BackendCallback;
import org.jolokia.server.core.service.notification.Client;
import org.jolokia.server.core.service.notification.NotificationBackend;
import org.jolokia.server.core.service.notification.NotificationSubscription;
import org.jolokia.service.notif.pull.PullNotificationStore;

public class PullNotificationBackend
extends AbstractJolokiaService<NotificationBackend>
implements NotificationBackend {
    public static final String OBJECT_NAME = "jolokia:type=NotificationStore";
    private PullNotificationStore store;
    private final int maxEntries = 100;
    private ObjectName objectName;

    public PullNotificationBackend(int order) {
        super(NotificationBackend.class, order);
    }

    public synchronized void init(JolokiaContext pContext) {
        if (this.getJolokiaContext() == null) {
            super.init(pContext);
            this.store = new PullNotificationStore(100);
            this.objectName = this.registerJolokiaMBean(OBJECT_NAME, this.store);
        }
    }

    public void destroy() throws Exception {
        if (this.getJolokiaContext() != null) {
            this.unregisterJolokiaMBean(this.objectName);
            super.destroy();
        }
    }

    public String getNotifType() {
        return "pull";
    }

    public BackendCallback subscribe(final NotificationSubscription pSubscription) {
        return new BackendCallback(){
            final /* synthetic */ PullNotificationBackend this$0;
            {
                this.this$0 = this$0;
            }

            public void handleNotification(Notification notification, Object handback) {
                this.this$0.store.add(pSubscription, notification);
            }
        };
    }

    public void channelInit(Client client, BackChannel channel) {
    }

    public void unsubscribe(String pClientId, String pHandle) {
        this.store.removeSubscription(pClientId, pHandle);
    }

    public void unregister(Client pClient) {
        this.store.removeClient(pClient.getId());
    }

    public Map<String, ?> getConfig() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"store", (Object)this.objectName.toString());
        ret.put((Object)"maxEntries", (Object)100);
        return ret;
    }
}

