/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import org.jolokia.server.core.request.JolokiaWriteRequest;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;

public class WriteHandler
extends AbstractCommandHandler<JolokiaWriteRequest> {
    @Override
    public RequestType getType() {
        return RequestType.WRITE;
    }

    @Override
    protected void checkForRestriction(JolokiaWriteRequest pRequest) {
        if (!this.context.isAttributeWriteAllowed(pRequest.getObjectName(), pRequest.getAttributeName())) {
            throw new SecurityException("Writing attribute " + pRequest.getAttributeName() + " forbidden for MBean " + pRequest.getObjectNameAsString());
        }
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaWriteRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        try {
            return this.setAttribute(request, server);
        }
        catch (IntrospectionException exp) {
            throw new IllegalArgumentException("Cannot get info for MBean " + request.getObjectName() + ": " + exp, exp);
        }
        catch (InvalidAttributeValueException e) {
            throw new IllegalArgumentException("Invalid value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot set value " + request.getValue() + " for attribute " + request.getAttributeName() + ", MBean " + request.getObjectNameAsString(), e);
        }
    }

    private Object setAttribute(JolokiaWriteRequest request, MBeanServerConnection server) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException, InvalidAttributeValueException, IllegalAccessException, InvocationTargetException, IOException {
        Object[] values;
        Object oldValue = server.getAttribute(request.getObjectName(), request.getAttributeName());
        MBeanInfo mInfo = server.getMBeanInfo(request.getObjectName());
        MBeanAttributeInfo aInfo = null;
        for (MBeanAttributeInfo i : mInfo.getAttributes()) {
            if (!i.getName().equals(request.getAttributeName())) continue;
            aInfo = i;
            break;
        }
        if (aInfo instanceof OpenMBeanAttributeInfo) {
            OpenMBeanAttributeInfo info = (OpenMBeanAttributeInfo)((Object)aInfo);
            values = this.getValues(info.getOpenType(), oldValue, request);
        } else {
            values = this.getValues(aInfo.getType(), oldValue, request);
        }
        Attribute attribute = new Attribute(request.getAttributeName(), values[0]);
        server.setAttribute(request.getObjectName(), attribute);
        return values[1];
    }

    private Object[] getValues(String pType, Object pCurrentValue, JolokiaWriteRequest pRequest) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        List pathParts = pRequest.getPathParts();
        Object newValue = pRequest.getValue();
        if (pathParts != null && !pathParts.isEmpty()) {
            if (pCurrentValue == null) {
                throw new IllegalArgumentException("Cannot set value with path when parent object is not set");
            }
            return new Object[]{pCurrentValue, ((Serializer)this.context.getMandatoryService(Serializer.class)).setInnerValue(pCurrentValue, newValue, pathParts)};
        }
        return new Object[]{((Serializer)this.context.getMandatoryService(Serializer.class)).deserialize(pType, newValue), pCurrentValue};
    }

    private Object[] getValues(OpenType<?> pOpenType, Object pCurrentValue, JolokiaWriteRequest pRequest) {
        List pathParts = pRequest.getPathParts();
        if (pathParts != null && !pathParts.isEmpty()) {
            throw new IllegalArgumentException("Cannot set value for OpenType " + pOpenType + " with inner path " + pRequest.getPath() + " since OpenTypes are immutable");
        }
        return new Object[]{((Serializer)this.context.getMandatoryService(Serializer.class)).deserializeOpenType(pOpenType, pRequest.getValue()), pCurrentValue};
    }
}

