/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.osgi;

import java.util.HashMap;
import java.util.Map;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.osgi.AbstractOsgiServerDetector;
import org.osgi.framework.BundleContext;

public class VirgoDetector
extends AbstractOsgiServerDetector {
    public VirgoDetector(BundleContext pContext) {
        super(pContext, "virgo");
    }

    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String version = this.getBundleVersion("org.eclipse.virgo.kernel.userregion");
        if (version != null) {
            String type = "kernel";
            if (this.getBundleVersion("org.eclipse.gemini.web.core") != null) {
                type = "tomcat";
            } else if (this.getBundleVersion("org.eclipse.jetty.osgi.boot") != null) {
                type = "jetty";
            }
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("type", type);
            return new VirgoServerHandle(version, extraInfo);
        }
        return null;
    }

    private static class VirgoServerHandle
    extends DefaultServerHandle {
        private final Map<String, String> extraInfo;

        public VirgoServerHandle(String pVersion, Map<String, String> pExtraInfo) {
            super("Eclipse", "virgo", pVersion);
            this.extraInfo = pExtraInfo;
        }

        public Map<String, String> getExtraInfo(MBeanServerAccess pServerManager) {
            return this.extraInfo;
        }
    }
}

