/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Stack;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jolokia.util.EscapeUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DelegatingAuthenticator
extends Authenticator {
    private final URL delegateURL;
    private final PrincipalExtractor principalExtractor;
    private final String realm;

    public DelegatingAuthenticator(String pRealm, String pUrl, String pPrincipalSpec, boolean pDisableCertCheck) {
        this.realm = pRealm;
        try {
            this.delegateURL = new URL(pUrl);
            this.principalExtractor = this.createPrincipalExtractor(pPrincipalSpec);
            if (pDisableCertCheck) {
                DelegatingAuthenticator.disableSSLCertificateChecking();
            }
        }
        catch (MalformedURLException exp) {
            throw new IllegalArgumentException("Invalid delegation url '" + pUrl + "' given: " + exp, exp);
        }
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange pHttpExchange) {
        try {
            URLConnection connection = this.delegateURL.openConnection();
            connection.addRequestProperty("Authorization", pHttpExchange.getRequestHeaders().getFirst("Authorization"));
            connection.setConnectTimeout(2000);
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                return httpConnection.getResponseCode() == 200 ? new Authenticator.Success(this.principalExtractor.extract(connection)) : new Authenticator.Failure(401);
            }
            return new Authenticator.Failure(401);
        }
        catch (IOException e) {
            return this.prepareFailure(pHttpExchange, "Cannot call delegate url " + this.delegateURL + ": " + e, 503);
        }
        catch (IllegalArgumentException e) {
            return this.prepareFailure(pHttpExchange, "Illegal Argument: " + e, 400);
        }
        catch (ParseException e) {
            return this.prepareFailure(pHttpExchange, "Invalid JSON response: " + (Object)((Object)e), 422);
        }
    }

    private Authenticator.Result prepareFailure(HttpExchange pHttpExchange, String pErrorDetails, int pCode) {
        pHttpExchange.getResponseHeaders().add("X-Error-Details", pErrorDetails);
        return new Authenticator.Failure(pCode);
    }

    private PrincipalExtractor createPrincipalExtractor(String pPrincipalExtractorSpec) {
        if (pPrincipalExtractorSpec == null || pPrincipalExtractorSpec.startsWith("empty:")) {
            return new EmptyPrincipalExtractor();
        }
        if (pPrincipalExtractorSpec.startsWith("json:")) {
            return new JsonPathExtractor(pPrincipalExtractorSpec.substring("json:".length()));
        }
        throw new IllegalArgumentException("No principal extractor found for spec '" + pPrincipalExtractorSpec + "'");
    }

    private static void disableSSLCertificateChecking() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException e) {
            throw new IllegalArgumentException("Disabling SSL certificate failed: " + e, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Disabling SSL certificate failed: " + e, e);
        }
    }

    private class EmptyPrincipalExtractor
    implements PrincipalExtractor {
        private EmptyPrincipalExtractor() {
        }

        @Override
        public HttpPrincipal extract(URLConnection connection) {
            return new HttpPrincipal("", DelegatingAuthenticator.this.realm);
        }
    }

    private class JsonPathExtractor
    implements PrincipalExtractor {
        private String path;

        public JsonPathExtractor(String pPath) {
            this.path = pPath;
        }

        @Override
        public HttpPrincipal extract(URLConnection connection) throws IOException, ParseException {
            Object payload = new JSONParser().parse((Reader)new InputStreamReader(connection.getInputStream()));
            Stack pathElements = EscapeUtil.extractElementsFromPath((String)this.path);
            Object result = payload;
            while (!pathElements.isEmpty()) {
                if (result == null) {
                    throw new IllegalArgumentException("No path '" + this.path + "' found in " + payload.toString());
                }
                String key = (String)pathElements.pop();
                result = this.extractValue(result, key);
            }
            return new HttpPrincipal(result.toString(), DelegatingAuthenticator.this.realm);
        }

        private Object extractValue(Object payload, String key) {
            if (payload instanceof JSONObject) {
                return ((JSONObject)payload).get((Object)key);
            }
            if (payload instanceof JSONArray) {
                return ((JSONArray)payload).get(Integer.parseInt(key));
            }
            return null;
        }
    }

    private static interface PrincipalExtractor {
        public HttpPrincipal extract(URLConnection var1) throws IOException, ParseException;
    }
}

