/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.jvmagent.security.ClientCertAuthenticator;
import org.jolokia.jvmagent.security.DelegatingAuthenticator;
import org.jolokia.jvmagent.security.JaasAuthenticator;
import org.jolokia.jvmagent.security.MultiAuthenticator;
import org.jolokia.jvmagent.security.UserPasswordAuthenticator;
import org.jolokia.util.JolokiaCipher;
import org.jolokia.util.NetworkUtil;

public class JolokiaServerConfig {
    private Configuration jolokiaConfig;
    private String protocol;
    private int port;
    private int backlog;
    private InetAddress address;
    private String executor;
    private String threadNamePrefix;
    private int threadNr;
    private String keystore;
    private String context;
    private boolean useSslClientAuthentication;
    private char[] keystorePassword;
    private Authenticator authenticator;
    private String secureSocketProtocol;
    private String keyManagerAlgorithm;
    private String trustManagerAlgorithm;
    private String keyStoreType;
    private String caCert;
    private String serverCert;
    private String serverKey;
    private String serverKeyAlgorithm;
    private List<String> clientPrincipals;
    private boolean extendedClientCheck;
    private String[] sslProtocols;
    private String[] sslCipherSuites;

    public JolokiaServerConfig(Map<String, String> pConfig) {
        this.init(pConfig);
    }

    protected void init(Map<String, String> pConfig) {
        Map<String, String> finalCfg = this.getDefaultConfig(pConfig);
        finalCfg.putAll(pConfig);
        this.prepareDetectorOptions(finalCfg);
        this.addJolokiaId(finalCfg);
        this.jolokiaConfig = new Configuration(new Object[0]);
        this.jolokiaConfig.updateGlobalConfiguration(finalCfg);
        this.initConfigAndValidate(finalCfg);
    }

    private void addJolokiaId(Map<String, String> pFinalCfg) {
        if (!pFinalCfg.containsKey(ConfigKey.AGENT_ID.getKeyValue())) {
            pFinalCfg.put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId((int)this.hashCode(), (String)"jvm"));
        }
        pFinalCfg.put(ConfigKey.AGENT_TYPE.getKeyValue(), "jvm");
    }

    protected Map<String, String> getDefaultConfig(Map<String, String> pConfig) {
        InputStream is = this.getClass().getResourceAsStream("/default-jolokia-agent.properties");
        return this.readPropertiesFromInputStream(is, "default-jolokia-agent.properties");
    }

    public Configuration getJolokiaConfig() {
        return this.jolokiaConfig;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean useHttps() {
        return this.protocol.equalsIgnoreCase("https");
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getContextPath() {
        return this.context;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public int getThreadNr() {
        return this.threadNr;
    }

    public boolean useSslClientAuthentication() {
        return this.useSslClientAuthentication;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getServerCert() {
        return this.serverCert;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getServerKeyAlgorithm() {
        return this.serverKeyAlgorithm;
    }

    public String[] getSSLProtocols() {
        return this.sslProtocols;
    }

    public String[] getSSLCipherSuites() {
        return this.sslCipherSuites;
    }

    public void updateHTTPSSettingsFromContext(SSLContext sslContext) {
        SSLParameters parameters = sslContext.getSupportedSSLParameters();
        if (this.sslProtocols == null) {
            this.sslProtocols = parameters.getProtocols();
        } else {
            List<String> supportedProtocols = Arrays.asList(parameters.getProtocols());
            ArrayList<String> sslProtocolsList = new ArrayList<String>(Arrays.asList(this.sslProtocols));
            Iterator pit = sslProtocolsList.iterator();
            while (pit.hasNext()) {
                String protocol = (String)pit.next();
                if (supportedProtocols.contains(protocol)) continue;
                System.out.println("Jolokia: Discarding unsupported protocol: " + protocol);
                pit.remove();
            }
            this.sslProtocols = sslProtocolsList.toArray(new String[0]);
        }
        if (this.sslCipherSuites == null) {
            this.sslCipherSuites = parameters.getCipherSuites();
        } else {
            List<String> supportedCipherSuites = Arrays.asList(parameters.getCipherSuites());
            ArrayList<String> sslCipherSuitesList = new ArrayList<String>(Arrays.asList(this.sslCipherSuites));
            Iterator cit = sslCipherSuitesList.iterator();
            while (cit.hasNext()) {
                String cipher = (String)cit.next();
                if (supportedCipherSuites.contains(cipher)) continue;
                System.out.println("Jolokia: Discarding unsupported cipher suite: " + cipher);
                cit.remove();
            }
            this.sslCipherSuites = sslCipherSuitesList.toArray(new String[0]);
        }
    }

    protected void initConfigAndValidate(Map<String, String> agentConfig) {
        this.initContext();
        this.initProtocol(agentConfig);
        this.initAddress(agentConfig);
        this.port = Integer.parseInt(agentConfig.get("port"));
        this.backlog = Integer.parseInt(agentConfig.get("backlog"));
        this.initExecutor(agentConfig);
        this.initThreadNamePrefix(agentConfig);
        this.initThreadNr(agentConfig);
        this.initHttpsRelatedSettings(agentConfig);
        this.initAuthenticator();
    }

    private void initAuthenticator() {
        this.initCustomAuthenticator();
        if (this.authenticator == null) {
            this.initAuthenticatorFromAuthMode();
        }
    }

    private void initCustomAuthenticator() {
        String authenticatorClass = this.jolokiaConfig.get(ConfigKey.AUTH_CLASS);
        if (authenticatorClass != null) {
            try {
                Class<?> authClass = Class.forName(authenticatorClass);
                if (!Authenticator.class.isAssignableFrom(authClass)) {
                    throw new IllegalArgumentException("Provided authenticator class [" + authenticatorClass + "] is not a subclass of Authenticator");
                }
                this.lookupAuthenticator(authClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find authenticator class", e);
            }
        }
    }

    private void lookupAuthenticator(Class pAuthClass) {
        try {
            try {
                Constructor constructorThatTakesConfiguration = pAuthClass.getConstructor(Configuration.class);
                this.authenticator = (Authenticator)constructorThatTakesConfiguration.newInstance(this.jolokiaConfig);
            }
            catch (NoSuchMethodException ignore) {
                this.authenticator = this.lookupAuthenticatorWithDefaultConstructor(pAuthClass, ignore);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create an instance of custom authenticator class with configuration", e);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
    }

    private Authenticator lookupAuthenticatorWithDefaultConstructor(Class pAuthClass, NoSuchMethodException ignore) throws InstantiationException, IllegalAccessException {
        try {
            Constructor defaultConstructor = pAuthClass.getConstructor(new Class[0]);
            return (Authenticator)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class, no default constructor to use", e);
        }
        catch (InvocationTargetException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator using default constructor", e);
        }
    }

    private void initAuthenticatorFromAuthMode() {
        String user = this.jolokiaConfig.get(ConfigKey.USER);
        String password = this.jolokiaConfig.get(ConfigKey.PASSWORD);
        String authMode = this.jolokiaConfig.get(ConfigKey.AUTH_MODE);
        String realm = this.jolokiaConfig.get(ConfigKey.REALM);
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        if (this.useHttps() && this.useSslClientAuthentication()) {
            authenticators.add(new ClientCertAuthenticator(this));
        }
        if ("basic".equalsIgnoreCase(authMode)) {
            if (user != null) {
                if (password == null) {
                    throw new IllegalArgumentException("'password' must be set if a 'user' (here: '" + user + "') is given");
                }
                authenticators.add(new UserPasswordAuthenticator(realm, user, password));
            }
        } else if ("jaas".equalsIgnoreCase(authMode)) {
            authenticators.add(new JaasAuthenticator(realm));
        } else if ("delegate".equalsIgnoreCase(authMode)) {
            authenticators.add(new DelegatingAuthenticator(realm, this.jolokiaConfig.get(ConfigKey.AUTH_URL), this.jolokiaConfig.get(ConfigKey.AUTH_PRINCIPAL_SPEC), this.jolokiaConfig.getAsBoolean(ConfigKey.AUTH_IGNORE_CERTS)));
        } else {
            throw new IllegalArgumentException("No auth method '" + authMode + "' known. Must be either 'basic' or 'jaas'");
        }
        this.authenticator = authenticators.isEmpty() ? null : (authenticators.size() == 1 ? (Authenticator)authenticators.get(0) : new MultiAuthenticator(MultiAuthenticator.Mode.fromString(this.jolokiaConfig.get(ConfigKey.AUTH_MATCH)), authenticators));
    }

    private void initProtocol(Map<String, String> agentConfig) {
        String string = this.protocol = agentConfig.containsKey("protocol") ? agentConfig.get("protocol") : "http";
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Invalid protocol '" + this.protocol + "'. Must be either 'http' or 'https'");
        }
    }

    private void initContext() {
        this.context = this.jolokiaConfig.get(ConfigKey.AGENT_CONTEXT);
        if (this.context == null) {
            this.context = ConfigKey.AGENT_CONTEXT.getDefaultValue();
        }
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    private void initHttpsRelatedSettings(Map<String, String> agentConfig) {
        List<String> sslCipherSuitesList;
        this.keystore = agentConfig.get("keystore");
        this.caCert = agentConfig.get("caCert");
        this.serverCert = agentConfig.get("serverCert");
        this.serverKey = agentConfig.get("serverKey");
        this.secureSocketProtocol = agentConfig.get("secureSocketProtocol");
        this.keyStoreType = agentConfig.get("keyStoreType");
        this.keyManagerAlgorithm = agentConfig.get("keyManagerAlgorithm");
        this.trustManagerAlgorithm = agentConfig.get("trustManagerAlgorithm");
        String auth = agentConfig.get("useSslClientAuthentication");
        this.useSslClientAuthentication = auth != null && Boolean.valueOf(auth) != false;
        String password = agentConfig.get("keystorePassword");
        this.keystorePassword = password != null ? this.decipherPasswordIfNecessary(password) : new char[]{};
        this.serverKeyAlgorithm = agentConfig.get("serverKeyAlgorithm");
        this.clientPrincipals = this.extractList(agentConfig, "clientPrincipal");
        String xCheck = agentConfig.get("extendedClientCheck");
        this.extendedClientCheck = xCheck != null && Boolean.valueOf(xCheck) != false;
        List<String> sslProtocolsList = this.extractList(agentConfig, "sslProtocol");
        if (sslProtocolsList != null) {
            this.sslProtocols = sslProtocolsList.toArray(new String[0]);
        }
        if ((sslCipherSuitesList = this.extractList(agentConfig, "sslCipherSuite")) != null) {
            this.sslCipherSuites = sslCipherSuitesList.toArray(new String[0]);
        }
    }

    private char[] decipherPasswordIfNecessary(String password) {
        Matcher encryptedPasswordMatcher = Pattern.compile("^\\[\\[(.*)]]$").matcher(password);
        if (encryptedPasswordMatcher.matches()) {
            String encryptedPassword = encryptedPasswordMatcher.group(1);
            try {
                JolokiaCipher jolokiaCipher = new JolokiaCipher();
                return jolokiaCipher.decrypt(encryptedPassword).toCharArray();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("Cannot decrypt password " + encryptedPassword);
            }
        }
        return password.toCharArray();
    }

    private List<String> extractList(Map<String, String> pAgentConfig, String pKey) {
        ArrayList<String> ret = new ArrayList<String>();
        if (pAgentConfig.containsKey(pKey)) {
            ret.add(pAgentConfig.get(pKey));
        }
        int idx = 1;
        String keyIdx = pKey + "." + idx;
        while (pAgentConfig.containsKey(keyIdx)) {
            ret.add(pAgentConfig.get(keyIdx));
            keyIdx = pKey + "." + ++idx;
        }
        return ret.size() > 0 ? ret : null;
    }

    private void initThreadNr(Map<String, String> pAgentConfig) {
        String threadNrS = pAgentConfig.get("threadNr");
        this.threadNr = threadNrS != null ? Integer.parseInt(threadNrS) : 5;
    }

    private void initExecutor(Map<String, String> agentConfig) {
        String string = this.executor = agentConfig.containsKey("executor") ? agentConfig.get("executor") : "single";
        if (!("single".equalsIgnoreCase(this.executor) || "fixed".equalsIgnoreCase(this.executor) || "cached".equalsIgnoreCase(this.executor))) {
            throw new IllegalArgumentException("Executor model can be '" + this.executor + "' but most be either 'single', 'fixed' or 'cached'");
        }
    }

    private void initThreadNamePrefix(Map<String, String> agentConfig) {
        this.threadNamePrefix = agentConfig.get("threadNamePrefix");
        if (this.threadNamePrefix == null || this.threadNamePrefix.isEmpty()) {
            this.threadNamePrefix = "jolokia-";
        }
    }

    private void initAddress(Map<String, String> agentConfig) {
        String host = agentConfig.get("host");
        try {
            this.address = "*".equals(host) || "0.0.0.0".equals(host) ? null : (host != null ? InetAddress.getByName(host) : InetAddress.getByName(null));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Can not lookup " + (host != null ? host : "loopback interface") + ": " + e, e);
        }
    }

    protected Map<String, String> readPropertiesFromInputStream(InputStream pIs, String pLabel) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pIs == null) {
            return ret;
        }
        Properties props = new Properties();
        try {
            props.load(pIs);
            ret.putAll(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jolokia: Cannot load properties " + pLabel + " : " + e, e);
        }
        return ret;
    }

    protected void prepareDetectorOptions(Map<String, String> pConfig) {
        StringBuffer detectorOpts = new StringBuffer("{");
        if (pConfig.containsKey("bootAmx") && Boolean.parseBoolean(pConfig.get("bootAmx"))) {
            detectorOpts.append("\"glassfish\" : { \"bootAmx\" : true }");
        }
        if (detectorOpts.length() > 1) {
            detectorOpts.append("}");
            pConfig.put(ConfigKey.DETECTOR_OPTIONS.getKeyValue(), detectorOpts.toString());
        }
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public List<String> getClientPrincipals() {
        return this.clientPrincipals;
    }

    public boolean getExtendedClientCheck() {
        return this.extendedClientCheck;
    }
}

