/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.parser.ParseException;
import org.jolokia.json.parser.Yylex;
import org.jolokia.json.parser.Yytoken;

public class JSONParser {
    private final Deque<State> states = new ArrayDeque<State>(256);
    private final Deque<Object> values = new ArrayDeque<Object>(256);
    private final Object NULL = new Object();

    public Object parse(Reader reader) throws ParseException, IOException, IllegalStateException {
        Yytoken token;
        Yylex lexer = new Yylex(reader, 16);
        this.states.push(State.INITIAL);
        while (!lexer.yyatEOF() && (token = lexer.yylex()) != null) {
            int line = lexer.line();
            int column = lexer.column();
            if (this.states.isEmpty()) {
                throw new IllegalStateException("Remaining JSON data at (" + line + ":" + column + ")");
            }
            switch (this.states.peek()) {
                case INITIAL: {
                    this.processValue(lexer, token, true);
                    break;
                }
                case DONE: {
                    this.handleNotCleanEndState(lexer);
                    break;
                }
                case PARSING_OBJECT: {
                    this.processObject(lexer, token, false);
                    break;
                }
                case PARSING_ARRAY: {
                    this.processArray(lexer, token, false);
                    break;
                }
                case COMMA: {
                    this.processComma(lexer, token);
                    break;
                }
                case PARSING_VALUE: {
                    this.processValue(lexer, token, false);
                    break;
                }
            }
        }
        if (this.values.isEmpty()) {
            throw new ParseException("Can't parse any value from JSON stream").at(lexer.line(), lexer.column());
        }
        if (this.states.isEmpty()) {
            throw new IllegalStateException("Bad parser state (not DONE, EOF encountered)");
        }
        if (this.states.peek() != State.DONE) {
            throw new IllegalStateException("Bad parser state, EOF at state " + String.valueOf((Object)this.states.peek()));
        }
        Object value = this.values.pop();
        return value == this.NULL ? null : value;
    }

    private void processValue(Yylex lexer, Yytoken token, boolean topLevel) throws ParseException {
        Object primitiveValue = null;
        switch (token.getKind()) {
            case SYMBOL_LEFT_BRACE: {
                this.states.push(State.PARSING_OBJECT);
                this.values.push(new JSONObject());
                break;
            }
            case SYMBOL_LEFT_SQUARE: {
                this.states.push(State.PARSING_ARRAY);
                this.values.push(new JSONArray());
                break;
            }
            case VALUE_STRING: {
                primitiveValue = token.getStringValue();
                break;
            }
            case VALUE_INTEGER: {
                primitiveValue = this.optimizedIntegerValue(token.getIntegerValue());
                break;
            }
            case VALUE_DECIMAL: {
                primitiveValue = token.getDecimalValue();
                break;
            }
            case VALUE_BOOLEAN: {
                primitiveValue = token.getBooleanValue();
                break;
            }
            case VALUE_NULL: {
                primitiveValue = this.NULL;
                break;
            }
            default: {
                if (topLevel) {
                    throw new ParseException("Unexpected top-level token (kind: " + token.getKind().name() + ")").at(lexer.line(), lexer.column());
                }
                throw new ParseException("Unexpected token (kind: " + token.getKind().name() + ")").at(lexer.line(), lexer.column());
            }
        }
        if (token.getKind().isValueToken()) {
            this.valueReady(lexer, primitiveValue);
        }
    }

    private void processObject(Yylex lexer, Yytoken token, boolean hadComma) throws ParseException, IOException {
        Yytoken.Kind kind = token.getKind();
        Object currentValue = this.values.peek();
        if (currentValue == null || currentValue.getClass() != JSONObject.class) {
            throw new IllegalStateException("Parser expects JSONObject as current value (" + lexer.line() + ":" + lexer.column() + ")");
        }
        if (kind == Yytoken.Kind.SYMBOL_RIGHT_BRACE) {
            if (hadComma) {
                throw new ParseException("Trailing comma is not allowed within JSON object").at(lexer.line(), lexer.column());
            }
            this.states.pop();
            this.valueReady(lexer, null);
            return;
        }
        if (kind == Yytoken.Kind.SYMBOL_COMMA) {
            if (((JSONObject)currentValue).isEmpty()) {
                throw new ParseException("Leading comma is not allowed within JSON object").at(lexer.line(), lexer.column());
            }
            this.states.push(State.COMMA);
            return;
        }
        if (kind.isValueToken()) {
            if (kind != Yytoken.Kind.VALUE_STRING) {
                throw new ParseException("Only string keys are allowed within JSON object").at(lexer.line(), lexer.column());
            }
            Yytoken expectedColon = lexer.yylex();
            if (expectedColon == null || expectedColon.getKind() != Yytoken.Kind.SYMBOL_COLON) {
                throw new ParseException("Expected ':' after key").at(lexer.line(), lexer.column());
            }
            this.values.push(token.getStringValue());
            this.states.push(State.PARSING_VALUE);
            return;
        }
        throw new ParseException("Unexpected token (kind: " + String.valueOf((Object)token.getKind()) + ") when parsing JSON object").at(lexer.line(), lexer.column());
    }

    private void processArray(Yylex lexer, Yytoken token, boolean hadComma) throws ParseException {
        Yytoken.Kind kind = token.getKind();
        Object currentValue = this.values.peek();
        if (currentValue == null || currentValue.getClass() != JSONArray.class) {
            throw new IllegalStateException("Parser expects JSONArray as current value (" + lexer.line() + ":" + lexer.column() + ")");
        }
        if (kind == Yytoken.Kind.SYMBOL_RIGHT_SQUARE) {
            if (hadComma) {
                throw new ParseException("Trailing comma is not allowed within JSON array").at(lexer.line(), lexer.column());
            }
            this.states.pop();
            this.valueReady(lexer, null);
            return;
        }
        if (kind == Yytoken.Kind.SYMBOL_COMMA) {
            if (((JSONArray)currentValue).isEmpty()) {
                throw new ParseException("Leading comma is not allowed within JSON array").at(lexer.line(), lexer.column());
            }
            this.states.push(State.COMMA);
            return;
        }
        this.processValue(lexer, token, false);
    }

    private void processComma(Yylex lexer, Yytoken token) throws ParseException, IOException {
        this.states.pop();
        if (this.states.isEmpty()) {
            throw new IllegalStateException("Bad parser state, expected PARSING_OBJECT or PARSING_ARRAY");
        }
        State state = this.states.peek();
        if (state == State.PARSING_ARRAY) {
            this.processArray(lexer, token, true);
        } else if (state == State.PARSING_OBJECT) {
            this.processObject(lexer, token, true);
        }
    }

    private void valueReady(Yylex lexer, Object value) {
        State state = this.states.peek();
        if (state == null) {
            throw new IllegalStateException("Bad parser state when handling value at (" + lexer.line() + ":" + lexer.column() + ")");
        }
        int requiredStackSize = 0;
        switch (state) {
            case INITIAL: {
                if (value != null) break;
                requiredStackSize = 1;
                break;
            }
            case PARSING_ARRAY: {
                requiredStackSize = value == null ? 2 : 1;
                break;
            }
            case PARSING_OBJECT: {
                int n = requiredStackSize = value == null ? 3 : 2;
            }
        }
        if (this.values.size() < requiredStackSize) {
            if (state == State.PARSING_OBJECT) {
                throw new IllegalStateException("Can't process value for JSON object. Bad stack size (size: " + this.values.size() + ")");
            }
            if (state == State.PARSING_ARRAY) {
                throw new IllegalStateException("Can't process value for JSON array. Bad stack size (size: " + this.values.size() + ")");
            }
        }
        if (value == null) {
            value = this.values.pop();
        }
        switch (state) {
            case INITIAL: {
                this.values.push(value);
                this.states.push(State.DONE);
                break;
            }
            case PARSING_VALUE: {
                Object key = this.values.pop();
                Object object = this.values.peek();
                if (!(object instanceof JSONObject)) {
                    throw new IllegalStateException("Can't process value for JSON object. Wrong object (got: " + String.valueOf(object == null ? "<null>" : object.getClass()) + ")");
                }
                if (!(key instanceof String)) {
                    throw new IllegalStateException("Can't process value for JSON object. Wrong key type (got: " + String.valueOf(key == null ? "<null>" : key.getClass()) + ")");
                }
                ((JSONObject)object).put((String)key, value == this.NULL ? null : value);
                this.states.pop();
                break;
            }
            case PARSING_ARRAY: {
                Object array = this.values.peek();
                if (!(array instanceof JSONArray)) {
                    throw new IllegalStateException("Can't process value for JSON array. Wrong object (got: " + String.valueOf(array == null ? "<null>" : array.getClass()) + ")");
                }
                ((JSONArray)array).add(value == this.NULL ? null : value);
                break;
            }
        }
    }

    private void handleNotCleanEndState(Yylex lexer) throws ParseException {
        this.states.pop();
        State state = this.states.pop();
        if (state != State.INITIAL) {
            throw new IllegalStateException("Expected top-level state (got: " + String.valueOf((Object)state) + ") at (" + lexer.line() + ":" + lexer.column() + ")");
        }
        throw new ParseException("Multiple top-level values").at(lexer.line(), lexer.column());
    }

    private Number optimizedIntegerValue(BigInteger v) {
        if (v.bitLength() <= 31) {
            return v.intValue();
        }
        if (v.bitLength() <= 63) {
            return v.longValue();
        }
        return v;
    }

    public <T> T parse(Reader reader, Class<T> clazz) throws ParseException, IOException {
        Object result = this.parse(reader);
        if (clazz.isInstance(result)) {
            return clazz.cast(result);
        }
        throw new IllegalArgumentException("Can't parse JSON data into " + clazz.getName() + " (got " + String.valueOf(result.getClass()) + ")");
    }

    public Object parse(String json) throws ParseException, IOException {
        return this.parse(new StringReader(json));
    }

    public <T> T parse(String json, Class<T> clazz) throws ParseException, IOException {
        return this.parse(new StringReader(json), clazz);
    }

    private static enum State {
        INITIAL,
        DONE,
        PARSING_OBJECT,
        PARSING_ARRAY,
        PARSING_VALUE,
        COMMA;

    }
}

