/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.kubernetes.client;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jolokia.server.core.util.Base64Util;
import org.json.simple.JSONObject;

public class MinimalHttpClientAdapter
implements org.apache.http.client.HttpClient {
    private final KubernetesClient client;
    private final KubernetesSerialization serialization;
    private final String urlPath;
    private String user;
    private String password;

    public MinimalHttpClientAdapter(KubernetesClient client, String urlPath, Map<String, Object> env) {
        this.client = client;
        this.serialization = this.client.getKubernetesSerialization();
        this.urlPath = urlPath;
        String[] credentials = (String[])env.get("jmx.remote.credentials");
        if (credentials != null) {
            this.user = credentials[0];
            this.password = credentials[1];
        }
    }

    static void authenticate(Map<String, String> headers, String username, String password) {
        if (username != null) {
            headers.put("X-jolokia-authorization", "Basic " + Base64Util.encode((byte[])(username + ":" + password).getBytes()));
        }
    }

    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        try {
            Response response = MinimalHttpClientAdapter.performRequest(this.client, this.urlPath, this.extractBody((HttpRequest)httpUriRequest), httpUriRequest.getURI().getQuery(), this.allHeaders(httpUriRequest));
            return this.convertResponse(response);
        }
        catch (KubernetesClientException e) {
            throw new ClientProtocolException((Throwable)e);
        }
    }

    private Map<String, String> allHeaders(HttpUriRequest httpUriRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : httpUriRequest.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        MinimalHttpClientAdapter.authenticate(headers, this.user, this.password);
        return headers;
    }

    public static Response performRequest(KubernetesClient client, String path, byte[] body, String query, Map<String, String> headers) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])body)).url(MinimalHttpClientAdapter.buildHttpUri(client, path, query));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        HttpClient k8sHttpClient = client.getHttpClient();
        OkHttpClient okHttpClient = ((OkHttpClientImpl)k8sHttpClient).getOkHttpClient();
        return okHttpClient.newCall(requestBuilder.build()).execute();
    }

    private static URL buildHttpUri(KubernetesClient client, String resourcePath, String query) {
        URL masterUrl = client.getMasterUrl();
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(masterUrl.getProtocol()).host(masterUrl.getHost()).query(query);
        builder.encodedPath(resourcePath);
        if (masterUrl.getPort() != -1) {
            builder.port(masterUrl.getPort());
        }
        return builder.build().url();
    }

    protected HttpResponse convertResponse(Response response) throws IOException {
        int responseCode = response.code();
        BasicHttpResponse convertedResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(this.convertProtocol(response.protocol()), responseCode, response.message()));
        for (String header : response.headers().names()) {
            convertedResponse.setHeader(header, response.header(header));
        }
        if (response.body() != null) {
            BasicHttpEntity responseEntity = new BasicHttpEntity();
            byte[] responseBytes = null;
            if (responseCode >= 400) {
                JSONObject errorResponse = new JSONObject();
                Object syntethicException = new ClientProtocolException("Failure calling Jolokia in kubernetes");
                errorResponse.put((Object)"status", (Object)responseCode);
                try {
                    syntethicException = new KubernetesClientException(this.convertResponseBody(response));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                errorResponse.put((Object)"error_type", (Object)syntethicException.getClass().getName());
                errorResponse.put((Object)"error", (Object)((Throwable)syntethicException).getMessage());
                StringWriter stacktrace = new StringWriter();
                ((Throwable)syntethicException).printStackTrace(new PrintWriter(stacktrace));
                errorResponse.put((Object)"stacktrace", (Object)stacktrace.getBuffer().toString());
                responseBytes = errorResponse.toJSONString().getBytes();
            } else {
                responseBytes = response.body().bytes();
            }
            responseEntity.setContentLength((long)responseBytes.length);
            responseEntity.setContent((InputStream)new ByteArrayInputStream(responseBytes));
            responseEntity.setContentType(response.header("Content-Type"));
            convertedResponse.setEntity((HttpEntity)responseEntity);
            convertedResponse.setHeader("Content-Length", String.valueOf(responseBytes.length));
        }
        return convertedResponse;
    }

    private Status convertResponseBody(Response response) {
        String statusMessage = "";
        ResponseBody body = response != null ? response.body() : null;
        int statusCode = response != null ? response.code() : 0;
        try {
            if (body != null) {
                statusMessage = body.string();
            } else if (response != null) {
                statusMessage = response.message();
            }
            Status status = (Status)this.serialization.unmarshal(statusMessage, Status.class);
            if (status.getCode() == null) {
                status = ((StatusBuilder)new StatusBuilder(status).withCode(Integer.valueOf(statusCode))).build();
            }
            return status;
        }
        catch (IOException e) {
            return OperationSupport.createStatus((int)statusCode, (String)statusMessage);
        }
    }

    protected byte[] extractBody(HttpRequest httpUriRequest) throws IOException {
        if (httpUriRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)httpUriRequest).getEntity();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)buffer);
            return buffer.toByteArray();
        }
        return null;
    }

    private ProtocolVersion convertProtocol(Protocol protocol) {
        StringTokenizer parser = new StringTokenizer(protocol.name(), "_", false);
        return new ProtocolVersion(parser.nextToken(), Integer.parseInt(parser.nextToken()), parser.hasMoreTokens() ? Integer.parseInt(parser.nextToken()) : 0);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

