/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.Date;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pType;
import org.jolokia.json.JSONObject;

public abstract class J4pResponse<T extends J4pRequest> {
    private final JSONObject jsonResponse;
    private T request;
    private final J4pType type;
    private final Date requestDate;

    protected J4pResponse(T pRequest, JSONObject pJsonResponse) {
        this.request = pRequest;
        this.type = ((J4pRequest)pRequest).getType();
        this.jsonResponse = pJsonResponse;
        Number timestamp = (Number)this.jsonResponse.get((Object)"timestamp");
        this.requestDate = timestamp != null ? new Date(timestamp.longValue() * 1000L) : new Date();
    }

    public T getRequest() {
        return this.request;
    }

    public void clearRequest() {
        this.request = null;
    }

    public J4pType getType() {
        return this.type;
    }

    public Date getRequestDate() {
        return (Date)this.requestDate.clone();
    }

    public <V> V getValue() {
        return (V)this.jsonResponse.get((Object)"value");
    }

    public JSONObject asJSONObject() {
        return this.jsonResponse;
    }
}

