/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpExchange;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jolokia.server.core.util.UserPasswordCallbackHandler;

public class JaasHttpAuthenticator
extends BasicAuthenticator {
    private final ThreadLocal<Subject> subjectThreadLocal = new ThreadLocal();
    private final ClassLoader classLoader;

    public JaasHttpAuthenticator(String pRealm, ClassLoader classLoader) {
        super(pRealm);
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authenticator.Result authenticate(HttpExchange pHttpExchange) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Subject subject;
            Authenticator.Result result;
            if (this.classLoader != null) {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
            if ((result = super.authenticate(pHttpExchange)) instanceof Authenticator.Success && (subject = this.subjectThreadLocal.get()) != null) {
                pHttpExchange.setAttribute("org.jolokia.jaasSubject", subject);
            }
            Authenticator.Result result2 = result;
            return result2;
        }
        finally {
            this.subjectThreadLocal.remove();
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    @Override
    public boolean checkCredentials(String pUser, String pPassword) {
        try {
            UserPasswordCallbackHandler handler = new UserPasswordCallbackHandler(pUser, pPassword);
            LoginContext loginContext = this.createLoginContext(this.realm, (CallbackHandler)handler);
            loginContext.login();
            this.subjectThreadLocal.set(loginContext.getSubject());
            return true;
        }
        catch (LoginException e) {
            return false;
        }
    }

    protected LoginContext createLoginContext(String realm, CallbackHandler handler) throws LoginException {
        return new LoginContext(realm, handler);
    }
}

