/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jolokia.jvmagent.CleanupThread;
import org.jolokia.jvmagent.JolokiaHttpsConfigurator;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.handler.JolokiaHttpHandler;
import org.jolokia.jvmagent.security.KeyStoreUtil;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.restrictor.RestrictorFactory;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceCreator;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.impl.ClasspathServiceCreator;
import org.jolokia.server.core.service.impl.StdoutLogHandler;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.server.core.util.DaemonThreadFactory;
import org.jolokia.server.core.util.LocalServiceFactory;
import org.jolokia.server.core.util.NetworkUtil;

public class JolokiaServer {
    private JolokiaServerConfig config;
    private CleanupThread cleaner = null;
    private HttpServer httpServer;
    private InetSocketAddress serverAddress;
    private String url;
    private JolokiaServiceManager serviceManager;
    private boolean useOwnServer = false;
    private HttpContext httpContext;
    private HttpContext httpConfigContext;
    private final List<File> filesToWatch = new ArrayList<File>();

    public JolokiaServer(JolokiaServerConfig pConfig) throws IOException {
        this.init(pConfig, null, null);
    }

    public JolokiaServer(JolokiaServerConfig pConfig, ServerDetectorLookup pLookup) throws IOException {
        this.init(pConfig, null, pLookup);
    }

    public JolokiaServer(JolokiaServerConfig pConfig, LogHandler pLogHandler) throws IOException {
        this.init(pConfig, pLogHandler, null);
    }

    public JolokiaServer(HttpServer pServer, JolokiaServerConfig pConfig, LogHandler pLogHandler) {
        this.init(pServer, pConfig, pLogHandler, null);
    }

    protected JolokiaServer() {
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean pLazy) {
        HttpHandler jolokiaHttpHandler = this.createJolokiaHttpHandler(pLazy);
        String base = this.config.getContextPath();
        while (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        this.httpConfigContext = this.httpServer.createContext(base + "/config", jolokiaHttpHandler);
        this.httpContext = this.httpServer.createContext(base, jolokiaHttpHandler);
        this.setupAuthentication();
        if (this.useOwnServer) {
            this.startCleanupThread();
        }
    }

    public void stop() {
        this.httpServer.removeContext(this.httpContext);
        this.serviceManager.stop();
        if (this.cleaner != null) {
            Runtime.getRuntime().removeShutdownHook(this.cleaner);
            this.cleaner.stopServer();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public JolokiaServerConfig getServerConfig() {
        return this.config;
    }

    public InetSocketAddress getAddress() {
        return this.serverAddress;
    }

    protected final void init(JolokiaServerConfig pConfig, LogHandler pLogHandler) throws IOException {
        this.init(this.createHttpServer(pConfig), pConfig, pLogHandler, null);
        this.useOwnServer = true;
    }

    protected final void init(JolokiaServerConfig pConfig, LogHandler pLogHandler, ServerDetectorLookup pLookup) throws IOException {
        this.init(this.createHttpServer(pConfig), pConfig, pLogHandler, pLookup);
        this.useOwnServer = true;
    }

    protected void addService(JolokiaService<?> pService) {
        this.serviceManager.addService(pService);
    }

    private void init(HttpServer pServer, JolokiaServerConfig pConfig, LogHandler pLogHandler, ServerDetectorLookup pLookup) {
        this.config = pConfig;
        this.httpServer = pServer;
        Configuration jolokiaCfg = this.config.getJolokiaConfig();
        LogHandler log = pLogHandler != null ? pLogHandler : this.createLogHandler(jolokiaCfg.getConfig(ConfigKey.LOGHANDLER_CLASS), jolokiaCfg.getConfig(ConfigKey.LOGHANDLER_NAME), Boolean.parseBoolean(jolokiaCfg.getConfig(ConfigKey.DEBUG)));
        this.serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager((Configuration)jolokiaCfg, (LogHandler)log, (Restrictor)RestrictorFactory.createRestrictor((Configuration)jolokiaCfg, (LogHandler)log), (ServerDetectorLookup)pLookup);
        ClassLoader loader = this.config.getClassLoader();
        if (loader == null) {
            loader = LocalServiceFactory.class.getClassLoader();
        }
        this.serviceManager.addServices((JolokiaServiceCreator)new ClasspathServiceCreator(loader, "services"));
        this.serverAddress = pServer.getAddress();
        this.url = this.detectAgentUrl(pServer, pConfig, pConfig.getContextPath());
    }

    private HttpHandler createJolokiaHttpHandler(boolean pLazy) {
        if (pLazy) {
            return new LazyInitializedJolokiaHttpHandler();
        }
        return this.startupJolokiaContext();
    }

    private HttpHandler startupJolokiaContext() {
        JolokiaContext jolokiaContext = this.serviceManager.start();
        JolokiaHttpHandler jolokiaHttpHandler = new JolokiaHttpHandler(jolokiaContext);
        this.updateAgentUrl(jolokiaContext);
        return jolokiaHttpHandler;
    }

    private void updateAgentUrl(JolokiaContext pJolokiaContext) {
        String configUrl = this.config.getJolokiaConfig().getConfig(ConfigKey.DISCOVERY_AGENT_URL);
        pJolokiaContext.getAgentDetails().updateAgentParameters(configUrl != null ? configUrl : this.url, Boolean.valueOf(this.config.getAuthenticator() != null));
    }

    private void setupAuthentication() {
        Authenticator authenticator = this.config.getAuthenticator();
        if (authenticator != null) {
            this.httpContext.setAuthenticator(authenticator);
        }
    }

    private void startCleanupThread() {
        ThreadGroup threadGroup = new ThreadGroup("jolokia");
        Thread starterThread = new Thread(threadGroup, () -> this.httpServer.start());
        starterThread.start();
        this.cleaner = new CleanupThread(this.httpServer, threadGroup);
        Runtime.getRuntime().addShutdownHook(this.cleaner);
    }

    private LogHandler createLogHandler(String pLogHandlerClass, String pLogHandlerName, boolean pIsDebug) {
        if (pLogHandlerClass != null) {
            return ClassUtil.newLogHandlerInstance((String)pLogHandlerClass, (String)pLogHandlerName, (boolean)pIsDebug);
        }
        return new StdoutLogHandler(pIsDebug);
    }

    private String detectAgentUrl(HttpServer pServer, JolokiaServerConfig pConfig, String pContextPath) {
        int port;
        InetAddress realAddress;
        this.serverAddress = pServer.getAddress();
        if (this.serverAddress != null) {
            realAddress = this.serverAddress.getAddress();
            port = this.serverAddress.getPort();
        } else {
            realAddress = pConfig.getAddress();
            port = pConfig.getPort();
        }
        if (realAddress.isAnyLocalAddress()) {
            try {
                boolean preferIPv6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");
                realAddress = realAddress instanceof Inet6Address && preferIPv6Addresses ? NetworkUtil.getLocalAddress(Inet6Address.class) : NetworkUtil.getLocalAddress(Inet4Address.class);
            }
            catch (IOException e) {
                try {
                    realAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e1) {
                    realAddress = this.serverAddress.getAddress();
                }
            }
        }
        String hostAddress = realAddress.getHostAddress();
        if (realAddress instanceof Inet6Address) {
            int percent;
            if ((((Inet6Address)realAddress).getScopedInterface() != null || ((Inet6Address)realAddress).getScopeId() > 0) && (percent = hostAddress.indexOf(37)) != -1) {
                hostAddress = hostAddress.substring(0, percent);
            }
            return String.format("%s://[%s]:%d%s", pConfig.getProtocol(), hostAddress, port, pContextPath);
        }
        return String.format("%s://%s:%d%s", pConfig.getProtocol(), hostAddress, port, pContextPath);
    }

    private HttpServer createHttpServer(JolokiaServerConfig pConfig) throws IOException {
        pConfig.initAuthenticator();
        int port = pConfig.getPort();
        InetAddress address = pConfig.getAddress();
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        HttpServer server = pConfig.useHttps() ? this.createHttpsServer(socketAddress, pConfig) : HttpServer.create(socketAddress, pConfig.getBacklog());
        DaemonThreadFactory daemonThreadFactory = new DaemonThreadFactory(pConfig.getThreadNamePrefix());
        String mode = pConfig.getExecutor();
        ExecutorService executor = "fixed".equalsIgnoreCase(mode) ? Executors.newFixedThreadPool(pConfig.getThreadNr(), (ThreadFactory)daemonThreadFactory) : ("cached".equalsIgnoreCase(mode) ? Executors.newCachedThreadPool((ThreadFactory)daemonThreadFactory) : Executors.newSingleThreadExecutor((ThreadFactory)daemonThreadFactory));
        server.setExecutor(executor);
        return server;
    }

    private HttpServer createHttpsServer(InetSocketAddress pSocketAddress, JolokiaServerConfig pConfig) {
        try {
            HttpsServer server = HttpsServer.create(pSocketAddress, pConfig.getBacklog());
            SSLContext sslContext = SSLContext.getInstance(pConfig.getSecureSocketProtocol());
            KeyStore ks = this.getKeyStore(pConfig, this.filesToWatch);
            KeyManagerFactory kmf = this.getKeyManagerFactory(pConfig);
            kmf.init(ks, pConfig.getKeystorePassword());
            TrustManagerFactory tmf = this.getTrustManagerFactory(pConfig);
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            pConfig.updateHTTPSSettingsFromContext(sslContext);
            server.setHttpsConfigurator(new JolokiaHttpsConfigurator(sslContext, pConfig));
            return server;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot use keystore for https communication: " + String.valueOf(e), e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open keystore for https communication: " + String.valueOf(e), e);
        }
    }

    private TrustManagerFactory getTrustManagerFactory(JolokiaServerConfig pConfig) throws NoSuchAlgorithmException {
        String algo = pConfig.getTrustManagerAlgorithm();
        return TrustManagerFactory.getInstance(algo != null ? algo : TrustManagerFactory.getDefaultAlgorithm());
    }

    private KeyManagerFactory getKeyManagerFactory(JolokiaServerConfig pConfig) throws NoSuchAlgorithmException {
        String algo = pConfig.getKeyManagerAlgorithm();
        return KeyManagerFactory.getInstance(algo != null ? algo : KeyManagerFactory.getDefaultAlgorithm());
    }

    private KeyStore getKeyStore(JolokiaServerConfig pConfig, List<File> filesToWatch) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, InvalidKeyException, NoSuchProviderException, SignatureException {
        char[] password = pConfig.getKeystorePassword();
        String keystoreFile = pConfig.getKeystore();
        KeyStore keystore = KeyStore.getInstance(pConfig.getKeyStoreType());
        if (keystoreFile != null) {
            File file = this.loadKeyStoreFromFile(keystore, keystoreFile, password);
            filesToWatch.add(file);
        } else {
            keystore.load(null);
            File[] caCerKey = this.updateKeyStoreFromPEM(keystore, pConfig);
            Arrays.stream(caCerKey).filter(Objects::nonNull).forEach(filesToWatch::add);
            if (pConfig.getServerCert() == null) {
                KeyStoreUtil.updateWithSelfSignedServerCertificate(keystore, pConfig);
            }
        }
        return keystore;
    }

    private File[] updateKeyStoreFromPEM(KeyStore keystore, JolokiaServerConfig pConfig) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, InvalidKeySpecException {
        File[] result = new File[3];
        if (pConfig.getCaCert() != null) {
            File caCert = this.getAndValidateFile(pConfig.getCaCert(), "CA cert");
            KeyStoreUtil.updateWithCaPem(keystore, caCert);
            result[0] = caCert;
        } else if (pConfig.useSslClientAuthentication()) {
            throw new IllegalArgumentException("Cannot use client cert authentication if no CA is given with 'caCert'");
        }
        if (pConfig.getServerCert() != null) {
            File serverCert = this.getAndValidateFile(pConfig.getServerCert(), "server cert");
            if (pConfig.getServerKey() == null) {
                throw new IllegalArgumentException("Cannot use server cert from " + pConfig.getServerCert() + " without a provided a key given with 'serverKey'");
            }
            File serverKey = this.getAndValidateFile(pConfig.getServerKey(), "server key");
            KeyStoreUtil.updateWithServerPems(keystore, serverCert, serverKey, pConfig.getServerKeyAlgorithm(), pConfig.getKeystorePassword());
            result[1] = serverCert;
            result[2] = serverKey;
        }
        return result;
    }

    private File getAndValidateFile(String pFile, String pWhat) throws IOException {
        File ret = new File(pFile);
        if (!ret.exists()) {
            throw new FileNotFoundException("No such " + pWhat + " " + pFile);
        }
        if (!ret.canRead()) {
            throw new IOException(pWhat.substring(0, 1).toUpperCase() + pWhat.substring(1) + " " + pFile + " is not readable");
        }
        return ret;
    }

    private File loadKeyStoreFromFile(KeyStore pKeyStore, String pFile, char[] pPassword) throws IOException, NoSuchAlgorithmException, CertificateException {
        File keystoreFile = this.getAndValidateFile(pFile, "keystore");
        try (FileInputStream fis = new FileInputStream(keystoreFile);){
            pKeyStore.load(fis, pPassword);
        }
        return keystoreFile;
    }

    public void clearWatchedFiles() {
        this.filesToWatch.clear();
    }

    public List<File> getWatchedFiles() {
        return this.filesToWatch;
    }

    private class LazyInitializedJolokiaHttpHandler
    implements HttpHandler {
        private volatile HttpHandler realHandler;

        private LazyInitializedJolokiaHttpHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange pHttpExchange) throws IOException {
            if (this.realHandler == null) {
                LazyInitializedJolokiaHttpHandler lazyInitializedJolokiaHttpHandler = this;
                synchronized (lazyInitializedJolokiaHttpHandler) {
                    if (this.realHandler == null) {
                        this.realHandler = JolokiaServer.this.startupJolokiaContext();
                    }
                }
            }
            this.realHandler.handle(pHttpExchange);
        }
    }
}

