/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.pull;

import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import org.jolokia.server.core.service.notification.NotificationResult;
import org.jolokia.server.core.service.notification.NotificationSubscription;
import org.jolokia.service.notif.pull.NotificationStore;

public class ClientStore {
    private final Map<String, NotificationStore> store;
    private final int maxEntries;

    ClientStore(int pMaxEntries) {
        this.maxEntries = pMaxEntries;
        this.store = new HashMap<String, NotificationStore>();
    }

    void add(NotificationSubscription pSubscription, Notification pNotification) {
        NotificationStore notifStore = this.store.get(pSubscription.getHandle());
        if (notifStore == null) {
            notifStore = new NotificationStore(pSubscription, this.maxEntries);
            this.store.put(pSubscription.getHandle(), notifStore);
        }
        notifStore.add(pNotification);
    }

    NotificationResult pull(String pHandle) {
        NotificationStore notificationStore = this.store.get(pHandle);
        if (notificationStore != null) {
            return notificationStore.fetchAndClear();
        }
        return null;
    }

    void removeSubscription(String pHandle) {
        this.store.remove(pHandle);
    }
}

