/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jsr160;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.request.AbstractRequestHandler;
import org.jolokia.server.core.util.jmx.SingleMBeanServerAccess;
import org.jolokia.service.jmx.api.CommandHandler;
import org.jolokia.service.jmx.api.CommandHandlerManager;
import org.jolokia.service.jsr160.ProxyTargetConfig;

public class Jsr160RequestHandler
extends AbstractRequestHandler {
    private CommandHandlerManager commandHandlerManager;
    private Set<String> whiteList;
    private Set<String> blackList;
    public static final String ALLOWED_TARGETS_SYSPROP = "jolokia.jsr160ProxyAllowedTargets";
    public static final String ALLOWED_TARGETS_ENV = "JOLOKIA_JSR160_PROXY_ALLOWED_TARGETS";

    public Jsr160RequestHandler(int pOrder) {
        super("proxy", pOrder);
    }

    @Override
    public void init(JolokiaContext pContext) {
        this.commandHandlerManager = new CommandHandlerManager(pContext, this.getProvider());
        this.whiteList = this.extractWhiteList(pContext);
        this.blackList = this.extractBlackList(pContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends JolokiaRequest> Object handleRequest(R pJmxReq, Object pPreviousResult) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException, EmptyResponseException {
        CommandHandler<R> handler = this.commandHandlerManager.getCommandHandler(pJmxReq.getType());
        JMXConnector connector = null;
        try {
            connector = this.createConnector(pJmxReq);
            connector.connect();
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            if (handler.handleAllServersAtOnce(pJmxReq)) {
                SingleMBeanServerAccess manager = new SingleMBeanServerAccess(connection);
                Object object = handler.handleAllServerRequest(manager, pJmxReq, pPreviousResult);
                return object;
            }
            Object object = handler.handleSingleServerRequest(connection, pJmxReq);
            return object;
        }
        finally {
            this.releaseConnector(connector);
        }
    }

    private JMXConnector createConnector(JolokiaRequest pJmxReq) throws IOException {
        ProxyTargetConfig targetConfig = new ProxyTargetConfig((Map)pJmxReq.getOption("target"));
        String urlS = targetConfig.getUrl();
        if (!this.acceptTargetUrl(urlS)) {
            throw new SecurityException(String.format("Target URL %s is not allowed by configuration", urlS));
        }
        JMXServiceURL url = new JMXServiceURL(urlS);
        Map<String, Object> env = this.prepareEnv(targetConfig.getEnv());
        return JMXConnectorFactory.newJMXConnector(url, env);
    }

    private void releaseConnector(JMXConnector pConnector) throws IOException {
        if (pConnector != null) {
            pConnector.close();
        }
    }

    protected Map<String, Object> prepareEnv(Map<String, String> pTargetConfig) {
        if (pTargetConfig == null || pTargetConfig.isEmpty()) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(pTargetConfig);
        String user = (String)ret.remove("user");
        String password = (String)ret.remove("password");
        if (user != null && password != null) {
            ret.put("java.naming.security.principal", user);
            ret.put("java.naming.security.credentials", password);
            ret.put("jmx.remote.credentials", new String[]{user, password});
        }
        if (System.getProperties().containsKey("javax.net.ssl.trustStore")) {
            ret.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
        }
        return ret;
    }

    @Override
    public boolean canHandle(JolokiaRequest pJolokiaRequest) {
        return pJolokiaRequest.getOption("target") != null;
    }

    @Override
    public String getProvider() {
        return "proxy";
    }

    @Override
    public void destroy() throws JMException {
        this.commandHandlerManager.destroy();
    }

    private boolean acceptTargetUrl(String urlS) {
        if (this.whiteList != null) {
            return this.checkPattern(this.whiteList, urlS, true);
        }
        if (this.blackList != null) {
            return this.checkPattern(this.blackList, urlS, false);
        }
        return true;
    }

    private boolean checkPattern(Set<String> patterns, String urlS, boolean isPositive) {
        for (String pattern : patterns) {
            if (!Pattern.compile(pattern, 2).matcher(urlS).matches()) continue;
            return isPositive;
        }
        return !isPositive;
    }

    private Set<String> extractWhiteList(JolokiaContext pContext) {
        return this.extractFrom(pContext != null ? pContext.getConfig(ConfigKey.JSR160_PROXY_ALLOWED_TARGETS) : null, System.getProperty(ALLOWED_TARGETS_SYSPROP), System.getenv(ALLOWED_TARGETS_ENV));
    }

    private Set<String> extractFrom(String ... paths) {
        HashSet<String> ret = new HashSet<String>();
        for (String path : paths) {
            if (path == null) continue;
            ret.addAll(this.readPatterns(path));
        }
        return !ret.isEmpty() ? ret : null;
    }

    private List<? extends String> readPatterns(String pPath) {
        ArrayList<String> arrayList;
        ArrayList<String> ret = new ArrayList<String>();
        Pattern commentPattern = Pattern.compile("^\\s*#.*$");
        BufferedReader reader = new BufferedReader(new FileReader(pPath));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!commentPattern.matcher(line).matches()) {
                    ret.add(line);
                }
                line = reader.readLine();
            }
            arrayList = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("No such pattern file %s", pPath));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error while reading pattern file %s: %s", pPath, e.getMessage()));
            }
        }
        reader.close();
        return arrayList;
    }

    private Set<String> extractBlackList(JolokiaContext pContext) {
        return Collections.singleton("service:jmx:rmi:///jndi/ldap:.*");
    }
}

