/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpsExchange;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.x500.X500Principal;
import org.jolokia.jvmagent.JolokiaServerConfig;

public class ClientCertAuthenticator
extends Authenticator {
    static final String CLIENTAUTH_OID = "1.3.6.1.5.5.7.3.2";
    private final boolean useSslClientAuthentication;
    private final List<LdapName> allowedPrincipals;
    private final boolean extendedClientCheck;

    public ClientCertAuthenticator(JolokiaServerConfig pConfig) {
        this.useSslClientAuthentication = pConfig.useSslClientAuthentication();
        this.allowedPrincipals = this.parseAllowedPrincipals(pConfig);
        this.extendedClientCheck = pConfig.getExtendedClientCheck();
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        if (!(httpExchange instanceof HttpsExchange)) {
            return new Authenticator.Failure(500);
        }
        try {
            HttpsExchange httpsExchange = (HttpsExchange)httpExchange;
            X509Certificate certificate = this.getClientCert(httpsExchange);
            if (certificate == null) {
                return new Authenticator.Failure(401);
            }
            this.checkCertForClientUsage(certificate);
            this.checkCertForAllowedPrincipals(httpsExchange);
            String name = "";
            try {
                name = httpsExchange.getSSLSession().getPeerPrincipal().getName();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            return new Authenticator.Success(new HttpPrincipal(name, "ssl"));
        }
        catch (SecurityException e) {
            return new Authenticator.Failure(403);
        }
    }

    private X509Certificate getClientCert(HttpsExchange pHttpsExchange) {
        try {
            Certificate[] peerCerts = pHttpsExchange.getSSLSession().getPeerCertificates();
            return peerCerts != null && peerCerts.length > 0 ? (X509Certificate)peerCerts[0] : null;
        }
        catch (SSLPeerUnverifiedException e) {
            throw new SecurityException("SSL Peer couldn't be verified");
        }
    }

    private void checkCertForClientUsage(X509Certificate clientCert) {
        try {
            if (this.extendedClientCheck && (clientCert.getExtendedKeyUsage() == null || !clientCert.getExtendedKeyUsage().contains(CLIENTAUTH_OID))) {
                throw new SecurityException("No extended key usage available");
            }
        }
        catch (CertificateParsingException e) {
            throw new SecurityException("Can't parse client cert");
        }
    }

    private void checkCertForAllowedPrincipals(HttpsExchange pHttpsExchange) {
        if (this.allowedPrincipals != null) {
            try {
                X500Principal certPrincipal = (X500Principal)pHttpsExchange.getSSLSession().getPeerPrincipal();
                Set<Rdn> certPrincipalRdns = this.getPrincipalRdns(certPrincipal);
                boolean matchFound = false;
                for (LdapName principal : this.allowedPrincipals) {
                    if (!certPrincipalRdns.containsAll(principal.getRdns())) continue;
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    throw new SecurityException("Principal " + String.valueOf(certPrincipal) + " not allowed");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                throw new SecurityException("SSLPeer unverified");
            }
            catch (ClassCastException e) {
                throw new SecurityException("Internal: Invalid Principal class provided " + String.valueOf(e));
            }
        }
    }

    private Set<Rdn> getPrincipalRdns(X500Principal principal) {
        try {
            LdapName certAsLdapName = new LdapName(principal.getName());
            return new HashSet<Rdn>(certAsLdapName.getRdns());
        }
        catch (InvalidNameException e) {
            throw new SecurityException("Cannot parse '" + String.valueOf(principal) + "' as LDAP name");
        }
    }

    private List<LdapName> parseAllowedPrincipals(JolokiaServerConfig pConfig) {
        List<String> principals = pConfig.getClientPrincipals();
        if (principals != null) {
            ArrayList<LdapName> ret = new ArrayList<LdapName>();
            for (String principal : principals) {
                try {
                    ret.add(new LdapName(principal));
                }
                catch (InvalidNameException e) {
                    throw new IllegalArgumentException("Principal '" + principal + "' cannot be parsed as X500 RDNs");
                }
            }
            return ret;
        }
        return null;
    }
}

