/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import org.jolokia.jvmagent.client.command.AbstractBaseCommand;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

public class StartCommand
extends AbstractBaseCommand {
    @Override
    String getName() {
        return "start";
    }

    @Override
    int execute(OptionsAndArgs pOpts, Object pVm, VirtualMachineHandlerOperations pHandler) {
        boolean quiet = pOpts.isQuiet();
        int interval = 200;
        int timeout = pOpts.getStartTimeout();
        String agentUrl = this.checkAgentUrl(pVm, pHandler);
        if (agentUrl != null) {
            if (!quiet) {
                System.out.println("Jolokia is already attached to " + this.getProcessDescription(pHandler, pOpts));
                System.out.println(agentUrl);
            }
            return 1;
        }
        this.loadAgent(pVm, pHandler, pOpts, new String[0]);
        int count = 0;
        while (count * interval < timeout) {
            try {
                Thread.sleep(interval);
                ++count;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            agentUrl = this.checkAgentUrl(pVm, pHandler);
            if (agentUrl == null) continue;
            if (!quiet) {
                System.out.println("Started Jolokia for " + this.getProcessDescription(pHandler, pOpts));
                System.out.println(agentUrl);
            }
            return 0;
        }
        System.err.println("Couldn't start agent for " + this.getProcessDescription(pHandler, pOpts));
        System.err.println("Possible reason could be that port '" + pOpts.getPort() + "' is already occupied.");
        System.err.println("Please check the standard output of the target process for a detailed error message.");
        return 1;
    }
}

