/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.tools;

import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.joinfaces.tools.ScanResultHandler;

public class MyFacesAnnotationProviderHandler
extends ScanResultHandler {
    private static final String MYFACES_ANNOTATION_PROVIDER = "org.apache.myfaces.spi.AnnotationProvider";
    private static final List<String> MYFACES_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("javax.faces.bean.ManagedBean", "javax.faces.component.FacesComponent", "javax.faces.component.behavior.FacesBehavior", "javax.faces.convert.FacesConverter", "javax.faces.event.NamedEvent", "javax.faces.render.FacesRenderer", "javax.faces.render.FacesBehaviorRenderer", "javax.faces.validator.FacesValidator"));

    @Override
    public void handle(ScanResult scanResult, File classpathRoot) throws IOException {
        if (scanResult.getClassInfo(MYFACES_ANNOTATION_PROVIDER) == null) {
            return;
        }
        LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
        for (String myfacesAnnotation : MYFACES_ANNOTATIONS) {
            result.put(myfacesAnnotation, scanResult.getClassesWithAnnotation(myfacesAnnotation).getNames());
        }
        File resultFile = new File(classpathRoot, "META-INF/joinfaces/org.apache.myfaces.spi.AnnotationProvider.classes");
        this.writeClassMap(resultFile, result);
    }
}

