/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.gradle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.joinfaces.gradle.ClasspathScan;

public class ClasspathScanPlugin
implements Plugin<Project> {
    private Project project;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void apply(Project project) {
        this.project = project;
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(this::configureClasspathScan));
    }

    private void configureClasspathScan(SourceSet sourceSet) {
        String taskName = sourceSet.getTaskName("scanJoinfaces", "Classpath");
        TaskProvider scanTaskProvider = this.project.getTasks().register(taskName, ClasspathScan.class, scanTask -> {
            scanTask.getDestinationDir().set(this.project.getLayout().getBuildDirectory().dir("joinfaces/" + sourceSet.getName()));
            scanTask.getClasspath().from(new Object[]{() -> this.project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName())});
            scanTask.getClasspath().from(new Object[]{this.project.getTasks().named(sourceSet.getCompileJavaTaskName())});
        });
        this.project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> scanTaskProvider.configure(scanTask -> scanTask.getClasspath().from(new Object[]{this.project.getTasks().named(sourceSet.getCompileTaskName("groovy"))})));
        this.project.getPlugins().withType(ScalaBasePlugin.class, scalaBasePlugin -> scanTaskProvider.configure(scanTask -> scanTask.getClasspath().from(new Object[]{this.project.getTasks().named(sourceSet.getCompileTaskName("scala"))})));
        this.project.getPlugins().withId("kotlin", kotlinPlugin -> scanTaskProvider.configure(scanTask -> scanTask.getClasspath().from(new Object[]{this.project.getTasks().named(sourceSet.getCompileTaskName("kotlin"))})));
        this.project.getPlugins().withId("org.jetbrains.kotlin.jvm", kotlinPlugin -> scanTaskProvider.configure(scanTask -> scanTask.getClasspath().from(new Object[]{this.project.getTasks().named(sourceSet.getCompileTaskName("kotlin"))})));
        sourceSet.getOutput().dir(Collections.singletonMap("builtBy", scanTaskProvider), (Object)scanTaskProvider.flatMap(ClasspathScan::getDestinationDir));
    }
}

