/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.adminfaces;

import com.github.adminfaces.template.exception.AccessDeniedException;
import com.github.adminfaces.template.session.AdminSession;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ejb.AccessLocalException;
import jakarta.faces.application.ViewExpiredException;
import jakarta.persistence.OptimisticLockException;
import lombok.Generated;
import org.joinfaces.autoconfigure.adminfaces.AdminfacesConfigSupport;
import org.joinfaces.autoconfigure.adminfaces.AdminfacesProperties;
import org.joinfaces.autoconfigure.adminfaces.SpringSecurityAdminSession;
import org.joinfaces.autoconfigure.primefaces.Primefaces4_0Properties;
import org.joinfaces.autoconfigure.primefaces.Primefaces5_2Properties;
import org.joinfaces.autoconfigure.primefaces.PrimefacesAutoConfiguration;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameterProperties;
import org.joinfaces.servlet.WebFragmentRegistrationBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AdminfacesProperties.class})
@ComponentScan(value={"com.github.adminfaces.template.bean", "com.github.adminfaces.template.config", "com.github.adminfaces.template.security"})
@ServletComponentScan(value={"com.github.adminfaces.template.security", "com.github.adminfaces.template.session"})
@ConditionalOnClass(value={AdminSession.class})
@AutoConfigureBefore(value={PrimefacesAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class AdminfacesAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminfacesAutoConfiguration.class);

    @Bean
    public static BeanPostProcessor adminfacesPrimeFacesPropertiesPostProcessor() {
        return new PrimeFacesPropertiesPostProcessor();
    }

    @Autowired
    public void mapConfigProperties(AdminfacesProperties adminfacesProperties) {
        AdminfacesConfigSupport.mapProperties(adminfacesProperties);
    }

    @Bean(value={"adminSession"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public SpringSecurityAdminSession springSecurityAdminSession() {
        return new SpringSecurityAdminSession();
    }

    @Bean(value={"adminSession"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AdminSession adminSession() {
        return new AdminSession();
    }

    @Bean
    public WebFragmentRegistrationBean adminTemplateWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getContextParams().put("primefaces.THEME", "admin");
        bean.getErrorPages().add(new ErrorPage(HttpStatus.FORBIDDEN, "/403.xhtml"));
        bean.getErrorPages().add(new ErrorPage(AccessDeniedException.class, "/403.xhtml"));
        try {
            bean.getErrorPages().add(new ErrorPage(AccessLocalException.class, "/403.xhtml"));
        }
        catch (NoClassDefFoundError e) {
            log.debug("EJB-Api not available", (Throwable)e);
        }
        bean.getErrorPages().add(new ErrorPage(HttpStatus.NOT_FOUND, "/404.xhtml"));
        bean.getErrorPages().add(new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500.xhtml"));
        bean.getErrorPages().add(new ErrorPage(Throwable.class, "/500.xhtml"));
        bean.getErrorPages().add(new ErrorPage(ViewExpiredException.class, "/expired.xhtml"));
        bean.getErrorPages().add(new ErrorPage(OptimisticLockException.class, "/optimistic.xhtml"));
        return bean;
    }

    @Bean
    public WebFragmentRegistrationBean adminThemeWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getContextParams().put("primefaces.FONT_AWESOME", "true");
        return bean;
    }

    static class PrimeFacesPropertiesPostProcessor
    implements BeanPostProcessor {
        PrimeFacesPropertiesPostProcessor() {
        }

        public Object postProcessBeforeInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
            ServletContextInitParameterProperties properties;
            if (bean instanceof Primefaces4_0Properties) {
                properties = (Primefaces4_0Properties)bean;
                log.warn("Changing primefaces theme from '{}' to 'admin'.", (Object)((Primefaces4_0Properties)properties).getTheme());
                ((Primefaces4_0Properties)properties).setTheme("admin");
            }
            if (bean instanceof Primefaces5_2Properties) {
                properties = (Primefaces5_2Properties)bean;
                log.warn("Changing primefaces fontAwesome from 'false' to 'true'.");
                ((Primefaces5_2Properties)properties).setFontAwesome(true);
            }
            return bean;
        }
    }
}

