/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.javaxfaces;

import jakarta.faces.annotation.ApplicationMap;
import jakarta.faces.annotation.FlowMap;
import jakarta.faces.annotation.HeaderMap;
import jakarta.faces.annotation.HeaderValuesMap;
import jakarta.faces.annotation.InitParameterMap;
import jakarta.faces.annotation.RequestCookieMap;
import jakarta.faces.annotation.RequestMap;
import jakarta.faces.annotation.RequestParameterMap;
import jakarta.faces.annotation.RequestParameterValuesMap;
import jakarta.faces.annotation.SessionMap;
import jakarta.faces.annotation.ViewMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.joinfaces.autoconfigure.javaxfaces.JsfBeansAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JsfBeansAnnotationPostProcessor
implements BeanPostProcessor {
    private final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, Function<JsfBeansAutoConfiguration, ?>> mappers = new HashMap();
    private final BeanFactory beanFactory;

    public JsfBeansAnnotationPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.autowiredAnnotationTypes.add(Autowired.class);
        this.autowiredAnnotationTypes.add(Value.class);
        try {
            this.autowiredAnnotationTypes.add(ClassUtils.forName((String)"jakarta.inject.Inject", (ClassLoader)JsfBeansAnnotationPostProcessor.class.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.mappers.put(ApplicationMap.class, JsfBeansAutoConfiguration::applicationMap);
        this.mappers.put(FlowMap.class, JsfBeansAutoConfiguration::flowScope);
        this.mappers.put(HeaderMap.class, JsfBeansAutoConfiguration::headerMap);
        this.mappers.put(HeaderValuesMap.class, JsfBeansAutoConfiguration::headerValuesMap);
        this.mappers.put(InitParameterMap.class, JsfBeansAutoConfiguration::initParameterMap);
        this.mappers.put(RequestCookieMap.class, JsfBeansAutoConfiguration::requestCookieMap);
        this.mappers.put(RequestMap.class, JsfBeansAutoConfiguration::requestMap);
        this.mappers.put(RequestParameterMap.class, JsfBeansAutoConfiguration::requestParameterMap);
        this.mappers.put(RequestParameterValuesMap.class, JsfBeansAutoConfiguration::requestParameterValuesMap);
        this.mappers.put(SessionMap.class, JsfBeansAutoConfiguration::sessionMap);
        this.mappers.put(ViewMap.class, JsfBeansAutoConfiguration::viewMap);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> this.mappers.forEach((annotation, mapper) -> {
            if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, (Class)annotation)) {
                ReflectionUtils.makeAccessible((Field)field);
                JsfBeansAutoConfiguration jsfBeanConfiguration = (JsfBeansAutoConfiguration)this.beanFactory.getBean(JsfBeansAutoConfiguration.class);
                ReflectionUtils.setField((Field)field, (Object)bean, mapper.apply(jsfBeanConfiguration));
            }
        }), this::isAutowiredField);
        return bean;
    }

    boolean isAutowiredField(Field field) {
        for (Class<? extends Annotation> autowiredAnnotationType : this.autowiredAnnotationTypes) {
            if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, autowiredAnnotationType)) continue;
            return true;
        }
        return false;
    }
}

