/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.viewscope;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.ViewMapListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.request.FacesRequestAttributes;

public class ViewScope
implements Scope {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewScope.class);
    public static final String SCOPE_VIEW = "view";
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = ViewScope.class.getName() + ".DESTRUCTION_CALLBACK.";
    private PreDestroyViewMapListener preDestroyViewMapListener = new PreDestroyViewMapListener();

    public Object get(String name, ObjectFactory objectFactory) {
        Map viewMap = this.getViewRoot().getViewMap();
        Object bean = viewMap.get(name);
        if (bean == null) {
            bean = objectFactory.getObject();
            viewMap.put(name, bean);
        }
        return bean;
    }

    @Nullable
    public Object remove(String name) {
        UIViewRoot viewRoot = this.getViewRoot();
        Object bean = viewRoot.getViewMap().remove(name);
        DestructionCallbackWrapper destructionCallbackWrapper = (DestructionCallbackWrapper)viewRoot.getViewMap().remove(DESTRUCTION_CALLBACK_NAME_PREFIX + name);
        if (destructionCallbackWrapper != null) {
            this.getSessionListener().unregister(destructionCallbackWrapper);
        }
        return bean;
    }

    @Nullable
    public String getConversationId() {
        this.getFacesContext();
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        DestructionCallbackWrapper wrapper = new DestructionCallbackWrapper(name, callback);
        this.getFacesContext().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this.preDestroyViewMapListener);
        this.getViewRoot().getViewMap().put(DESTRUCTION_CALLBACK_NAME_PREFIX + name, wrapper);
        this.getSessionListener().register(wrapper);
    }

    @Nullable
    public Object resolveContextualObject(String key) {
        return new FacesRequestAttributes(this.getFacesContext()).resolveReference(key);
    }

    private UIViewRoot getViewRoot() {
        UIViewRoot viewRoot = this.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException("No ViewRoot found");
        }
        return viewRoot;
    }

    private FacesContext getFacesContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("No FacesContext found.");
        }
        return facesContext;
    }

    private SessionListener getSessionListener() {
        return (SessionListener)this.getFacesContext().getExternalContext().getSessionMap().computeIfAbsent(SessionListener.class.getName(), k -> new SessionListener());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    PreDestroyViewMapListener getPreDestroyViewMapListener() {
        return this.preDestroyViewMapListener;
    }

    static class DestructionCallbackWrapper {
        private final String beanName;
        @Nullable
        private Runnable callback;

        DestructionCallbackWrapper(String beanName, Runnable callback) {
            Assert.hasText((String)beanName, (String)"beanName must not be null or empty");
            Assert.notNull((Object)callback, (String)"callback must not be null");
            this.beanName = beanName;
            this.callback = callback;
        }

        void onViewDestroy() {
            this.doRunCallback(false);
        }

        void onSessionDestroy() {
            this.doRunCallback(true);
        }

        private synchronized void doRunCallback(boolean session) {
            if (this.callback != null) {
                log.debug("Calling destruction callbacks for bean {} because the {} is destroyed", (Object)this.getBeanName(), (Object)(session ? "session" : "view map"));
                this.callback.run();
                this.callback = null;
            }
        }

        boolean isCallbackCalled() {
            return this.callback == null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getBeanName() {
            return this.beanName;
        }
    }

    class PreDestroyViewMapListener
    implements ViewMapListener {
        PreDestroyViewMapListener() {
        }

        public void processEvent(SystemEvent event) {
            UIViewRoot root = (UIViewRoot)event.getSource();
            root.getViewMap(false).values().stream().filter(DestructionCallbackWrapper.class::isInstance).map(DestructionCallbackWrapper.class::cast).forEach(DestructionCallbackWrapper::onViewDestroy);
            ViewScope.this.getSessionListener().cleanup();
        }

        public boolean isListenerForSource(Object source) {
            return source instanceof UIViewRoot;
        }
    }

    static class SessionListener
    implements HttpSessionBindingListener {
        private List<DestructionCallbackWrapper> destructionCallbackWrappers = new LinkedList<DestructionCallbackWrapper>();

        SessionListener() {
        }

        void register(DestructionCallbackWrapper destructionCallbackWrapper) {
            this.cleanup();
            this.destructionCallbackWrappers.add(destructionCallbackWrapper);
        }

        void unregister(DestructionCallbackWrapper destructionCallbackWrapper) {
            this.cleanup();
            this.destructionCallbackWrappers.remove(destructionCallbackWrapper);
        }

        synchronized void cleanup() {
            this.destructionCallbackWrappers.removeIf(DestructionCallbackWrapper::isCallbackCalled);
        }

        public void valueBound(@Nullable HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(@Nullable HttpSessionBindingEvent httpSessionBindingEvent) {
            this.destructionCallbackWrappers.forEach(DestructionCallbackWrapper::onSessionDestroy);
            this.cleanup();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<DestructionCallbackWrapper> getDestructionCallbackWrappers() {
            return this.destructionCallbackWrappers;
        }
    }
}

