/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ClasspathScanUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClasspathScanUtil.class);

    public static Optional<Set<Class<?>>> readClassSet(String resourceName, ClassLoader classLoader) {
        return ClasspathScanUtil.readClasses(resourceName, classLoader, ClasspathScanUtil::readClassSet);
    }

    public static Optional<Map<Class<? extends Annotation>, Set<Class<?>>>> readClassMap(String resourceName, ClassLoader classLoader) {
        return ClasspathScanUtil.readClasses(resourceName, classLoader, ClasspathScanUtil::readClassMap);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="https://github.com/spotbugs/spotbugs/issues/259")
    private static <T> Optional<T> readClasses(String resourceName, ClassLoader classLoader, BiFunction<BufferedReader, ClassLoader, T> function) {
        Optional<T> optional;
        InputStream resourceAsStream = classLoader.getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            log.debug("No prepared scan result {} found.", (Object)resourceName);
            return Optional.empty();
        }
        long start = System.nanoTime();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
        try {
            T result = function.apply(bufferedReader, classLoader);
            double ms = (double)(System.nanoTime() - start) / 1000000.0;
            log.info("Loading prepared scan result took {}ms", (Object)ms);
            optional = Optional.ofNullable(result);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Failed to read prepared scan-result {}", (Object)resourceName, (Object)e);
                return Optional.empty();
            }
        }
        bufferedReader.close();
        return optional;
    }

    static Set<Class<?>> readClassSet(BufferedReader bufferedReader, ClassLoader classLoader) {
        return ClasspathScanUtil.getClasses(bufferedReader.lines(), classLoader);
    }

    static Map<Class<? extends Annotation>, Set<Class<?>>> readClassMap(BufferedReader bufferedReader, ClassLoader classLoader) {
        HashMap classes = new HashMap();
        bufferedReader.lines().forEach(line -> {
            Class<?> annotation;
            String[] split = line.split("=", 2);
            String annotationName = split[0];
            String classNameList = split[1];
            try {
                annotation = classLoader.loadClass(annotationName);
            }
            catch (ClassNotFoundException | LinkageError e) {
                log.warn("Failed to load annotation class {}", (Object)annotationName, (Object)e);
                return;
            }
            Set<Object> classSet = StringUtils.hasText((String)classNameList) ? ClasspathScanUtil.getClasses(Arrays.stream(classNameList.split(",")), classLoader) : Collections.emptySet();
            classes.put(annotation, classSet);
        });
        return classes;
    }

    static Set<Class<?>> getClasses(Stream<String> classNames, ClassLoader classLoader) {
        AtomicInteger missingClasses = new AtomicInteger();
        AtomicInteger missingDependentClasses = new AtomicInteger();
        Set<Class<?>> collect = classNames.map(className -> {
            try {
                return classLoader.loadClass((String)className);
            }
            catch (ClassNotFoundException e) {
                missingClasses.incrementAndGet();
                log.debug("Failed to load class {} although it's listed in the prepared scan result.", className);
                log.trace("Stacktrace", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                missingDependentClasses.incrementAndGet();
                log.debug("Failed to load class {} because it's dependency {} is missing.", className, (Object)e.getMessage());
                log.trace("Stacktrace", (Throwable)e);
            }
            catch (LinkageError e) {
                log.warn("Failed to load class {} from prepared scan result", className, (Object)e);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (missingClasses.get() > 0) {
            log.warn("{} classes listed in the prepared scan result could not be found. Set the log-level to debug for more information.", (Object)missingClasses.get());
        }
        if (missingDependentClasses.get() > 0) {
            log.info("{} classes failed to load, because some of their dependencies are missing. Set the log-level to debug for more information.", (Object)missingDependentClasses.get());
        }
        return collect;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ClasspathScanUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

