/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempFileCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class TempJarCache {
    private static final boolean DEBUG = Debug.debug("TempJarCache");
    private static Map<String, String> nativeLibMap;
    private static Map<URI, LoadState> nativeLibJars;
    private static Map<URI, LoadState> classFileJars;
    private static Map<URI, LoadState> resourceFileJars;
    private static TempFileCache tmpFileCache;
    private static boolean staticInitError;
    private static volatile boolean isInit;

    private static boolean testLoadState(LoadState loadState, LoadState loadState2) {
        if (null == loadState) {
            return null == loadState2;
        }
        return loadState.compliesWith(loadState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean initSingleton() {
        if (!isInit) {
            Class<TempJarCache> clazz = TempJarCache.class;
            // MONITORENTER : com.jogamp.common.util.cache.TempJarCache.class
            if (!isInit) {
                isInit = true;
                boolean bl = staticInitError = !TempFileCache.initSingleton();
                if (!staticInitError) {
                    tmpFileCache = new TempFileCache();
                    boolean bl2 = staticInitError = !tmpFileCache.isValid();
                }
                if (!staticInitError) {
                    nativeLibMap = new HashMap<String, String>();
                    nativeLibJars = new HashMap<URI, LoadState>();
                    classFileJars = new HashMap<URI, LoadState>();
                    resourceFileJars = new HashMap<URI, LoadState>();
                }
                if (DEBUG) {
                    System.err.println("TempJarCache.initSingleton(): ok " + (false == staticInitError) + ", " + tmpFileCache.getTempDir());
                }
            }
            // MONITOREXIT : clazz
        }
        if (staticInitError) return false;
        return true;
    }

    public static boolean isInitialized() {
        return isInit && !staticInitError;
    }

    static void checkInitialized() {
        if (!isInit) {
            throw new RuntimeException("initSingleton() has to be called first.");
        }
    }

    public static TempFileCache getTempFileCache() {
        TempJarCache.checkInitialized();
        return tmpFileCache;
    }

    public static synchronized boolean checkNativeLibs(URI uRI, LoadState loadState) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRI) {
            throw new IllegalArgumentException("jarURI is null");
        }
        return TempJarCache.testLoadState(nativeLibJars.get(uRI), loadState);
    }

    public static synchronized boolean checkClasses(URI uRI, LoadState loadState) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRI) {
            throw new IllegalArgumentException("jarURI is null");
        }
        return TempJarCache.testLoadState(classFileJars.get(uRI), loadState);
    }

    public static synchronized boolean checkResources(URI uRI, LoadState loadState) throws IOException {
        TempJarCache.checkInitialized();
        if (null == uRI) {
            throw new IllegalArgumentException("jarURI is null");
        }
        return TempJarCache.testLoadState(resourceFileJars.get(uRI), loadState);
    }

    public static final synchronized void addNativeLibs(Class<?> clazz, URI uRI) throws IOException, SecurityException, IllegalArgumentException, URISyntaxException {
        LoadState loadState = nativeLibJars.get(uRI);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            nativeLibJars.put(uRI, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uRI);
            if (DEBUG) {
                System.err.println("TempJarCache: addNativeLibs: " + uRI + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, true, false, false);
            nativeLibJars.put(uRI, LoadState.LOADED);
        } else if (!TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            throw new IOException("TempJarCache: addNativeLibs: " + uRI + ", previous load attempt failed");
        }
    }

    public static final synchronized void addClasses(Class<?> clazz, URI uRI) throws IOException, SecurityException, IllegalArgumentException, URISyntaxException {
        LoadState loadState = classFileJars.get(uRI);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            classFileJars.put(uRI, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uRI);
            if (DEBUG) {
                System.err.println("TempJarCache: addClasses: " + uRI + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, false, true, false);
            classFileJars.put(uRI, LoadState.LOADED);
        } else if (!TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            throw new IOException("TempJarCache: addClasses: " + uRI + ", previous load attempt failed");
        }
    }

    public static final synchronized void addResources(Class<?> clazz, URI uRI) throws IOException, SecurityException, IllegalArgumentException, URISyntaxException {
        LoadState loadState = resourceFileJars.get(uRI);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            resourceFileJars.put(uRI, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uRI);
            if (DEBUG) {
                System.err.println("TempJarCache: addResources: " + uRI + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, false, false, true);
            resourceFileJars.put(uRI, LoadState.LOADED);
        } else if (!TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            throw new IOException("TempJarCache: addResources: " + uRI + ", previous load attempt failed");
        }
    }

    public static final synchronized void addAll(Class<?> clazz, URI uRI) throws IOException, SecurityException, IllegalArgumentException, URISyntaxException {
        TempJarCache.checkInitialized();
        if (null == uRI) {
            throw new IllegalArgumentException("jarURI is null");
        }
        LoadState loadState = nativeLibJars.get(uRI);
        LoadState loadState2 = classFileJars.get(uRI);
        LoadState loadState3 = resourceFileJars.get(uRI);
        if (!(TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP) && TempJarCache.testLoadState(loadState2, LoadState.LOOKED_UP) && TempJarCache.testLoadState(loadState3, LoadState.LOOKED_UP))) {
            boolean bl;
            boolean bl2 = !TempJarCache.testLoadState(loadState, LoadState.LOADED);
            boolean bl3 = !TempJarCache.testLoadState(loadState2, LoadState.LOADED);
            boolean bl4 = bl = !TempJarCache.testLoadState(loadState3, LoadState.LOOKED_UP);
            if (bl2) {
                nativeLibJars.put(uRI, LoadState.LOOKED_UP);
            }
            if (bl3) {
                classFileJars.put(uRI, LoadState.LOOKED_UP);
            }
            if (bl) {
                resourceFileJars.put(uRI, LoadState.LOOKED_UP);
            }
            JarFile jarFile = JarUtil.getJarFile(uRI);
            if (DEBUG) {
                System.err.println("TempJarCache: addAll: " + uRI + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, bl2, bl3, bl);
            if (bl2) {
                nativeLibJars.put(uRI, LoadState.LOADED);
            }
            if (bl3) {
                classFileJars.put(uRI, LoadState.LOADED);
            }
            if (bl) {
                resourceFileJars.put(uRI, LoadState.LOADED);
            }
        } else if (!(TempJarCache.testLoadState(loadState, LoadState.LOADED) && TempJarCache.testLoadState(loadState2, LoadState.LOADED) && TempJarCache.testLoadState(loadState3, LoadState.LOADED))) {
            throw new IOException("TempJarCache: addAll: " + uRI + ", previous load attempt failed");
        }
    }

    public static final synchronized String findLibrary(String string) {
        File file;
        TempJarCache.checkInitialized();
        String string2 = nativeLibMap.get(string);
        if (null == string2 && null != NativeLibrary.isValidNativeLibraryName(string, false) && (file = new File(tmpFileCache.getTempDir(), string)).exists()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public static final synchronized String findResource(String string) {
        TempJarCache.checkInitialized();
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static final synchronized URI getResource(String string) throws URISyntaxException {
        TempJarCache.checkInitialized();
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return IOUtil.toURISimple(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void bootstrapNativeLib(Class<?> clazz, String string, URI uRI) throws IOException, SecurityException, IllegalArgumentException, URISyntaxException {
        TempJarCache.checkInitialized();
        boolean bl = false;
        int n = 0;
        LoadState loadState = nativeLibJars.get(uRI);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP) && !nativeLibMap.containsKey(string)) {
            if (DEBUG) {
                System.err.println("TempJarCache: bootstrapNativeLib(certClass: " + clazz + ", libBaseName " + string + ", jarURI " + uRI + ")");
            }
            nativeLibJars.put(uRI, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uRI);
            if (DEBUG) {
                System.err.println("TempJarCache: bootstrapNativeLib: nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (string2.indexOf(47) != -1 || string2.indexOf(File.separatorChar) != -1 || string2.indexOf(string) < 0) continue;
                File file = new File(tmpFileCache.getTempDir(), string2);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n2 = 0;
                try {
                    int n3;
                    byte[] byArray = new byte[2048];
                    while ((n3 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n3);
                        n2 += n3;
                    }
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                    ((OutputStream)bufferedOutputStream).close();
                }
                if (n2 <= 0) continue;
                nativeLibMap.put(string, file.getAbsolutePath());
                nativeLibJars.put(uRI, LoadState.LOADED);
                bl = true;
                ++n;
            }
        } else if (TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            bl = true;
        } else {
            throw new IOException("TempJarCache: bootstrapNativeLib: " + uRI + ", previous load attempt failed");
        }
        if (DEBUG) {
            System.err.println("TempJarCache: bootstrapNativeLib() done, count " + n + ", ok " + bl);
        }
    }

    private static void validateCertificates(Class<?> clazz, JarFile jarFile) throws IOException, SecurityException {
        if (null == clazz) {
            throw new IllegalArgumentException("certClass is null");
        }
        Certificate[] certificateArray = SecurityUtil.getCerts(clazz);
        if (null != certificateArray) {
            JarUtil.validateCertificates(certificateArray, jarFile);
            if (DEBUG) {
                System.err.println("TempJarCache: validateCertificates: OK - Matching rootCerts in given class " + clazz.getName() + ", nativeJar " + jarFile.getName());
            }
        } else if (DEBUG) {
            System.err.println("TempJarCache: validateCertificates: OK - No rootCerts in given class " + clazz.getName() + ", nativeJar " + jarFile.getName());
        }
    }

    static {
        staticInitError = false;
        isInit = false;
    }

    public static enum LoadState {
        LOOKED_UP,
        LOADED;


        public boolean compliesWith(LoadState loadState) {
            return null != loadState ? this.compareTo(loadState) >= 0 : false;
        }
    }
}

