/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    private static final HashSet<String> loaded;
    private static LoaderAction loaderAction;
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    static final boolean addNativeJarLibsImpl(Class<?> clazz, URI uRI, String string, StringBuilder stringBuilder) throws IOException, SecurityException, URISyntaxException {
        stringBuilder.setLength(0);
        stringBuilder.append("addNativeJarLibsImpl(classFromJavaJar ").append(clazz).append(", classJarURI ").append(uRI).append(", nativeJarBaseName ").append(string).append("): ");
        boolean bl = false;
        if (TempJarCache.isInitialized()) {
            String string2 = string + "-natives-" + PlatformPropsImpl.os_and_arch + ".jar";
            stringBuilder.append(string2);
            URI uRI2 = IOUtil.getDirname(JarUtil.getJarSubURI(uRI));
            stringBuilder.append(" + ").append(uRI2);
            URI uRI3 = JarUtil.getJarFileURI(uRI2, string2);
            stringBuilder.append(" -> ").append(uRI3);
            if (DEBUG) {
                System.err.println(stringBuilder.toString());
            }
            TempJarCache.addNativeLibs(clazz, uRI3);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean addNativeJarLibs(Class<?> clazz, String string) {
        if (TempJarCache.isInitialized()) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                URI uRI = JarUtil.getJarURI(clazz.getName(), clazz.getClassLoader());
                return JNILibLoaderBase.addNativeJarLibsImpl(clazz, uRI, string, stringBuilder);
            }
            catch (Exception exception) {
                System.err.println("Catched " + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ", while " + stringBuilder.toString());
                if (!DEBUG) return false;
                exception.printStackTrace();
                return false;
            }
        } else {
            if (!DEBUG) return false;
            System.err.println("JNILibLoaderBase: addNativeJarLibs1: disabled due to uninitialized TempJarCache");
        }
        return false;
    }

    public static boolean addNativeJarLibs(Class<?>[] classArray, String string, String[] stringArray) {
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: addNativeJarLibs0(classesFromJavaJars " + Arrays.asList(classArray) + ", singleJarMarker " + string + ", stripBasenameSuffixes " + (null != stringArray ? Arrays.asList(stringArray) : "none"));
        }
        boolean bl = false;
        if (TempJarCache.isInitialized()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            try {
                boolean bl2 = false;
                bl = true;
                for (int i = 0; !bl2 && bl && i < classArray.length && null != classArray[i]; ++i) {
                    ClassLoader classLoader = classArray[i].getClassLoader();
                    URI uRI = JarUtil.getJarURI(classArray[i].getName(), classLoader);
                    String string2 = JarUtil.getJarBasename(uRI);
                    boolean bl3 = bl = null != string2;
                    if (!bl) continue;
                    String string3 = string2.substring(0, string2.indexOf(".jar"));
                    String string4 = JNILibLoaderBase.stripName(string3, stringArray);
                    bl2 = null != string && string3.indexOf(string) >= 0;
                    bl = JNILibLoaderBase.addNativeJarLibsImpl(classArray[i], uRI, string4, stringBuilder);
                    if (bl) {
                        ++n;
                    }
                    if (!DEBUG || !bl2) continue;
                    System.err.println("JNILibLoaderBase: addNativeJarLibs0: end after all-in-one JAR: " + string3);
                }
            }
            catch (Exception exception) {
                System.err.println("Catched " + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ", while " + stringBuilder.toString());
                if (DEBUG) {
                    exception.printStackTrace();
                }
                bl = false;
            }
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: addNativeJarLibs0(..) done, count " + n + ", ok " + bl);
            }
        } else if (DEBUG) {
            System.err.println("JNILibLoaderBase: addNativeJarLibs0: disabled due to uninitialized TempJarCache");
        }
        return bl;
    }

    private static final String stripName(String string, String[] stringArray) {
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length && null != stringArray[i]; ++i) {
                int n = string.indexOf(stringArray[i]);
                if (0 >= n) continue;
                return string.substring(0, n);
            }
        }
        return string;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl, classLoader);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl, classLoader);
        }
    }

    private static void loadLibraryInternal(String string, ClassLoader classLoader) {
        int n = 0;
        if (null != customLoadLibraryMethod && !string.equals("jawt")) {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: customLoad(" + string + ") - mode 1");
            }
            try {
                customLoadLibraryMethod.invoke(null, string);
                n = 1;
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + string).initCause(exception);
            }
        }
        String string2 = NativeLibrary.findLibrary(string, classLoader);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + "), TempJarCache: " + string2);
        }
        if (null != string2) {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: System.load(" + string2 + ") - mode 2");
            }
            System.load(string2);
            n = 2;
        } else {
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: System.loadLibrary(" + string + ") - mode 3");
            }
            try {
                System.loadLibrary(string);
                n = 3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (DEBUG) {
                    System.err.println("ERROR (retry w/ enumLibPath) - " + unsatisfiedLinkError.getMessage());
                }
                List<String> list = NativeLibrary.enumerateLibraryPaths(string, string, string, true, classLoader);
                Iterator<String> iterator = list.iterator();
                while (0 == n && iterator.hasNext()) {
                    String string3 = iterator.next();
                    if (DEBUG) {
                        System.err.println("JNILibLoaderBase: System.load(" + string3 + ") - mode 4");
                    }
                    try {
                        System.load(string3);
                        n = 4;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        if (DEBUG) {
                            System.err.println("n/a - " + unsatisfiedLinkError2.getMessage());
                        }
                        if (iterator.hasNext()) continue;
                        throw unsatisfiedLinkError2;
                    }
                }
            }
        }
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + "): OK - mode " + n);
        }
    }

    static {
        Method method;
        DEBUG = Debug.debug("JNILibLoader");
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        customLoadLibraryMethod = method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                String string;
                boolean bl = Debug.getBooleanProperty("sun.jnlp.applet.launcher", true);
                Class<?> clazz = null;
                Method method = null;
                if (bl) {
                    try {
                        clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("JNILibLoaderBase: <org.jdesktop.applet.util.JNLPAppletLauncher> not found, despite enabled property <sun.jnlp.applet.launcher>, JNLPAppletLauncher was probably used before");
                        System.setProperty("sun.jnlp.applet.launcher", Boolean.FALSE.toString());
                    }
                    catch (LinkageError linkageError) {
                        throw linkageError;
                    }
                    if (null != clazz) {
                        try {
                            method = clazz.getDeclaredMethod("loadLibrary", String.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (DEBUG) {
                                noSuchMethodException.printStackTrace();
                            }
                            clazz = null;
                        }
                    }
                }
                if (null == clazz && null != (string = PropertyAccess.getProperty("jnlp.launcher.class", false))) {
                    try {
                        clazz = Class.forName(string);
                        method = clazz.getDeclaredMethod("loadLibrary", String.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (DEBUG) {
                            classNotFoundException.printStackTrace();
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (DEBUG) {
                            noSuchMethodException.printStackTrace();
                        }
                        clazz = null;
                    }
                }
                return method;
            }
        });
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        @Override
        public boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(string, classLoader);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            System.err.println("JNILibLoaderBase: loaded " + string);
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        @Override
        public void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl, classLoader);
                    }
                }
                this.loadLibrary(string, false, classLoader);
            }
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2, ClassLoader var3);

        public void loadLibrary(String var1, String[] var2, boolean var3, ClassLoader var4);
    }
}

