/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.io.StreamUtil;
import jodd.servlet.filter.GzipResponseStream;

public class GzipResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse;
    protected ServletOutputStream stream;
    protected PrintWriter writer;
    protected int threshold;
    protected String contentType;

    public GzipResponseWrapper(HttpServletResponse response) {
        super(response);
        this.origResponse = response;
        response.setContentLength(-1);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.origResponse.setContentType(contentType);
    }

    public void setCompressionThreshold(int threshold) {
        this.threshold = threshold;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        GzipResponseStream gzstream = new GzipResponseStream(this.origResponse);
        gzstream.setBuffer(this.threshold);
        return gzstream;
    }

    public void finishResponse() {
        StreamUtil.close((Closeable)this.writer);
        StreamUtil.close((Closeable)this.stream);
    }

    public void flushBuffer() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        String charEnc = this.origResponse.getCharacterEncoding();
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setContentLength(int length) {
    }

    public void setContentLengthLong(long length) {
    }
}

