/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import jodd.util.RandomString;

public class CsrfShield {
    public static final String CSRF_TOKEN_NAME = "_csrf_token";
    public static final String CSRF_TOKEN_SET = "_csrf_token_set";
    protected static int timeToLive = 600;
    protected static int maxTokensPerSession = 20;

    public static void setTimeToLive(int periodInSeconds) {
        timeToLive = periodInSeconds;
    }

    public static void setMaxTokensPerSession(int maxTokensPerSession) {
        CsrfShield.maxTokensPerSession = maxTokensPerSession;
    }

    public static String prepareCsrfToken(PageContext pageContext) {
        return CsrfShield.prepareCsrfToken(pageContext.getSession());
    }

    public static String prepareCsrfToken(HttpSession session) {
        return CsrfShield.prepareCsrfToken(session, timeToLive);
    }

    public static String prepareCsrfToken(HttpSession session, int timeToLive) {
        String value;
        boolean unique;
        HashSet<Token> tokenSet = (HashSet<Token>)session.getAttribute(CSRF_TOKEN_SET);
        if (tokenSet == null) {
            tokenSet = new HashSet<Token>();
            session.setAttribute(CSRF_TOKEN_SET, tokenSet);
        }
        do {
            value = RandomString.getInstance().randomAlphaNumeric(32);
            CsrfShield.assureSize(tokenSet);
        } while (!(unique = tokenSet.add(new Token(value, timeToLive))));
        return value;
    }

    protected static void assureSize(Set<Token> tokenSet) {
        if (tokenSet.size() < maxTokensPerSession) {
            return;
        }
        long validUntilMin = Long.MAX_VALUE;
        Token tokenToRemove = null;
        Iterator<Token> iterator = tokenSet.iterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (token.isExpired()) {
                iterator.remove();
                continue;
            }
            if (token.validUntil >= validUntilMin) continue;
            validUntilMin = token.validUntil;
            tokenToRemove = token;
        }
        if (tokenToRemove != null && tokenSet.size() >= maxTokensPerSession) {
            tokenSet.remove(tokenToRemove);
        }
    }

    public static boolean checkCsrfToken(HttpServletRequest request) {
        return CsrfShield.checkCsrfToken(request, CSRF_TOKEN_NAME);
    }

    public static boolean checkCsrfToken(HttpServletRequest request, String tokenName) {
        String tokenValue = request.getParameter(tokenName);
        return CsrfShield.checkCsrfToken(request.getSession(), tokenValue);
    }

    public static boolean checkCsrfToken(HttpSession session, String tokenValue) {
        Set tokenSet = (Set)session.getAttribute(CSRF_TOKEN_SET);
        if (tokenSet == null && tokenValue == null) {
            return true;
        }
        if (tokenSet == null || tokenValue == null) {
            return false;
        }
        boolean found = false;
        Iterator it = tokenSet.iterator();
        while (it.hasNext()) {
            Token t = (Token)it.next();
            if (t.isExpired()) {
                it.remove();
                continue;
            }
            if (!t.getValue().equals(tokenValue)) continue;
            it.remove();
            found = true;
        }
        return found;
    }

    public static class Token
    implements Serializable {
        protected final String value;
        protected final long validUntil;

        public Token(String value) {
            this(value, 0L);
        }

        public Token(String value, long timeToLive) {
            this.value = value;
            this.validUntil = timeToLive <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeToLive * 1000L;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.validUntil;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            return this.value.equals(token.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

