/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.LinkedHashMap;
import java.util.Map;
import jodd.JoddHttp;
import jodd.http.Cookie;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;

public class HttpBrowser {
    protected HttpConnectionProvider httpConnectionProvider;
    protected HttpRequest httpRequest;
    protected HttpResponse httpResponse;
    protected Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    protected boolean keepAlive;

    public HttpBrowser() {
        this.httpConnectionProvider = JoddHttp.httpConnectionProvider;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setProxyInfo(ProxyInfo proxyInfo) {
        this.httpConnectionProvider.useProxy(proxyInfo);
    }

    public void setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getPage() {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.bodyText();
    }

    public HttpResponse sendRequest(HttpRequest httpRequest) {
        while (true) {
            String newPath;
            this.httpRequest = httpRequest;
            HttpResponse previouseResponse = this.httpResponse;
            this.httpResponse = null;
            this.addCookies(httpRequest);
            this.httpResponse = !this.keepAlive ? httpRequest.open(this.httpConnectionProvider).send() : (previouseResponse == null ? ((HttpRequest)httpRequest.open(this.httpConnectionProvider).connectionKeepAlive(true)).send() : httpRequest.keepAlive(previouseResponse, true).send());
            this.readCookies(this.httpResponse);
            int statusCode = this.httpResponse.statusCode();
            if (statusCode == 301) {
                newPath = this.httpResponse.header("location");
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode == 302 || statusCode == 303) {
                newPath = this.httpResponse.header("location");
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode != 307) break;
            newPath = this.httpResponse.header("location");
            String originalMethod = httpRequest.method();
            httpRequest = new HttpRequest().method(originalMethod).set(newPath);
        }
        return this.httpResponse;
    }

    public void close() {
        if (this.httpResponse != null) {
            this.httpResponse.close();
        }
    }

    protected void readCookies(HttpResponse httpResponse) {
        String[] newCookies = httpResponse.headers("set-cookie");
        if (newCookies != null) {
            for (String cookieValue : newCookies) {
                Cookie cookie = new Cookie(cookieValue);
                this.cookies.put(cookie.getName(), cookie);
            }
        }
    }

    protected void addCookies(HttpRequest httpRequest) {
        StringBuilder cookieString = new StringBuilder();
        boolean first = true;
        if (!this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies.values()) {
                if (!first) {
                    cookieString.append("; ");
                }
                first = false;
                cookieString.append(cookie.getName());
                cookieString.append('=');
                cookieString.append(cookie.getValue());
            }
            httpRequest.header("cookie", cookieString.toString(), true);
        }
    }
}

