/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;
import org.joda.collect.grid.ImmutableGrid;

final class SparseImmutableGrid<V>
extends ImmutableGrid<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int rowCount;
    private final int columnCount;
    private final long[] keys;
    private final Grid.Cell<V>[] cells;
    private transient ImmutableSet<Grid.Cell<V>> cellSet;
    private transient ImmutableCollection<V> valueCollection;

    SparseImmutableGrid(Grid<V> gridToCopy) {
        this.rowCount = gridToCopy.rowCount();
        this.columnCount = gridToCopy.columnCount();
        SparseImmutableGrid.validateCounts(this.rowCount, this.columnCount);
        int size = gridToCopy.cells().size();
        this.keys = new long[size];
        this.cells = new Grid.Cell[size];
        int i = 0;
        for (Grid.Cell<V> cell : gridToCopy.cells()) {
            this.keys[i] = this.key(cell.getRow(), cell.getColumn());
            this.cells[i] = ImmutableCell.copyOf(cell).validateCounts(this.rowCount, this.columnCount);
            ++i;
        }
    }

    private long key(int row, int column) {
        return ((long)row << 32) + (long)column;
    }

    SparseImmutableGrid(int rowCount, int columnCount, Iterable<? extends Grid.Cell<V>> cells) {
        ArrayList list;
        SparseImmutableGrid.validateCounts(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        if (cells instanceof Collection) {
            list = (ArrayList)cells;
        } else {
            list = new ArrayList();
            Iterables.addAll(list, cells);
        }
        int size = list.size();
        this.keys = new long[size];
        this.cells = new Grid.Cell[size];
        int i = 0;
        for (Grid.Cell cell : list) {
            this.keys[i] = this.key(cell.getRow(), cell.getColumn());
            this.cells[i] = ImmutableCell.copyOf(cell).validateCounts(rowCount, columnCount);
            ++i;
        }
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public int size() {
        return this.cells.length;
    }

    @Override
    public boolean contains(int row, int column) {
        if (this.exists(row, column)) {
            return Arrays.binarySearch(this.keys, this.key(row, column)) >= 0;
        }
        return false;
    }

    @Override
    public V get(int row, int column) {
        int index;
        if (this.exists(row, column) && (index = Arrays.binarySearch(this.keys, this.key(row, column))) >= 0) {
            return this.cells[index].getValue();
        }
        return null;
    }

    @Override
    public Grid.Cell<V> cell(int row, int column) {
        int index;
        if (this.exists(row, column) && (index = Arrays.binarySearch(this.keys, this.key(row, column))) >= 0) {
            return this.cells[index];
        }
        return null;
    }

    @Override
    public ImmutableSet<Grid.Cell<V>> cells() {
        ImmutableSet c = this.cellSet;
        if (c == null) {
            this.cellSet = c = ImmutableSet.copyOf((Object[])this.cells);
        }
        return c;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection v = this.valueCollection;
        if (v == null) {
            this.valueCollection = v = super.values();
        }
        return v;
    }
}

