/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.collect.ForwardingSortedSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.collect.grid.AbstractCell;
import org.joda.collect.grid.AbstractGrid;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;

public final class SparseGrid<V>
extends AbstractGrid<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int rowCount;
    private final int columnCount;
    private final SortedSet<Grid.Cell<V>> cells;

    public static <R> SparseGrid<R> create(int rowCount, int columnCount) {
        return new SparseGrid(rowCount, columnCount, new TreeSet(AbstractCell.comparator()));
    }

    public static <R> SparseGrid<R> create(Grid<? extends R> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("Grid must not be null");
        }
        SparseGrid<R> created = SparseGrid.create(grid.rowCount(), grid.columnCount());
        created.putAll(grid);
        return created;
    }

    SparseGrid(int rowCount, int columnCount, SortedSet<Grid.Cell<V>> data) {
        SparseGrid.validateCounts(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = data;
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public int size() {
        return this.cells.size();
    }

    @Override
    public Grid.Cell<V> cell(int row, int column) {
        Grid.Cell cell;
        SortedSet tail;
        if (this.exists(row, column) && (tail = this.cells.tailSet(this.finder(row, column))).size() > 0 && (cell = tail.first()).getRow() == row && cell.getColumn() == column) {
            return cell;
        }
        return null;
    }

    @Override
    public SortedSet<Grid.Cell<V>> cells() {
        return new ForwardingSortedSet<Grid.Cell<V>>(){

            protected SortedSet<Grid.Cell<V>> delegate() {
                return SparseGrid.this.cells;
            }

            public boolean add(Grid.Cell<V> element) {
                return super.add(ImmutableCell.copyOf(element));
            }

            public boolean addAll(Collection<? extends Grid.Cell<V>> collection) {
                return super.standardAddAll(collection);
            }
        };
    }

    @Override
    public void clear() {
        this.cells.clear();
    }

    @Override
    public void put(int row, int column, V value) {
        if (!this.exists(row, column)) {
            throw new IndexOutOfBoundsException("Invalid row-column: " + row + "," + column);
        }
        ImmutableCell<V> cell = ImmutableCell.of(row, column, value);
        this.cells.remove(cell);
        this.cells.add(cell);
    }

    @Override
    public void putAll(Grid<? extends V> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("Grid must nor be null");
        }
        for (Grid.Cell<V> cell : grid.cells()) {
            this.cells.add(ImmutableCell.copyOf(cell));
        }
    }

    @Override
    public boolean remove(int row, int column) {
        Iterator it;
        Grid.Cell cell;
        SortedSet tail;
        if (this.exists(row, column) && (tail = this.cells.tailSet(this.finder(row, column))).size() > 0 && (cell = (Grid.Cell)(it = tail.iterator()).next()).getRow() == row && cell.getColumn() == column) {
            it.remove();
            return true;
        }
        return false;
    }
}

