/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.collect.grid.AbstractGrid;
import org.joda.collect.grid.DenseImmutableGrid;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;
import org.joda.collect.grid.MutableCell;

public final class DenseGrid<V>
extends AbstractGrid<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int rowCount;
    private final int columnCount;
    private int size;
    private final V[] values;

    public static <V> DenseGrid<V> create(int rowCount, int columnCount) {
        return new DenseGrid<V>(rowCount, columnCount);
    }

    public static <V> DenseGrid<V> create(Grid<? extends V> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("Grid must not be null");
        }
        if (grid instanceof DenseImmutableGrid) {
            return new DenseGrid<V>((DenseImmutableGrid)grid);
        }
        DenseGrid<V> created = DenseGrid.create(grid.rowCount(), grid.columnCount());
        created.putAll(grid);
        return created;
    }

    public static <V> DenseGrid<V> create(V[][] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        int rowCount = array.length;
        if (rowCount == 0) {
            return new DenseGrid<V>(0, 0);
        }
        int columnCount = array[0].length;
        for (int i = 1; i < rowCount; ++i) {
            columnCount = Math.max(columnCount, array[i].length);
        }
        DenseGrid<V> created = DenseGrid.create(rowCount, columnCount);
        for (int row = 0; row < array.length; ++row) {
            V[] rowValues = array[row];
            for (int column = 0; column < rowValues.length; ++column) {
                V cellValue = rowValues[column];
                if (cellValue == null) continue;
                created.values[row * columnCount + column] = cellValue;
                ++created.size;
            }
        }
        return created;
    }

    private DenseGrid(int rowCount, int columnCount) {
        DenseGrid.validateCounts(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.values = new Object[rowCount * columnCount];
    }

    private DenseGrid(DenseImmutableGrid<V> grid) {
        this.rowCount = grid.rowCount();
        this.columnCount = grid.columnCount();
        this.size = grid.size();
        this.values = grid.valuesArray();
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(int row, int column) {
        if (this.exists(row, column)) {
            return this.values[row * this.columnCount + column] != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object valueToFind) {
        if (valueToFind != null) {
            for (V value : this.values) {
                if (!valueToFind.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(int row, int column) {
        if (this.exists(row, column)) {
            return this.values[row * this.columnCount + column];
        }
        return null;
    }

    @Override
    public Grid.Cell<V> cell(int row, int column) {
        V value = this.get(row, column);
        return value != null ? ImmutableCell.of(row, column, value) : null;
    }

    @Override
    public Set<Grid.Cell<V>> cells() {
        return new Cells(this);
    }

    @Override
    public ImmutableCollection<V> values() {
        Object[] array = new Object[this.size];
        int index = 0;
        for (V object : this.values) {
            if (object == null) continue;
            array[index++] = object;
        }
        return ImmutableList.copyOf((Object[])array);
    }

    @Override
    public List<V> row(int row) {
        Preconditions.checkElementIndex((int)row, (int)this.rowCount(), (String)"Row index");
        int base = row * this.rowCount;
        return new Inner(this, base, this.columnCount, 1);
    }

    @Override
    public List<List<V>> rows() {
        return new Outer(this, this.rowCount, this.columnCount, this.columnCount, 1);
    }

    @Override
    public List<V> column(int column) {
        Preconditions.checkElementIndex((int)column, (int)this.columnCount(), (String)"Column index");
        return new Inner(this, column, this.rowCount, this.columnCount);
    }

    @Override
    public List<List<V>> columns() {
        return new Outer(this, this.columnCount, 1, this.rowCount, this.columnCount);
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public void put(int row, int column, V value) {
        if (!this.exists(row, column)) {
            throw new IndexOutOfBoundsException("Invalid row-column: " + row + "," + column);
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        V current = this.values[row * this.columnCount + column];
        this.values[row * this.columnCount + column] = value;
        if (current == null) {
            ++this.size;
        }
    }

    @Override
    public void putAll(Grid<? extends V> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("Grid must nor be null");
        }
        for (Grid.Cell<V> cell : grid.cells()) {
            this.put(cell.getRow(), cell.getColumn(), cell.getValue());
        }
    }

    @Override
    public boolean remove(int row, int column) {
        V current = this.get(row, column);
        if (current != null) {
            this.values[row * this.columnCount + column] = null;
            --this.size;
            return true;
        }
        return false;
    }

    V[] valuesArray() {
        return (Object[])this.values.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DenseGrid) {
            DenseGrid other = (DenseGrid)obj;
            return Arrays.equals(this.values, other.values);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            int row = i / this.columnCount;
            int column = i % this.columnCount;
            hash += row ^ Integer.rotateLeft(column, 16) ^ value.hashCode();
        }
        return this.rowCount ^ Integer.rotateLeft(this.columnCount, 16) ^ hash;
    }

    static class Cells<V>
    extends AbstractSet<Grid.Cell<V>> {
        private final DenseGrid<V> grid;

        Cells(DenseGrid<V> grid) {
            this.grid = grid;
        }

        @Override
        public int size() {
            return this.grid.size;
        }

        @Override
        public boolean contains(Object obj) {
            Grid.Cell cell = (Grid.Cell)obj;
            return Objects.equal(cell.getValue(), this.grid.get(cell.getRow(), cell.getColumn()));
        }

        @Override
        public Iterator<Grid.Cell<V>> iterator() {
            return new Iterator<Grid.Cell<V>>(){
                private MutableCell<V> cell = new MutableCell();
                private int count;
                private int current = -1;

                @Override
                public boolean hasNext() {
                    return this.count < grid.size;
                }

                @Override
                public Grid.Cell<V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("No more elements");
                    }
                    ++this.current;
                    while (this.current < grid.values.length && grid.values[this.current] == null) {
                        ++this.current;
                    }
                    Object value = grid.values[this.current];
                    ++this.count;
                    this.cell.set(this.current / grid.columnCount, this.current % grid.columnCount, value);
                    return this.cell;
                }

                @Override
                public void remove() {
                    if (this.current < 0) {
                        throw new IllegalStateException("Unable to remove, next() not called yet");
                    }
                    if (grid.values[this.current] == null) {
                        throw new IllegalStateException("Unable to remove, element has been removed");
                    }
                    grid.values[this.current] = null;
                    --grid.size;
                    --this.count;
                }
            };
        }

        @Override
        public boolean add(Grid.Cell<V> cell) {
            Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"Cell must not be null");
            int oldSize = this.grid.size;
            this.grid.put(cell.getRow(), cell.getColumn(), cell.getValue());
            return this.grid.size > oldSize;
        }

        @Override
        public boolean remove(Object obj) {
            Grid.Cell cell = (Grid.Cell)obj;
            return this.grid.remove(cell.getRow(), cell.getColumn());
        }

        @Override
        public void clear() {
            this.grid.clear();
        }
    }

    static class Inner<V>
    extends AbstractList<V> {
        private final DenseGrid<V> grid;
        private final int size;
        private final int offset;
        private final int gap;

        Inner(DenseGrid<V> grid, int offset, int size, int gap) {
            this.grid = grid;
            this.size = size;
            this.offset = offset;
            this.gap = gap;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public V get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            int arrayIndex = index * this.gap + this.offset;
            return this.grid.values[arrayIndex];
        }

        @Override
        public V set(int index, V newValue) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            int arrayIndex = index * this.gap + this.offset;
            Object old = this.grid.values[arrayIndex];
            this.grid.values[arrayIndex] = newValue;
            if (old == null && newValue != null) {
                ++this.grid.size;
            } else if (old != null && newValue == null) {
                --this.grid.size;
            }
            return old;
        }
    }

    static class Outer<V>
    extends AbstractList<List<V>> {
        private final DenseGrid<V> grid;
        private final int size;
        private final int gap;
        private final int innerSize;
        private final int innerGap;

        Outer(DenseGrid<V> grid, int size, int gap, int innerSize, int innerGap) {
            this.grid = grid;
            this.size = size;
            this.gap = gap;
            this.innerSize = innerSize;
            this.innerGap = innerGap;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public List<V> get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            int base = index * this.gap;
            return new Inner<V>(this.grid, base, this.innerSize, this.innerGap);
        }
    }
}

