/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;

abstract class AbstractGrid<V>
implements Grid<V> {
    static void validateCounts(int rowCount, int columnCount) {
        if (rowCount < 0) {
            throw new IllegalArgumentException("Row count must not be negative: " + rowCount + " < 0");
        }
        if (columnCount < 0) {
            throw new IllegalArgumentException("Column count must not be negative: " + columnCount + " < 0");
        }
    }

    AbstractGrid() {
    }

    @Override
    public boolean exists(int row, int column) {
        return row >= 0 && row < this.rowCount() && column >= 0 && column < this.columnCount();
    }

    @Override
    public boolean isFull() {
        return this.size() == this.rowCount() * this.columnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.cells().size();
    }

    @Override
    public boolean contains(int row, int column) {
        return this.cell(row, column) != null;
    }

    @Override
    public boolean containsValue(Object valueToFind) {
        return valueToFind != null ? this.values().contains(valueToFind) : false;
    }

    @Override
    public V get(int row, int column) {
        Grid.Cell<V> cell = this.cell(row, column);
        return cell != null ? (V)cell.getValue() : null;
    }

    @Override
    public Grid.Cell<V> cell(int row, int column) {
        if (this.exists(row, column)) {
            for (Grid.Cell cell : this.cells()) {
                if (cell.getRow() != row || cell.getColumn() != column) continue;
                return cell;
            }
        }
        return null;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Grid.Cell cell : this.cells()) {
            builder.add(cell.getValue());
        }
        return builder.build();
    }

    @Override
    public List<V> row(int row) {
        Preconditions.checkElementIndex((int)row, (int)this.rowCount(), (String)"Row index");
        return new Inner(this, this.columnCount(), row, true);
    }

    @Override
    public List<List<V>> rows() {
        return new Outer(this, this.rowCount(), this.columnCount(), true);
    }

    @Override
    public List<V> column(int column) {
        Preconditions.checkElementIndex((int)column, (int)this.columnCount(), (String)"Column index");
        return new Inner(this, this.rowCount(), column, false);
    }

    @Override
    public List<List<V>> columns() {
        return new Outer(this, this.columnCount(), this.rowCount(), false);
    }

    Grid.Cell<V> finder(int row, int column) {
        ImmutableCell<String> finder = new ImmutableCell<String>(row, column, "");
        return finder;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Grid) {
            Grid other = (Grid)obj;
            return this.rowCount() == other.rowCount() && this.columnCount() == other.columnCount() && this.cells().equals(other.cells());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.rowCount() ^ Integer.rotateLeft(this.columnCount(), 16) ^ this.cells().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.size() * 16);
        buf.append('[').append(this.rowCount()).append('x').append(this.columnCount()).append(':');
        if (this.size() > 0) {
            for (Grid.Cell cell : this.cells()) {
                buf.append(cell).append(',').append(' ');
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(']');
        return buf.toString();
    }

    static class Inner<V>
    extends AbstractList<V> {
        private final Grid<V> grid;
        private final int size;
        private final int outerIndex;
        private final boolean rows;

        Inner(Grid<V> grid, int size, int outerIndex, boolean rows) {
            this.grid = grid;
            this.size = size;
            this.outerIndex = outerIndex;
            this.rows = rows;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public V get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            if (this.rows) {
                return this.grid.get(this.outerIndex, index);
            }
            return this.grid.get(index, this.outerIndex);
        }

        @Override
        public V set(int index, V newValue) {
            V old = this.get(index);
            if (this.rows) {
                if (newValue == null) {
                    this.grid.remove(this.outerIndex, index);
                } else {
                    this.grid.put(this.outerIndex, index, newValue);
                }
            } else if (newValue == null) {
                this.grid.remove(index, this.outerIndex);
            } else {
                this.grid.put(index, this.outerIndex, newValue);
            }
            return old;
        }
    }

    static class Outer<V>
    extends AbstractList<List<V>> {
        private final Grid<V> grid;
        private final int size;
        private final int innerSize;
        private final boolean rows;

        Outer(Grid<V> grid, int size, int innerSize, boolean rows) {
            this.grid = grid;
            this.size = size;
            this.innerSize = innerSize;
            this.rows = rows;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public List<V> get(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            return new Inner<V>(this.grid, this.innerSize, index, this.rows);
        }
    }
}

