/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.impl.direct.DirectMetaProperty;

class PropertyGen {
    private final PropertyData data;

    PropertyGen(PropertyData propData) {
        this.data = propData;
    }

    List<String> generateConstructorAssign(String fromBean) {
        return this.data.getCopyGen().generateCopyToImmutable("\t\t", fromBean, this.data);
    }

    List<String> generateMetaPropertyConstant() {
        this.data.getBean().ensureImport(MetaProperty.class);
        this.data.getBean().ensureImport(DirectMetaProperty.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        list.add("\t\t */");
        if (this.data.isBeanGenericType()) {
            list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            list.add("\t\tprivate final MetaProperty<" + this.propertyType() + "> " + this.data.getMetaFieldName() + " = (DirectMetaProperty) DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        } else {
            String propertyType = this.propertyType();
            if (propertyType.length() == 1) {
                propertyType = "Object";
            }
            if (this.data.isGenericParamType()) {
                list.add("\t\t@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            }
            list.add("\t\tprivate final MetaProperty<" + propertyType + "> " + this.data.getMetaFieldName() + " = DirectMetaProperty.of" + this.readWrite() + "(");
            list.add("\t\t\t\tthis, \"" + this.data.getPropertyName() + "\", " + this.data.getBean().getTypeRaw() + ".class, " + this.actualType() + ");");
        }
        return list;
    }

    List<String> generateMetaPropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getAlias() != null) {
            list.add("\t\t\t\tcase " + this.data.getAlias().hashCode() + ":  // " + this.data.getAlias() + " (alias)");
        }
        list.add("\t\t\t\t\treturn " + this.data.getMetaFieldName() + ";");
        return list;
    }

    List<String> generateGetter() {
        return this.data.getGetterGen().generateGetter(this.data);
    }

    List<String> generateSetter() {
        return this.data.getSetterGen().generateSetter("\t", this.data);
    }

    List<String> generateProperty() {
        this.data.getBean().ensureImport(Property.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets the the {@code " + this.data.getPropertyName() + "} property.");
        for (String comment : this.data.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the property, not null");
        if (this.data.getDeprecatedComment() != null) {
            list.add("\t * " + this.data.getDeprecatedComment());
        }
        list.add("\t */");
        if (this.data.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\tpublic " + (this.data.getBean().isTypeFinal() ? "" : "final ") + "Property<" + this.propertyType() + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\treturn metaBean()." + this.data.getPropertyName() + "().createProperty(this);");
        list.add("\t}");
        list.add("");
        return list;
    }

    List<String> generateMetaProperty() {
        ArrayList<String> list = new ArrayList<String>();
        String propertyType = this.propertyType();
        list.add("\t\t/**");
        list.add("\t\t * The meta-property for the {@code " + this.data.getPropertyName() + "} property.");
        list.add("\t\t * @return the meta-property, not null");
        if (this.data.getDeprecatedComment() != null) {
            list.add("\t\t * " + this.data.getDeprecatedComment());
        }
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        list.add("\t\tpublic " + (this.data.getBean().isTypeFinal() ? "" : "final ") + "MetaProperty<" + propertyType + "> " + this.data.getPropertyName() + "() {");
        list.add("\t\t\treturn " + this.data.getMetaFieldName() + ";");
        list.add("\t\t}");
        list.add("");
        return list;
    }

    List<String> generatePropertyGetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getAlias() != null) {
            list.add("\t\t\t\tcase " + this.data.getAlias().hashCode() + ":  // " + this.data.getAlias() + " (alias)");
        }
        if (this.data.getStyle().isReadable()) {
            list.add("\t\t\t\t\treturn ((" + this.data.getBean().getTypeWildcard() + ") bean)." + this.data.getGetterGen().generateGetInvoke(this.data) + ";");
        } else {
            list.add("\t\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\t\treturn null;");
            list.add("\t\t\t\t\t}");
            list.add("\t\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be read: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    List<String> generatePropertySetCase() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getAlias() != null) {
            list.add("\t\t\t\tcase " + this.data.getAlias().hashCode() + ":  // " + this.data.getAlias() + " (alias)");
        }
        String setter = this.data.getSetterGen().generateSetInvoke(this.data, this.castObject() + "newValue");
        if (this.data.getStyle().isWritable() && setter != null) {
            list.add("\t\t\t\t\t((" + this.data.getBean().getTypeNoExtends() + ") bean)." + setter + ";");
            list.add("\t\t\t\t\treturn;");
        } else {
            list.add("\t\t\t\t\tif (quiet) {");
            list.add("\t\t\t\t\t\treturn;");
            list.add("\t\t\t\t\t}");
            list.add("\t\t\t\t\tthrow new UnsupportedOperationException(\"Property cannot be written: " + this.data.getPropertyName() + "\");");
        }
        return list;
    }

    String generateLambdaGetter() {
        return "b -> b." + this.data.getGetterGen().generateGetInvoke(this.data);
    }

    String generateLambdaSetter() {
        String propType = this.propertyType(this.data.getTypeBeanErased());
        String cast = propType.equals("Object") ? "" : "(" + propType + ") ";
        return "(b, v) -> b." + this.data.getSetterGen().generateSetInvoke(this.data, cast + "v");
    }

    boolean isSpecialInit() {
        return this.data.getBuilderGen().isSpecialInit(this.data);
    }

    String generateInit() {
        return this.data.getBuilderGen().generateInit(this.data);
    }

    List<String> generateBuilderField() {
        return this.data.getBuilderGen().generateField("\t\t", this.data);
    }

    List<String> generateBuilderConstructorAssign(String beanToCopyFrom) {
        return this.data.getCopyGen().generateCopyToMutable("\t\t\t", this.data, beanToCopyFrom);
    }

    List<String> generateBuilderFieldGet() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getAlias() != null) {
            list.add("\t\t\t\tcase " + this.data.getAlias().hashCode() + ":  // " + this.data.getAlias() + " (alias)");
        }
        list.add("\t\t\t\t\treturn " + this.generateBuilderFieldName() + ";");
        return list;
    }

    List<String> generateBuilderFieldSet() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t\t\tcase " + this.data.getPropertyName().hashCode() + ":  // " + this.data.getPropertyName());
        if (this.data.getAlias() != null) {
            list.add("\t\t\t\tcase " + this.data.getAlias().hashCode() + ":  // " + this.data.getAlias() + " (alias)");
        }
        list.add("\t\t\t\t\tthis." + this.generateBuilderFieldName() + " = (" + this.propertyType(this.getBuilderType()) + ") newValue;");
        list.add("\t\t\t\t\tbreak;");
        return list;
    }

    String generateBuilderFieldName() {
        return this.data.getFieldName();
    }

    List<String> generateBuilderSetMethod() {
        String builderType;
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t\t/**");
        list.add("\t\t * Sets " + this.data.getFirstComment());
        for (String comment : this.data.getComments()) {
            list.add("\t\t * " + comment);
        }
        list.add("\t\t * @param " + this.data.getPropertyName() + "  the new value" + this.data.getNotNullJavadoc());
        list.add("\t\t * @return this, for chaining, not null");
        if (this.data.getDeprecatedComment() != null) {
            list.add("\t\t * " + this.data.getDeprecatedComment());
        }
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        if ((builderType = this.getBuilderType()).endsWith("[]") && !builderType.endsWith("[][]") && !builderType.equals("byte[]")) {
            list.add("\t\tpublic Builder" + this.data.getBean().getTypeGenericName(true) + " " + this.data.getPropertyName() + "(" + builderType.substring(0, builderType.length() - 2) + "... " + this.data.getPropertyName() + ") {");
        } else {
            list.add("\t\tpublic Builder" + this.data.getBean().getTypeGenericName(true) + " " + this.data.getPropertyName() + "(" + builderType + " " + this.data.getPropertyName() + ") {");
        }
        if (this.data.isValidated()) {
            list.add("\t\t\t" + this.data.getValidationMethodName() + "(" + this.data.getPropertyName() + ", \"" + this.data.getPropertyName() + "\");");
        }
        list.add("\t\t\tthis." + this.generateBuilderFieldName() + " = " + this.data.getPropertyName() + ";");
        list.add("\t\t\treturn this;");
        list.add("\t\t}");
        list.add("");
        this.generateBuilderSetCollectionMethod(list);
        return list;
    }

    String getBuilderType() {
        return this.data.getBuilderGen().generateType(this.data);
    }

    private void generateBuilderSetCollectionMethod(List<String> list) {
        String code = this.data.getVarArgsCode();
        if (code == null) {
            return;
        }
        String argType = this.data.getTypeGenericsSimple();
        if (argType.equals("?")) {
            argType = "Object";
        }
        if (argType.startsWith("? extends ")) {
            argType = argType.substring(10);
        }
        boolean safeVarargs = argType.length() == 1 || argType.contains("<");
        list.add("\t\t/**");
        list.add("\t\t * Sets the {@code " + this.data.getPropertyName() + "} property in the builder");
        list.add("\t\t * from an array of objects.");
        list.add("\t\t * @param " + this.data.getPropertyName() + "  the new value" + this.data.getNotNullJavadoc());
        list.add("\t\t * @return this, for chaining, not null");
        if (this.data.getDeprecatedComment() != null) {
            list.add("\t\t * " + this.data.getDeprecatedComment());
        }
        list.add("\t\t */");
        if (this.data.isDeprecated()) {
            list.add("\t\t@Deprecated");
        }
        if (safeVarargs) {
            list.add("\t\t@SafeVarargs");
        }
        list.add("\t\tpublic " + (safeVarargs ? "final " : "") + "Builder" + this.data.getBean().getTypeGenericName(true) + " " + this.data.getPropertyName() + "(" + argType + "... " + this.data.getPropertyName() + ") {");
        if (code.contains("Arrays.asList")) {
            this.data.getBean().ensureImport(Arrays.class);
        }
        code = code.replace("$value", this.data.getPropertyName());
        code = code.replace("<>", this.data.getTypeGenerics());
        list.add("\t\t\treturn " + this.data.getPropertyName() + "(" + code + ");");
        list.add("\t\t}");
        list.add("");
    }

    private String readWrite() {
        switch (this.data.getStyle()) {
            case READ_WRITE: {
                return "ReadWrite";
            }
            case READ_ONLY: {
                return "ReadOnly";
            }
            case WRITE_ONLY: {
                return "WriteOnly";
            }
            case DERIVED: {
                return "Derived";
            }
            case READ_ONLY_BUILDABLE: {
                return "ReadOnlyBuildable";
            }
            case IMMUTABLE: {
                return "Immutable";
            }
        }
        throw new RuntimeException("Invalid style");
    }

    private String actualType() {
        String pt = this.propertyType();
        if (pt.equals(this.data.getType())) {
            int genericStart = pt.indexOf(60);
            if (genericStart >= 0) {
                return "(Class) " + pt.substring(0, genericStart) + ".class";
            }
            if (this.data.getType().length() == 1) {
                return "Object.class";
            }
            if (this.data.isGenericArrayType()) {
                return "Object[].class";
            }
            return pt + ".class";
        }
        return pt + ".TYPE";
    }

    private String castObject() {
        String pt = this.propertyType();
        return "(" + pt + ") ";
    }

    private String propertyType() {
        return this.propertyType(this.data.getType());
    }

    private String propertyType(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("byte")) {
            return "Byte";
        }
        if (type.equals("short")) {
            return "Short";
        }
        if (type.equals("char")) {
            return "Character";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("double")) {
            return "Double";
        }
        return type;
    }

    PropertyData getData() {
        return this.data;
    }

    static String resolveWildcard(String input) {
        return input.equals("<?>") ? "<Object>" : input;
    }
}

