/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;

public final class PropertyPath<P> {
    private final String propertyPath;
    private final Class<P> resultType;
    private final List<PathEntry> pathEntries;

    private PropertyPath(String propertyPath, Class<P> resultType, List<PathEntry> pathEntries) {
        this.propertyPath = propertyPath;
        this.resultType = resultType;
        this.pathEntries = pathEntries;
    }

    public static <P> PropertyPath<P> of(String propertyPath, Class<P> resultType) {
        JodaBeanUtils.notNull(propertyPath, "propertyPath");
        JodaBeanUtils.notNull(resultType, "resultType");
        List<PathEntry> split = PathEntry.parse(propertyPath);
        return new PropertyPath<P>(propertyPath, resultType, split);
    }

    public Optional<P> get(Bean bean) {
        JodaBeanUtils.notNull(bean, "bean");
        Bean currentBean = bean;
        for (int i = 0; i < this.pathEntries.size() - 1; ++i) {
            PathEntry pathEntry = this.pathEntries.get(i);
            Object obj = pathEntry.get(currentBean);
            if ((obj = pathEntry.extract(obj)) instanceof Optional) {
                obj = ((Optional)obj).orElse(null);
            }
            if (obj == null) {
                return Optional.empty();
            }
            if (!(obj instanceof Bean)) {
                return Optional.empty();
            }
            currentBean = (Bean)obj;
        }
        PathEntry pathEntry = this.pathEntries.get(this.pathEntries.size() - 1);
        Object obj = pathEntry.get(currentBean);
        if ((obj = pathEntry.extract(obj)) == null) {
            return Optional.empty();
        }
        if (this.resultType.isInstance(obj)) {
            return Optional.of(this.resultType.cast(obj));
        }
        if (obj instanceof Optional) {
            obj = ((Optional)obj).orElse(null);
        }
        if (this.resultType.isInstance(obj)) {
            return Optional.of(this.resultType.cast(obj));
        }
        return Optional.empty();
    }

    public String propertyPath() {
        return this.propertyPath;
    }

    public Class<P> resultType() {
        return this.resultType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyPath) {
            PropertyPath other = (PropertyPath)obj;
            return this.propertyPath.equals(other.propertyPath) && this.resultType.equals(other.resultType);
        }
        return false;
    }

    public int hashCode() {
        return this.propertyPath.hashCode() ^ this.resultType.hashCode();
    }

    public String toString() {
        return this.propertyPath + ": " + this.resultType.getName();
    }

    private static final class PathEntry {
        private final String propertyName;
        private final String key;
        private final int index;

        static List<PathEntry> parse(String propertyPath) {
            String[] split = propertyPath.split("\\.");
            return Stream.of(split).map(entryStr -> PathEntry.extractEntry(propertyPath, entryStr)).collect(Collectors.toList());
        }

        private static PathEntry extractEntry(String propertyPath, String entryStr) {
            String propName = entryStr;
            String key = null;
            int index = 0;
            int start = entryStr.lastIndexOf(91);
            if (entryStr.endsWith("]") && start > 0) {
                key = entryStr.substring(start + 1, entryStr.length() - 1);
                if (key.length() == 0) {
                    throw new IllegalArgumentException("Invalid property path, empty key: " + propertyPath);
                }
                char firstChar = key.charAt(0);
                index = -1;
                if (firstChar == '-' || firstChar >= '0' && firstChar <= '9') {
                    try {
                        index = Integer.parseInt(key);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                propName = entryStr.substring(0, start);
            }
            return new PathEntry(propName, key, index);
        }

        private PathEntry(String propertyName, String key, int index) {
            this.propertyName = propertyName;
            this.key = key;
            this.index = index;
        }

        private Object get(Bean bean) {
            try {
                return bean.metaBean().metaProperty(this.propertyName).get(bean);
            }
            catch (RuntimeException ex) {
                return null;
            }
        }

        private Object extract(Object obj) {
            if (obj instanceof Map) {
                if (this.key == null) {
                    return this.extract(((Map)obj).values());
                }
                Map map = (Map)obj;
                for (Map.Entry mapEntry : map.entrySet()) {
                    if (!this.key.equals(mapEntry.getKey())) continue;
                    return mapEntry.getValue();
                }
                return null;
            }
            if (obj instanceof Iterable) {
                if (this.key != null && this.index < 0) {
                    return null;
                }
                if (obj instanceof List) {
                    List list = (List)obj;
                    if (this.index < list.size()) {
                        return list.get(this.index);
                    }
                    return null;
                }
                Iterator it = ((Iterable)obj).iterator();
                for (int i = 0; it.hasNext() && i < this.index; ++i) {
                    it.next();
                }
                return it.hasNext() ? it.next() : null;
            }
            if (this.key != null && !"0".equals(this.key)) {
                return null;
            }
            return obj;
        }
    }
}

