/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSmartReader;
import org.joda.beans.ser.SerDeserializers;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.bin.JodaBeanBinReader;
import org.joda.beans.ser.bin.JodaBeanBinWriter;
import org.joda.beans.ser.json.JodaBeanJsonReader;
import org.joda.beans.ser.json.JodaBeanJsonWriter;
import org.joda.beans.ser.json.JodaBeanSimpleJsonReader;
import org.joda.beans.ser.json.JodaBeanSimpleJsonWriter;
import org.joda.beans.ser.map.JodaBeanSimpleMapReader;
import org.joda.beans.ser.map.JodaBeanSimpleMapWriter;
import org.joda.beans.ser.xml.JodaBeanXmlReader;
import org.joda.beans.ser.xml.JodaBeanXmlWriter;
import org.joda.convert.StringConvert;

public final class JodaBeanSer {
    public static final JodaBeanSer COMPACT = new JodaBeanSer("", "", StringConvert.create(), SerIteratorFactory.INSTANCE, true, SerDeserializers.INSTANCE, false);
    public static final JodaBeanSer PRETTY = new JodaBeanSer(" ", "\n", StringConvert.create(), SerIteratorFactory.INSTANCE, true, SerDeserializers.INSTANCE, false);
    private final String indent;
    private final String newLine;
    private final StringConvert converter;
    private final SerIteratorFactory iteratorFactory;
    private final boolean shortTypes;
    private final SerDeserializers deserializers;
    private final boolean includeDerived;

    private JodaBeanSer(String indent, String newLine, StringConvert converter, SerIteratorFactory iteratorFactory, boolean shortTypes, SerDeserializers deserializers, boolean includeDerived) {
        this.indent = indent;
        this.newLine = newLine;
        this.converter = converter;
        this.iteratorFactory = iteratorFactory;
        this.shortTypes = shortTypes;
        this.deserializers = deserializers;
        this.includeDerived = includeDerived;
    }

    public String getIndent() {
        return this.indent;
    }

    public JodaBeanSer withIndent(String indent) {
        JodaBeanUtils.notNull(indent, "indent");
        return new JodaBeanSer(indent, this.newLine, this.converter, this.iteratorFactory, this.shortTypes, this.deserializers, this.includeDerived);
    }

    public String getNewLine() {
        return this.newLine;
    }

    public JodaBeanSer withNewLine(String newLine) {
        JodaBeanUtils.notNull(newLine, "newLine");
        return new JodaBeanSer(this.indent, newLine, this.converter, this.iteratorFactory, this.shortTypes, this.deserializers, this.includeDerived);
    }

    public StringConvert getConverter() {
        return this.converter;
    }

    public JodaBeanSer withConverter(StringConvert converter) {
        JodaBeanUtils.notNull(converter, "converter");
        return new JodaBeanSer(this.indent, this.newLine, converter, this.iteratorFactory, this.shortTypes, this.deserializers, this.includeDerived);
    }

    public SerIteratorFactory getIteratorFactory() {
        return this.iteratorFactory;
    }

    public JodaBeanSer withIteratorFactory(SerIteratorFactory iteratorFactory) {
        JodaBeanUtils.notNull(iteratorFactory, "iteratorFactory");
        return new JodaBeanSer(this.indent, this.newLine, this.converter, iteratorFactory, this.shortTypes, this.deserializers, this.includeDerived);
    }

    public boolean isShortTypes() {
        return this.shortTypes;
    }

    public JodaBeanSer withShortTypes(boolean shortTypes) {
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, shortTypes, this.deserializers, this.includeDerived);
    }

    public SerDeserializers getDeserializers() {
        return this.deserializers;
    }

    public JodaBeanSer withDeserializers(SerDeserializers deserializers) {
        JodaBeanUtils.notNull(deserializers, "deserializers");
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, this.shortTypes, deserializers, this.includeDerived);
    }

    public boolean isIncludeDerived() {
        return this.includeDerived;
    }

    public JodaBeanSer withIncludeDerived(boolean includeDerived) {
        return new JodaBeanSer(this.indent, this.newLine, this.converter, this.iteratorFactory, this.shortTypes, this.deserializers, includeDerived);
    }

    public boolean isSerialized(MetaProperty<?> prop) {
        return prop.style().isSerializable() || prop.style().isDerived() && this.includeDerived;
    }

    public JodaBeanSmartReader smartReader() {
        return new JodaBeanSmartReader(this);
    }

    public JodaBeanBinWriter binWriter() {
        return new JodaBeanBinWriter(this, false);
    }

    public JodaBeanBinWriter binWriterReferencing() {
        return new JodaBeanBinWriter(this, true);
    }

    public JodaBeanBinReader binReader() {
        return new JodaBeanBinReader(this);
    }

    public JodaBeanXmlWriter xmlWriter() {
        return new JodaBeanXmlWriter(this);
    }

    public JodaBeanXmlReader xmlReader() {
        return new JodaBeanXmlReader(this);
    }

    public JodaBeanJsonWriter jsonWriter() {
        return new JodaBeanJsonWriter(this);
    }

    public JodaBeanJsonReader jsonReader() {
        return new JodaBeanJsonReader(this);
    }

    public JodaBeanSimpleJsonWriter simpleJsonWriter() {
        return new JodaBeanSimpleJsonWriter(this);
    }

    public JodaBeanSimpleJsonReader simpleJsonReader() {
        return new JodaBeanSimpleJsonReader(this);
    }

    public JodaBeanSimpleMapWriter simpleMapWriter() {
        return new JodaBeanSimpleMapWriter(this);
    }

    public JodaBeanSimpleMapReader simpleMapReader() {
        return new JodaBeanSimpleMapReader(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

