/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;

final class MinimalMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> propertyType;
    private final Type propertyGenericType;
    private final List<Annotation> annotations;
    private final Function<Bean, Object> getter;
    private final BiConsumer<Bean, Object> setter;
    private final PropertyStyle style;

    MinimalMetaProperty(MetaBean metaBean, String propertyName, Field field, Function<? extends Bean, Object> getter, BiConsumer<? extends Bean, Object> setter) {
        super(propertyName);
        this.metaBean = metaBean;
        this.propertyType = field.getType();
        this.propertyGenericType = field.getGenericType();
        this.annotations = Arrays.asList(field.getAnnotations());
        this.getter = getter;
        this.setter = setter;
        this.style = ImmutableBean.class.isAssignableFrom(metaBean.beanType()) ? PropertyStyle.IMMUTABLE : (setter != null ? PropertyStyle.READ_WRITE : PropertyStyle.READ_ONLY);
    }

    MinimalMetaProperty(MetaBean metaBean, Method method, String propertyName) {
        super(propertyName);
        this.metaBean = metaBean;
        this.propertyType = method.getReturnType();
        this.propertyGenericType = method.getGenericReturnType();
        this.annotations = Arrays.asList(method.getAnnotations());
        this.getter = b -> {
            try {
                return method.invoke(b, new Object[0]);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.setter = null;
        this.style = PropertyStyle.DERIVED;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.metaBean.beanType();
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        return this.propertyGenericType;
    }

    @Override
    public PropertyStyle style() {
        return this.style;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public P get(Bean bean) {
        try {
            return (P)this.getter.apply(bean);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void set(Bean bean, Object value) {
        if (this.setter == null) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name());
        }
        try {
            this.setter.accept(bean, value);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

