/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.impl.BasicProperty;

public final class BasicPropertyMap
extends AbstractMap<String, Property<?>> {
    private final Bean bean;

    public static BasicPropertyMap of(Bean bean) {
        return new BasicPropertyMap(bean);
    }

    private BasicPropertyMap(Bean bean) {
        if (bean == null) {
            throw new NullPointerException("Bean must not be null");
        }
        this.bean = bean;
    }

    @Override
    public int size() {
        return this.bean.metaBean().metaPropertyCount();
    }

    @Override
    public boolean containsKey(Object obj) {
        return obj instanceof String ? this.bean.metaBean().metaPropertyExists(obj.toString()) : false;
    }

    @Override
    public Property<?> get(Object obj) {
        return this.containsKey(obj) ? this.bean.metaBean().metaProperty(obj.toString()).createProperty(this.bean) : null;
    }

    @Override
    public Set<String> keySet() {
        return this.bean.metaBean().metaPropertyMap().keySet();
    }

    @Override
    public Set<Map.Entry<String, Property<?>>> entrySet() {
        return new AbstractSet<Map.Entry<String, Property<?>>>(){

            @Override
            public int size() {
                return BasicPropertyMap.this.bean.metaBean().metaPropertyCount();
            }

            @Override
            public Iterator<Map.Entry<String, Property<?>>> iterator() {
                final Iterator<MetaProperty<?>> it = BasicPropertyMap.this.bean.metaBean().metaPropertyMap().values().iterator();
                return new Iterator<Map.Entry<String, Property<?>>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Property<?>> next() {
                        MetaProperty meta = (MetaProperty)it.next();
                        return new AbstractMap.SimpleImmutableEntry(meta.name(), BasicProperty.of(BasicPropertyMap.this.bean, meta));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Unmodifiable");
                    }
                };
            }
        };
    }

    public Map<String, Object> flatten() {
        return JodaBeanUtils.flatten(this.bean);
    }
}

