/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.joda.beans.maven.AbstractJodaBeansGenerateMojo;
import org.joda.beans.maven.AbstractJodaBeansMojo;

@Mojo(name="generate-no-resolve", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
@Execute(goal="generate-no-resolve", phase=LifecyclePhase.PROCESS_SOURCES)
public class JodaBeansGenerateNoResolveMojo
extends AbstractJodaBeansGenerateMojo {
    private static final ConcurrentMap<String, ClassLoader> classLoaderCache = new ConcurrentHashMap<String, ClassLoader>();
    @Parameter(alias="jodaBeansVersion", property="joda.beans.version", defaultValue="2.5.0", required=true)
    private String jodaBeansVersion;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepos;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepo;

    @Override
    synchronized ClassLoader obtainClassLoader() throws MojoExecutionException {
        ClassLoader cached = (ClassLoader)classLoaderCache.get(this.jodaBeansVersion);
        if (cached != null) {
            return cached;
        }
        this.logInfo("Finding joda-beans for version " + this.jodaBeansVersion + " (override using property: joda.beans.version)");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveTransitively(true);
        request.setLocalRepository(this.localRepo);
        request.setRemoteRepositories(this.remoteRepos);
        request.setArtifact(this.repoSystem.createArtifact("org.joda", "joda-beans", this.jodaBeansVersion, "compile", "jar"));
        ArtifactResolutionResult result = this.repoSystem.resolve(request);
        if (!result.isSuccess()) {
            throw new MojoExecutionException("Unable to resolve org.joda:joda-beans:" + this.jodaBeansVersion);
        }
        ArrayList<URL> classpath = new ArrayList<URL>();
        for (Artifact artifact : result.getArtifacts()) {
            File file = new File(this.localRepo.getBasedir(), this.localRepo.pathOf(artifact));
            try {
                URL location = file.toURI().toURL();
                classpath.add(location);
                this.logDebug("at " + location);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Error interpreting classpath entry as URL: " + file, ex);
            }
        }
        URL[] classpathUrls = classpath.toArray(new URL[classpath.size()]);
        URLClassLoader classLoader = new URLClassLoader(classpathUrls, AbstractJodaBeansMojo.class.getClassLoader());
        classLoaderCache.put(this.jodaBeansVersion, classLoader);
        return classLoader;
    }
}

