/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.Scanner;
import org.joda.beans.maven.AbstractJodaBeansMojo;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractJodaBeansGenerateMojo
extends AbstractJodaBeansMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    protected void runTool(Class<?> toolClass, List<String> argsList, BuildContext buildContext) throws MojoExecutionException, MojoFailureException {
        Object file;
        File classesDir;
        File sourceDir;
        String[] changedSourceFiles = this.findFiles(buildContext, this.getSourceDir());
        String[] changedTestFiles = this.findFiles(buildContext, this.getTestSourceDir());
        int sourceFilesChanged = changedSourceFiles.length;
        int testFilesChanged = changedTestFiles.length;
        if (sourceFilesChanged == 0 && testFilesChanged == 0) {
            this.logInfo("No files changed");
            return;
        }
        this.logDebug("Files changed: main=" + sourceFilesChanged + ", test=" + testFilesChanged);
        this.logInfo("Joda-Bean generator started, directory: " + this.getSourceDir() + (this.getTestSourceDir().length() == 0 ? "" : ", test directory: " + this.getTestSourceDir()));
        int changedFileCount = 0;
        if (sourceFilesChanged > 0) {
            sourceDir = new File(this.getSourceDir());
            classesDir = new File(this.getClassesDir());
            for (String changedFile : changedSourceFiles) {
                buildContext.removeMessages(new File(sourceDir, changedFile));
            }
            if (sourceFilesChanged == 1) {
                file = new File(sourceDir, changedSourceFiles[0]);
                argsList.add(((File)file).toString());
                this.logDebug("Single file: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, sourceDir, classesDir);
            } else {
                argsList.add(this.getSourceDir());
                this.logDebug("All files: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, sourceDir, classesDir);
            }
        }
        if (testFilesChanged > 0) {
            sourceDir = new File(this.getTestSourceDir());
            classesDir = new File(this.getTestClassesDir());
            for (String changedFile : changedTestFiles) {
                buildContext.removeMessages(new File(sourceDir, changedFile));
            }
            if (testFilesChanged == 1) {
                file = new File(sourceDir, changedTestFiles[0]);
                argsList.set(argsList.size() - 1, ((File)file).toString());
                this.logDebug("Single test file: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, sourceDir, classesDir);
            } else {
                argsList.set(argsList.size() - 1, this.getTestSourceDir());
                this.logDebug("All test files: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, sourceDir, classesDir);
            }
        }
        this.logInfo("Joda-Bean generator completed, " + changedFileCount + " changed files");
    }

    private String[] findFiles(BuildContext buildContext, String dirStr) {
        File dir = new File(dirStr);
        if (dirStr.isEmpty() || !dir.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        Scanner scanner = buildContext.newScanner(dir);
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        String[] changedSourceFiles = scanner.getIncludedFiles();
        return changedSourceFiles;
    }
}

