/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public class AbstractJodaBeansMojo
extends AbstractMojo {
    private static final String JODA_BEANS_MESSAGE_FILE = "joda-beans.message.file";
    static final Pattern MESSAGE_PATTERN = Pattern.compile("Error in bean[:] (.*?)[,] Line[:] ([0-9]+)[,] Message[:] (.*)");
    private boolean _skip;
    private String sourceDir;
    private String classesDir;
    private String testSourceDir;
    private String testClassesDir;
    private String indent;
    private String prefix;
    private Integer verbose;
    private boolean eclipse;
    private MavenProject _project;
    private BuildContext buildContext;

    protected String getSourceDir() {
        return this.sourceDir == null ? "" : this.sourceDir.trim();
    }

    protected String getClassesDir() {
        return this.classesDir == null ? "" : this.classesDir.trim();
    }

    protected String getTestSourceDir() {
        return this.testSourceDir == null ? "" : this.testSourceDir.trim();
    }

    protected String getTestClassesDir() {
        return this.testClassesDir == null ? "" : this.testClassesDir.trim();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this._skip) {
            return;
        }
        if (this.getSourceDir().length() == 0) {
            throw new MojoExecutionException("Source directory must be specified");
        }
        URLClassLoader classLoader = this.obtainClassLoader();
        Class<?> toolClass = null;
        try {
            toolClass = classLoader.loadClass("org.joda.beans.gen.BeanCodeGen");
        }
        catch (Exception ex) {
            this.getLog().info((CharSequence)"Skipping as joda-beans is not in the project compile classpath");
            return;
        }
        List<String> argsList = this.buildArgs();
        this.runTool(toolClass, argsList);
    }

    protected List<String> buildArgs() {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-R");
        if (this.indent != null) {
            argsList.add("-indent=" + this.indent);
        }
        if (this.prefix != null) {
            argsList.add("-prefix=" + this.prefix);
        }
        if (this.verbose != null) {
            argsList.add("-verbose=" + this.verbose);
        }
        return argsList;
    }

    protected int runTool(Class<?> toolClass, List<String> argsList) throws MojoExecutionException, MojoFailureException {
        File errorFile = (File)this.buildContext.getValue(JODA_BEANS_MESSAGE_FILE);
        if (errorFile != null) {
            this.buildContext.removeMessages(errorFile);
        }
        argsList.add(this.getSourceDir());
        int changedFileCount = this.runToolHandleChanges(toolClass, argsList, new File(this.getSourceDir()), new File(this.getClassesDir()));
        if (this.getTestSourceDir().length() > 0) {
            argsList.set(argsList.size() - 1, this.getTestSourceDir());
            changedFileCount += this.runToolHandleChanges(toolClass, argsList, new File(this.getTestSourceDir()), new File(this.getTestClassesDir()));
        }
        return changedFileCount;
    }

    private int runToolHandleChanges(Class<?> toolClass, List<String> argsList, File baseDir, File classesDir) throws MojoExecutionException, MojoFailureException {
        try {
            String baseStr = baseDir.getCanonicalPath();
            List<File> changedFiles = this.invoke(toolClass, argsList);
            if (changedFiles.size() > 0) {
                if (changedFiles.get(0) == null) {
                    this.buildContext.refresh(baseDir);
                } else {
                    for (File file : changedFiles) {
                        File classFile;
                        String fileStr;
                        this.getLog().debug((CharSequence)("Refreshed: " + file));
                        this.buildContext.refresh(file);
                        if (!this.eclipse || (fileStr = file.getCanonicalPath()).length() <= baseStr.length() || !fileStr.startsWith(baseStr)) continue;
                        String relative = fileStr.substring(baseStr.length());
                        if (relative.startsWith("/") || relative.startsWith("\\")) {
                            relative = relative.substring(1);
                        }
                        if ((classFile = new File(classesDir, relative = relative.replace(".java", ".class"))).delete()) {
                            this.getLog().debug((CharSequence)("Deleted: " + classFile));
                            continue;
                        }
                        this.getLog().debug((CharSequence)("Failed to delete: " + classFile));
                    }
                }
            }
            return changedFiles.size();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("IO problem", (Exception)ex);
        }
        catch (MojoFailureException ex) {
            if (this.eclipse && this.buildContext.getValue(JODA_BEANS_MESSAGE_FILE) != null) {
                return 0;
            }
            throw ex;
        }
    }

    private List<File> invoke(Class<?> toolClass, List<String> argsList) throws MojoExecutionException, MojoFailureException {
        Method createFromArgsMethod = this.findCreateFromArgsMethod(toolClass);
        Method processMethod = this.findProcessMethod(toolClass);
        Object beanCodeGen = this.createBuilder(argsList, createFromArgsMethod);
        if (processMethod.getReturnType() == Integer.TYPE) {
            int count = this.invokeBuilderCountChanges(processMethod, beanCodeGen);
            return Collections.nCopies(count, null);
        }
        return this.invokeBuilderListChanges(processMethod, beanCodeGen);
    }

    private Method findCreateFromArgsMethod(Class<?> toolClass) throws MojoExecutionException {
        Method createFromArgsMethod = null;
        try {
            createFromArgsMethod = toolClass.getMethod("createFromArgs", String[].class);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to find method BeanCodeGen.createFromArgs()");
        }
        return createFromArgsMethod;
    }

    private Method findProcessMethod(Class<?> toolClass) throws MojoExecutionException {
        Method processMethod = null;
        try {
            processMethod = toolClass.getMethod("processFiles", new Class[0]);
            this.getLog().debug((CharSequence)"Using Joda-Beans v1.5 or later - processFiles()");
        }
        catch (Exception ex) {
            try {
                processMethod = toolClass.getMethod("process", new Class[0]);
                this.getLog().debug((CharSequence)"Using Joda-Beans v1.4 or earlier - process()");
            }
            catch (Exception ex2) {
                throw new MojoExecutionException("Unable to find method BeanCodeGen.processFiles() or BeanCodeGen.process()");
            }
        }
        return processMethod;
    }

    private Object createBuilder(List<String> argsList, Method createFromArgsMethod) throws MojoExecutionException, MojoFailureException {
        String[] args = argsList.toArray(new String[argsList.size()]);
        try {
            return createFromArgsMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.createFromArgs()");
        }
        catch (IllegalAccessException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.createFromArgs()");
        }
        catch (InvocationTargetException ex) {
            throw new MojoFailureException("Invalid Joda-Beans Mojo configuration: " + ex.getCause().getMessage(), ex.getCause());
        }
    }

    private int invokeBuilderCountChanges(Method processMethod, Object beanCodeGen) throws MojoExecutionException, MojoFailureException {
        try {
            return (Integer)processMethod.invoke(beanCodeGen, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (IllegalAccessException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (InvocationTargetException ex) {
            throw this.handleFailure(ex);
        }
    }

    private List<File> invokeBuilderListChanges(Method processMethod, Object beanCodeGen) throws MojoExecutionException, MojoFailureException {
        try {
            return (List)processMethod.invoke(beanCodeGen, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (IllegalAccessException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (InvocationTargetException ex) {
            throw this.handleFailure(ex);
        }
    }

    private MojoFailureException handleFailure(InvocationTargetException ex) throws MojoFailureException {
        String msg = ex.getCause().getMessage();
        File file = new File(this.getSourceDir());
        int line = 1;
        try {
            if (msg.startsWith("Error in bean: ")) {
                Matcher matcher = MESSAGE_PATTERN.matcher(msg);
                if (matcher.matches()) {
                    file = new File(matcher.group(1));
                    line = Integer.parseInt(matcher.group(2));
                    msg = matcher.group(3);
                } else {
                    File sourceFile = new File(msg.substring("Error in bean: ".length()));
                    if (sourceFile.exists()) {
                        file = sourceFile;
                        if (ex.getCause().getCause() != null) {
                            msg = ex.getCause().getCause().getMessage();
                            if (ex.getCause().getCause().getCause() != null) {
                                msg = msg + ": " + ex.getCause().getCause().getCause().getMessage();
                            }
                        }
                    }
                }
            } else if (ex.getCause().getCause() != null) {
                msg = msg + ": " + ex.getCause().getCause().getMessage();
                if (ex.getCause().getCause().getCause() != null) {
                    msg = msg + ": " + ex.getCause().getCause().getCause().getMessage();
                }
            }
        }
        catch (Exception unexpected) {
            // empty catch block
        }
        this.buildContext.setValue(JODA_BEANS_MESSAGE_FILE, (Object)file);
        this.buildContext.addMessage(file.getAbsoluteFile(), line + 1, 1, msg, 2, ex.getCause());
        return new MojoFailureException("Error while running Joda-Beans tool: " + msg, ex.getCause());
    }

    private URLClassLoader obtainClassLoader() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Finding joda-beans in classpath");
        List<String> compileClasspath = this.obtainClasspath();
        HashSet<URL> classpathUrlSet = new HashSet<URL>();
        for (String classpathEntry : compileClasspath) {
            File f = new File(classpathEntry);
            if (!f.exists() || !f.getPath().contains("joda")) continue;
            try {
                this.getLog().debug((CharSequence)("Found classpath: " + f));
                classpathUrlSet.add(f.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Error interpreting classpath entry as URL: " + classpathEntry, ex);
            }
        }
        URL[] classpathUrls = classpathUrlSet.toArray(new URL[classpathUrlSet.size()]);
        return new URLClassLoader(classpathUrls, AbstractJodaBeansMojo.class.getClassLoader());
    }

    private List<String> obtainClasspath() throws MojoExecutionException {
        try {
            return this._project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Error obtaining dependencies", (Exception)((Object)ex));
        }
    }
}

