/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.lodcalc;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.UpdatedTerrainPatch;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class PerspectiveLodCalculator
implements LodCalculator {
    private Camera cam;
    private float pixelError;
    private boolean turnOffLod = false;

    public PerspectiveLodCalculator() {
    }

    public PerspectiveLodCalculator(Camera cam, float pixelError) {
        this.cam = cam;
        this.pixelError = pixelError;
    }

    private float getCameraConstant(Camera cam, float pixelLimit) {
        float n = cam.getFrustumNear();
        float t = FastMath.abs((float)cam.getFrustumTop());
        float A = n / t;
        float v_res = cam.getHeight();
        float T = 2.0f * pixelLimit / v_res;
        return A / T;
    }

    @Override
    public boolean calculateLod(TerrainPatch patch, List<Vector3f> locations, HashMap<String, UpdatedTerrainPatch> updates) {
        if (this.turnOffLod) {
            int prevLOD = patch.getLod();
            UpdatedTerrainPatch utp = updates.get(patch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(patch);
                updates.put(utp.getName(), utp);
            }
            utp.setNewLod(0);
            utp.setPreviousLod(prevLOD);
            return true;
        }
        float[] lodEntropies = patch.getLodEntropies();
        float cameraConstant = this.getCameraConstant(this.cam, this.pixelError);
        Vector3f patchPos = this.getCenterLocation(patch);
        float distance = patchPos.distance(locations.get(0));
        for (int i = 0; i <= patch.getMaxLod(); ++i) {
            if (!(distance < lodEntropies[i] * cameraConstant) && i != patch.getMaxLod()) continue;
            boolean reIndexNeeded = false;
            if (i != patch.getLod()) {
                reIndexNeeded = true;
            }
            int prevLOD = patch.getLod();
            UpdatedTerrainPatch utp = updates.get(patch.getName());
            if (utp == null) {
                utp = new UpdatedTerrainPatch(patch);
                updates.put(utp.getName(), utp);
            }
            utp.setNewLod(i);
            utp.setPreviousLod(prevLOD);
            return reIndexNeeded;
        }
        return false;
    }

    public Vector3f getCenterLocation(TerrainPatch patch) {
        Vector3f loc = patch.getWorldTranslation().clone();
        loc.x += (float)(patch.getSize() / 2);
        loc.z += (float)(patch.getSize() / 2);
        return loc;
    }

    @Override
    public PerspectiveLodCalculator clone() {
        try {
            return (PerspectiveLodCalculator)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter ex) throws IOException {
    }

    public void read(JmeImporter im) throws IOException {
    }

    @Override
    public boolean usesVariableLod() {
        return true;
    }

    public float getPixelError() {
        return this.pixelError;
    }

    public void setPixelError(float pixelError) {
        this.pixelError = pixelError;
    }

    public void setCam(Camera cam) {
        this.cam = cam;
    }

    @Override
    public void turnOffLod() {
        this.turnOffLod = true;
    }

    @Override
    public boolean isLodOff() {
        return this.turnOffLod;
    }

    @Override
    public void turnOnLod() {
        this.turnOffLod = false;
    }
}

