/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.TerrainGrid;
import com.jme3.terrain.geomipmap.TerrainGridListener;
import com.jme3.terrain.geomipmap.TerrainLodControl;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculator;
import com.jme3.util.SafeArrayList;

public class TerrainGridLodControl
extends TerrainLodControl {
    public TerrainGridLodControl(Terrain terrain, Camera camera) {
        super(terrain, camera);
    }

    @Override
    protected void updateLOD(SafeArrayList<Vector3f> locations, LodCalculator lodCalculator) {
        TerrainGrid terrainGrid = (TerrainGrid)this.getSpatial();
        Vector3f cam = locations.isEmpty() ? Vector3f.ZERO.clone() : (Vector3f)locations.get(0);
        Vector3f camCell = terrainGrid.getCamCell(cam);
        if (terrainGrid.cellsLoaded > 1) {
            terrainGrid.gridOffset[0] = Math.round(camCell.x * (float)(terrainGrid.size / 2));
            terrainGrid.gridOffset[1] = Math.round(camCell.z * (float)(terrainGrid.size / 2));
            terrainGrid.cellsLoaded = 0;
        }
        if (camCell.x != terrainGrid.currentCamCell.x || camCell.z != terrainGrid.currentCamCell.z || !terrainGrid.runOnce) {
            terrainGrid.updateChildren(camCell);
            for (TerrainGridListener l : terrainGrid.listeners) {
                l.gridMoved(camCell);
            }
        }
        terrainGrid.runOnce = true;
        super.updateLOD(locations, lodCalculator);
    }
}

