/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.fractal;

import com.jme3.terrain.noise.Basis;
import com.jme3.terrain.noise.ShaderUtils;
import com.jme3.terrain.noise.basis.ImprovedNoise;
import com.jme3.terrain.noise.basis.Noise;
import com.jme3.terrain.noise.fractal.Fractal;

public class FractalSum
extends Noise
implements Fractal {
    private Basis basis = new ImprovedNoise();
    private float lacunarity = 2.124367f;
    private float amplitude = 1.0f;
    private float roughness = 0.6f;
    private float frequency = 1.0f;
    private float octaves;
    private int maxFreq;

    public FractalSum() {
        this.setOctaves(1.0f);
    }

    @Override
    public float value(float x, float y, float z) {
        float total = 0.0f;
        float f = this.frequency;
        float a = this.amplitude;
        while (f < (float)this.maxFreq) {
            total += this.basis.value(this.scale * x * f, this.scale * y * f, this.scale * z * f) * a;
            f *= this.lacunarity;
            a *= this.roughness;
        }
        return ShaderUtils.clamp(total, -1.0f, 1.0f);
    }

    @Override
    public Fractal addBasis(Basis basis) {
        this.basis = basis;
        return this;
    }

    public float getOctaves() {
        return this.octaves;
    }

    @Override
    public Fractal setOctaves(float octaves) {
        this.octaves = octaves;
        this.maxFreq = 1 << (int)octaves;
        return this;
    }

    public float getFrequency() {
        return this.frequency;
    }

    @Override
    public Fractal setFrequency(float frequency) {
        this.frequency = frequency;
        return this;
    }

    public float getRoughness() {
        return this.roughness;
    }

    @Override
    public Fractal setRoughness(float roughness) {
        this.roughness = roughness;
        return this;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    @Override
    public Fractal setAmplitude(float amplitude) {
        this.amplitude = amplitude;
        return this;
    }

    public float getLacunarity() {
        return this.lacunarity;
    }

    @Override
    public Fractal setLacunarity(float lacunarity) {
        this.lacunarity = lacunarity;
        return this;
    }

    @Override
    public void init() {
    }
}

